/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.config;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcodedb.config.ManateeDataSource;
import com.manatee.lowcodedb.config.ManateeMultiDataSourceProp;
import com.manatee.lowcodedb.connector.ManateeConnector;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.seata.rm.datasource.DataSourceProxy;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.stereotype.Service;

@Service
public class ManateeDataSourceManager
implements InitializingBean {
    private static Log log = LogFactory.getLog(ManateeDataSourceManager.class);
    @Value(value="${seata.tx-service-group:}")
    private String txServiceGroup;
    @Value(value="${spring.datasource.type:}")
    private String datasourceType;
    @Autowired
    private ManateeMultiDataSourceProp dataSourceProp;

    public void afterPropertiesSet() {
        if (this.dataSourceProp.getDbs() != null && this.dataSourceProp.getDbs().size() > 0) {
            ManateeConnector manateeConnector = ManateeConnector.createDataSourceConnector(this.datasourceType);
            for (ManateeMultiDataSourceProp.DB db : this.dataSourceProp.getDbs()) {
                DataSource dbsDataSource = manateeConnector.createDataSource(db.getDatasource());
                if (dbsDataSource == null) continue;
                if (StringUtil.isNotBlank((String)this.txServiceGroup)) {
                    ManateeDataSource.addDataSource(db.getDatasource().getName(), (DataSource)new DataSourceProxy(dbsDataSource));
                    continue;
                }
                ManateeDataSource.addDataSource(db.getDatasource().getName(), dbsDataSource);
            }
        }
    }

    public static HikariDataSource create(DataSourceProperties dataSourceProperties) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setUsername(dataSourceProperties.getUsername());
        hikariConfig.setPassword(dataSourceProperties.getPassword());
        hikariConfig.setJdbcUrl(dataSourceProperties.getUrl());
        if (StringUtil.isNotBlank((String)dataSourceProperties.getDriverClassName())) {
            hikariConfig.setDriverClassName(dataSourceProperties.getDriverClassName());
        }
        hikariConfig.setMaximumPoolSize(10);
        hikariConfig.setMinimumIdle(10);
        return new HikariDataSource(hikariConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean checkDataSourceConnection(JSONObject dataSource) {
        String username = dataSource.getString("username");
        String password = dataSource.getString("password");
        String url = dataSource.getString("url");
        Connection con = null;
        try {
            con = DriverManager.getConnection(url, username, password);
            Boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            log.warn((Object)("[ManateeDataSourceManager.checkDataSourceConnection]_fail_\u6570\u636e\u6e90\u8fde\u63a5\u68c0\u67e5\u4e0d\u901a\u8fc7," + e.getMessage()));
            Boolean bl = false;
            return bl;
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                    log.info((Object)"[ManateeDataSourceManager.checkDataSourceConnection]_success_\u6570\u636e\u6e90\u8fde\u63a5\u68c0\u67e5\u901a\u8fc7,\u8fde\u63a5\u5df2\u6b63\u5e38\u5173\u95ed\u3002");
                }
                catch (SQLException e) {
                    log.error((Object)("[ManateeDataSourceManager.checkDataSourceConnection]_fail__\u6570\u636e\u6e90\u8fde\u63a5\u68c0\u67e5,\u8fde\u63a5\u5173\u95ed\u53d1\u751f\u5f02\u5e38," + e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
    }

    public static void addProjectConfDbs(JSONArray dbs) {
        if (dbs != null && dbs.size() > 0) {
            for (Object db : dbs) {
                if (!(db instanceof JSONObject)) continue;
                ManateeDataSourceManager.addDd((JSONObject)db);
            }
        }
    }

    public static void addProjectConfDbsV2(JSONArray dbs, String datasourceType) {
        if (dbs != null && dbs.size() > 0) {
            ManateeConnector manateeConnector = ManateeConnector.createDataSourceConnector(datasourceType);
            for (Object db : dbs) {
                if (!(db instanceof JSONObject)) continue;
                manateeConnector.addDataSource((JSONObject)db);
            }
        }
    }

    public static void addDd(JSONObject dbJson) {
        Integer minimumIdle;
        String url;
        String password;
        String name = dbJson.getString("name");
        assert (StringUtil.isNotBlank((String)name));
        String username = dbJson.getString("username");
        if (ManateeDataSourceManager.isDbAlreadyExist(name, username, password = dbJson.getString("password"), url = dbJson.getString("url")).booleanValue()) {
            log.info((Object)("[ManateeDataSourceManager.addDd]_warn: " + name + " \u6570\u636e\u6e90\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0"));
            return;
        }
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setUsername(username);
        hikariConfig.setPassword(password);
        hikariConfig.setJdbcUrl(url);
        Integer maximumPoolSize = dbJson.getInteger("maximumPoolSize");
        if (maximumPoolSize != null) {
            hikariConfig.setMaximumPoolSize(maximumPoolSize.intValue());
        }
        if ((minimumIdle = dbJson.getInteger("minimumIdle")) != null) {
            hikariConfig.setMinimumIdle(minimumIdle.intValue());
        }
        log.warn((Object)("[ManateeDataSourceManager.addDd]_warn: " + name + " \u52a8\u6001\u6570\u636e\u6e90\u6dfb\u52a0\u6210\u529f"));
        ManateeDataSource.addDataSource(name, (DataSource)new HikariDataSource(hikariConfig));
    }

    private static Boolean isDbAlreadyExist(String name, String username, String password, String url) {
        if ("default".equals(name)) {
            throw new RuntimeException("\u9ed8\u8ba4\u4e3b\u6570\u636e\u6e90\u4e0d\u53ef\u8986\u76d6\u548c\u6dfb\u52a0");
        }
        if (ManateeDataSource.getDataSourceNameSet().contains(name)) {
            HikariDataSource oldDataSource = (HikariDataSource)ManateeDataSource.dataSourceMap.get(name);
            StringBuilder oldSataSourceSb = new StringBuilder();
            oldSataSourceSb.append(oldDataSource.getJdbcUrl()).append(oldDataSource.getUsername()).append(oldDataSource.getPassword());
            StringBuilder newDataSourceSb = new StringBuilder();
            newDataSourceSb.append(url).append(username).append(password);
            if (oldSataSourceSb.toString().equals(newDataSourceSb.toString())) {
                return true;
            }
            return false;
        }
        return false;
    }

    public static Boolean deleteDb(String name) {
        if ("default".equals(name)) {
            throw new RuntimeException("\u9ed8\u8ba4\u4e3b\u6570\u636e\u6e90\u4e0d\u53ef\u5220\u9664");
        }
        if (StringUtil.isNotBlank((String)name)) {
            Closeable closeable;
            if (ManateeDataSource.dataSourceMap.containsKey(name) && (closeable = (Closeable)((Object)ManateeDataSource.dataSourceMap.get(name))) != null) {
                try {
                    closeable.close();
                    log.info((Object)("[ManateeDataSourceManager.deleteDb]_info: datasource " + name + " destroy......................"));
                }
                catch (IOException e) {
                    log.error((Object)("[ManateeDataSourceManager.deleteDb]_exception: \u6570\u636e\u6e90\u8fde\u63a5\u91ca\u653e\u5931\u8d25\uff1a" + name + "," + e.getMessage()));
                    e.printStackTrace();
                }
            }
            ManateeDataSource.dataSourceMap.remove(name);
            if (!ManateeDataSource.dataSourceMap.containsKey(name)) {
                return true;
            }
        } else {
            log.error((Object)"[ManateeDataSourceManager.deleteDb]_exception: name \u4e3a\u7a7a\u3002");
            throw new RuntimeException("name \u4e3a\u7a7a");
        }
        return false;
    }
}

