/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.excel.util;

import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ooxml.POIXMLRelation;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.core.io.ClassPathResource;

public class WaterMarkHandler
implements SheetWriteHandler {
    private final String WATER_MARK;

    public static ByteArrayOutputStream createWaterMark(String content) throws IOException {
        int width = 320;
        int height = 180;
        BufferedImage image = new BufferedImage(width, height, 1);
        int fontStyle = 0;
        int fontSize = 20;
        Font font = null;
        try {
            ClassPathResource resource = new ClassPathResource("font/msyhbd.ttf");
            InputStream fi = resource.getInputStream();
            BufferedInputStream fb = new BufferedInputStream(fi);
            font = Font.createFont(fontStyle, fb);
            font = font.deriveFont(fontStyle, fontSize);
        }
        catch (FontFormatException e) {
            font = new Font(null, fontStyle, fontSize);
        }
        Graphics2D g2d = image.createGraphics();
        image = g2d.getDeviceConfiguration().createCompatibleImage(width, height, 3);
        g2d.dispose();
        g2d = image.createGraphics();
        g2d.setColor(new Color(0, 0, 0, 15));
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setFont(font);
        g2d.rotate(-0.5, (double)image.getWidth() / 2.0, (double)image.getHeight() / 2.0);
        FontRenderContext context = g2d.getFontRenderContext();
        Rectangle2D bounds = font.getStringBounds(content, context);
        double x = ((double)width - bounds.getWidth()) / 2.0;
        double y = ((double)height - bounds.getHeight()) / 2.0;
        double ascent = -bounds.getY();
        double baseY = y + ascent;
        g2d.drawString(content, (int)x, (int)baseY);
        g2d.setComposite(AlphaComposite.getInstance(3));
        g2d.dispose();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", os);
        return os;
    }

    public static void putWaterRemarkToExcel(XSSFSheet sheet, byte[] bytes) {
        XSSFWorkbook workbook = sheet.getWorkbook();
        int pictureIdx = workbook.addPicture(bytes, 6);
        String rID = sheet.addRelation(null, (POIXMLRelation)XSSFRelation.IMAGES, (POIXMLDocumentPart)workbook.getAllPictures().get(pictureIdx)).getRelationship().getId();
        sheet.getCTWorksheet().addNewPicture().setId(rID);
    }

    public void beforeSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
    }

    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        try (ByteArrayOutputStream waterMark = WaterMarkHandler.createWaterMark(this.WATER_MARK);){
            XSSFSheet sheet = (XSSFSheet)writeSheetHolder.getSheet();
            WaterMarkHandler.putWaterRemarkToExcel(sheet, waterMark.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public WaterMarkHandler(String WATER_MARK) {
        this.WATER_MARK = WATER_MARK;
    }
}

