/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.excel.domain;

import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class WriteExcelBO {
    List<Map<String, Object>> list;
    String sheetName;
    String file;
    String titleName;
    List<Object> head;
    JSONObject headStyle;
    JSONObject titleStyle;
    String summaryInfo;
    JSONObject summaryStyle;
    JSONObject columnWidthStyle;

    public List<List<Object>> getDataList() {
        List<Object> summary;
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        List<Object> title = this.getTitle();
        List<Object> headList = this.getHeadList();
        if (title != null) {
            data.add(title);
        }
        if ((summary = this.getSummary()) != null) {
            data.add(summary);
        }
        data.add(headList);
        for (Map<String, Object> map : this.list) {
            ArrayList<Object> aList = new ArrayList<Object>();
            for (Map.Entry<String, Object> aMap : map.entrySet()) {
                aList.add(aMap.getValue());
            }
            data.add(aList);
        }
        return data;
    }

    public List<List<Object>> getDataList2(Boolean isHead) {
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        if (isHead.booleanValue()) {
            List<Object> summary;
            List<Object> title = this.getTitle();
            List<Object> headList = this.getHeadList();
            if (title != null) {
                data.add(title);
            }
            if ((summary = this.getSummary()) != null) {
                data.add(summary);
            }
            data.add(headList);
        }
        for (Map<String, Object> map : this.list) {
            ArrayList<Object> aList = new ArrayList<Object>();
            for (Map.Entry<String, Object> aMap : map.entrySet()) {
                aList.add(aMap.getValue());
            }
            data.add(aList);
        }
        return data;
    }

    public List<Object> getTitle() {
        if (StringUtil.isBlank((String)this.titleName)) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        WriteCellData writeCellData = new WriteCellData(this.titleName);
        for (int i = 0; i < this.head.size(); ++i) {
            result.add(writeCellData);
        }
        WriteCellStyle writeCellStyle = new WriteCellStyle();
        writeCellData.setWriteCellStyle(writeCellStyle);
        writeCellStyle.setBorderBottom(BorderStyle.THIN);
        writeCellStyle.setBorderTop(BorderStyle.THIN);
        writeCellStyle.setBorderLeft(BorderStyle.THIN);
        writeCellStyle.setBorderRight(BorderStyle.THIN);
        writeCellStyle.setBottomBorderColor(Short.valueOf(IndexedColors.BLACK.getIndex()));
        writeCellStyle.setTopBorderColor(Short.valueOf(IndexedColors.BLACK.getIndex()));
        writeCellStyle.setRightBorderColor(Short.valueOf(IndexedColors.BLACK.getIndex()));
        writeCellStyle.setLeftBorderColor(Short.valueOf(IndexedColors.BLACK.getIndex()));
        writeCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        writeCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        if (this.titleStyle == null) {
            return result;
        }
        JSONObject fillObj = this.titleStyle.getJSONObject("fill");
        JSONObject contentObj = this.titleStyle.getJSONObject("content");
        if (fillObj != null && StringUtil.isNotBlank((String)fillObj.getString("color"))) {
            writeCellStyle.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
            writeCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.valueOf((String)fillObj.getString("color")).getIndex()));
        }
        if (contentObj != null && StringUtil.isNotBlank((String)contentObj.getString("color"))) {
            WriteFont writeFont = new WriteFont();
            writeFont.setColor(Short.valueOf(IndexedColors.valueOf((String)contentObj.getString("color")).getIndex()));
            writeCellStyle.setWriteFont(writeFont);
        }
        return result;
    }

    public List<Object> getHeadList() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object headObj : this.head) {
            JSONObject jsonObject;
            if (headObj == null) continue;
            String headStr = (String)headObj;
            WriteCellData writeCellData = new WriteCellData(headStr);
            result.add(writeCellData);
            String fill = null;
            String content = null;
            if (this.headStyle != null && (jsonObject = this.headStyle.getJSONObject(headStr)) != null) {
                fill = jsonObject.getString("fill");
                content = jsonObject.getString("content");
            }
            WriteCellStyle writeCellStyle = new WriteCellStyle();
            writeCellData.setWriteCellStyle(writeCellStyle);
            writeCellStyle.setBorderBottom(BorderStyle.THIN);
            writeCellStyle.setBorderTop(BorderStyle.THIN);
            writeCellStyle.setBorderLeft(BorderStyle.THIN);
            writeCellStyle.setBorderRight(BorderStyle.THIN);
            writeCellStyle.setBottomBorderColor(Short.valueOf(IndexedColors.BLACK.getIndex()));
            writeCellStyle.setTopBorderColor(Short.valueOf(IndexedColors.BLACK.getIndex()));
            writeCellStyle.setRightBorderColor(Short.valueOf(IndexedColors.BLACK.getIndex()));
            writeCellStyle.setLeftBorderColor(Short.valueOf(IndexedColors.BLACK.getIndex()));
            if (StringUtil.isNotBlank((String)fill)) {
                writeCellStyle.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
                writeCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.valueOf((String)fill).getIndex()));
            }
            if (!StringUtil.isNotBlank((String)content)) continue;
            WriteFont writeFont = new WriteFont();
            writeFont.setColor(Short.valueOf(IndexedColors.valueOf((String)content).getIndex()));
            writeCellStyle.setWriteFont(writeFont);
        }
        return result;
    }

    public List<Object> getSummary() {
        if (StringUtil.isBlank((String)this.summaryInfo)) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        WriteCellData writeCellData = new WriteCellData(this.summaryInfo);
        for (int i = 0; i < this.head.size(); ++i) {
            result.add(writeCellData);
        }
        WriteCellStyle writeCellStyle = new WriteCellStyle();
        writeCellData.setWriteCellStyle(writeCellStyle);
        writeCellStyle.setBorderBottom(BorderStyle.THIN);
        writeCellStyle.setBorderTop(BorderStyle.THIN);
        writeCellStyle.setBorderLeft(BorderStyle.THIN);
        writeCellStyle.setBorderRight(BorderStyle.THIN);
        writeCellStyle.setBottomBorderColor(Short.valueOf(IndexedColors.BLACK.getIndex()));
        writeCellStyle.setTopBorderColor(Short.valueOf(IndexedColors.BLACK.getIndex()));
        writeCellStyle.setRightBorderColor(Short.valueOf(IndexedColors.BLACK.getIndex()));
        writeCellStyle.setLeftBorderColor(Short.valueOf(IndexedColors.BLACK.getIndex()));
        writeCellStyle.setHorizontalAlignment(HorizontalAlignment.LEFT);
        writeCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        writeCellStyle.setWrapped(Boolean.valueOf(true));
        if (this.summaryStyle == null) {
            return result;
        }
        JSONObject fillObj = this.summaryStyle.getJSONObject("fill");
        JSONObject contentObj = this.summaryStyle.getJSONObject("content");
        if (fillObj != null && StringUtil.isNotBlank((String)fillObj.getString("color"))) {
            writeCellStyle.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
            writeCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.valueOf((String)fillObj.getString("color")).getIndex()));
        }
        if (contentObj != null && StringUtil.isNotBlank((String)contentObj.getString("color"))) {
            WriteFont writeFont = new WriteFont();
            writeFont.setColor(Short.valueOf(IndexedColors.valueOf((String)contentObj.getString("color")).getIndex()));
            writeCellStyle.setWriteFont(writeFont);
        }
        return result;
    }

    public List<Map<String, Object>> getList() {
        return this.list;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public String getFile() {
        return this.file;
    }

    public String getTitleName() {
        return this.titleName;
    }

    public List<Object> getHead() {
        return this.head;
    }

    public JSONObject getHeadStyle() {
        return this.headStyle;
    }

    public JSONObject getTitleStyle() {
        return this.titleStyle;
    }

    public String getSummaryInfo() {
        return this.summaryInfo;
    }

    public JSONObject getSummaryStyle() {
        return this.summaryStyle;
    }

    public JSONObject getColumnWidthStyle() {
        return this.columnWidthStyle;
    }

    public void setList(List<Map<String, Object>> list) {
        this.list = list;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setTitleName(String titleName) {
        this.titleName = titleName;
    }

    public void setHead(List<Object> head) {
        this.head = head;
    }

    public void setHeadStyle(JSONObject headStyle) {
        this.headStyle = headStyle;
    }

    public void setTitleStyle(JSONObject titleStyle) {
        this.titleStyle = titleStyle;
    }

    public void setSummaryInfo(String summaryInfo) {
        this.summaryInfo = summaryInfo;
    }

    public void setSummaryStyle(JSONObject summaryStyle) {
        this.summaryStyle = summaryStyle;
    }

    public void setColumnWidthStyle(JSONObject columnWidthStyle) {
        this.columnWidthStyle = columnWidthStyle;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WriteExcelBO)) {
            return false;
        }
        WriteExcelBO other = (WriteExcelBO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Map<String, Object>> this$list = this.getList();
        List<Map<String, Object>> other$list = other.getList();
        if (this$list == null ? other$list != null : !((Object)this$list).equals(other$list)) {
            return false;
        }
        String this$sheetName = this.getSheetName();
        String other$sheetName = other.getSheetName();
        if (this$sheetName == null ? other$sheetName != null : !this$sheetName.equals(other$sheetName)) {
            return false;
        }
        String this$file = this.getFile();
        String other$file = other.getFile();
        if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
            return false;
        }
        String this$titleName = this.getTitleName();
        String other$titleName = other.getTitleName();
        if (this$titleName == null ? other$titleName != null : !this$titleName.equals(other$titleName)) {
            return false;
        }
        List<Object> this$head = this.getHead();
        List<Object> other$head = other.getHead();
        if (this$head == null ? other$head != null : !((Object)this$head).equals(other$head)) {
            return false;
        }
        JSONObject this$headStyle = this.getHeadStyle();
        JSONObject other$headStyle = other.getHeadStyle();
        if (this$headStyle == null ? other$headStyle != null : !this$headStyle.equals(other$headStyle)) {
            return false;
        }
        JSONObject this$titleStyle = this.getTitleStyle();
        JSONObject other$titleStyle = other.getTitleStyle();
        if (this$titleStyle == null ? other$titleStyle != null : !this$titleStyle.equals(other$titleStyle)) {
            return false;
        }
        String this$summaryInfo = this.getSummaryInfo();
        String other$summaryInfo = other.getSummaryInfo();
        if (this$summaryInfo == null ? other$summaryInfo != null : !this$summaryInfo.equals(other$summaryInfo)) {
            return false;
        }
        JSONObject this$summaryStyle = this.getSummaryStyle();
        JSONObject other$summaryStyle = other.getSummaryStyle();
        if (this$summaryStyle == null ? other$summaryStyle != null : !this$summaryStyle.equals(other$summaryStyle)) {
            return false;
        }
        JSONObject this$columnWidthStyle = this.getColumnWidthStyle();
        JSONObject other$columnWidthStyle = other.getColumnWidthStyle();
        return !(this$columnWidthStyle == null ? other$columnWidthStyle != null : !this$columnWidthStyle.equals(other$columnWidthStyle));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WriteExcelBO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Map<String, Object>> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        String $sheetName = this.getSheetName();
        result = result * 59 + ($sheetName == null ? 43 : $sheetName.hashCode());
        String $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        String $titleName = this.getTitleName();
        result = result * 59 + ($titleName == null ? 43 : $titleName.hashCode());
        List<Object> $head = this.getHead();
        result = result * 59 + ($head == null ? 43 : ((Object)$head).hashCode());
        JSONObject $headStyle = this.getHeadStyle();
        result = result * 59 + ($headStyle == null ? 43 : $headStyle.hashCode());
        JSONObject $titleStyle = this.getTitleStyle();
        result = result * 59 + ($titleStyle == null ? 43 : $titleStyle.hashCode());
        String $summaryInfo = this.getSummaryInfo();
        result = result * 59 + ($summaryInfo == null ? 43 : $summaryInfo.hashCode());
        JSONObject $summaryStyle = this.getSummaryStyle();
        result = result * 59 + ($summaryStyle == null ? 43 : $summaryStyle.hashCode());
        JSONObject $columnWidthStyle = this.getColumnWidthStyle();
        result = result * 59 + ($columnWidthStyle == null ? 43 : $columnWidthStyle.hashCode());
        return result;
    }

    public String toString() {
        return "WriteExcelBO(list=" + this.getList() + ", sheetName=" + this.getSheetName() + ", file=" + this.getFile() + ", titleName=" + this.getTitleName() + ", head=" + this.getHead() + ", headStyle=" + this.getHeadStyle() + ", titleStyle=" + this.getTitleStyle() + ", summaryInfo=" + this.getSummaryInfo() + ", summaryStyle=" + this.getSummaryStyle() + ", columnWidthStyle=" + this.getColumnWidthStyle() + ")";
    }
}

