/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.kafka.domain;

import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.config.ManateeConfig;
import com.manatee.kafka.config.ManateeKfakaConfig;
import com.manatee.kafka.process.KfakaConsumerRunnable;
import com.manatee.lowcode.web.manager.ModularityManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.common.KafkaFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTopicScanThread
extends Thread {
    private Logger log = LoggerFactory.getLogger(KafkaTopicScanThread.class);
    private AdminClient adminClient;
    private ManateeKfakaConfig kfakaConfig;
    private ModularityManager modularityManager;
    private ManateeConfig manateeConfig;

    @Override
    public void run() {
        ListTopicsResult result = this.adminClient.listTopics();
        KafkaFuture names = result.names();
        try {
            this.log.warn("manatee kafka scan topic: \u3010{}\u3011", names.get());
            String manateeTops = this.manateeConfig.getKafka().getTopics();
            List<Object> topList = new ArrayList();
            if (StrUtil.isNotBlank((CharSequence)manateeTops)) {
                String[] split = manateeTops.split(",");
                topList = Arrays.asList(split);
            }
            this.log.warn("manatee kafka topic: \u3010{}\u3011", topList);
            for (String string : (Set)names.get()) {
                boolean contains = topList.contains(string);
                if (!contains) {
                    this.log.warn("manatee kafka not contains topic: \u3010{}\u3011", (Object)string);
                    continue;
                }
                if (ManateeKfakaConfig.kafkaConsumerRunnablePool.containsKey(string)) continue;
                this.log.warn("manatee kafka\u65b0\u589e\u76d1\u542ctopic: " + string);
                KfakaConsumerRunnable consumerRunnable = new KfakaConsumerRunnable();
                consumerRunnable.setConsumerConfigs(this.kfakaConfig.consumerConfigs());
                consumerRunnable.setTopicName(string);
                consumerRunnable.setModularityManager(this.modularityManager);
                ManateeKfakaConfig.kafkaConsumerRunnablePool.put(string, consumerRunnable);
                consumerRunnable.start();
            }
            for (String string : topList) {
                if (ManateeKfakaConfig.kafkaConsumerRunnablePool.containsKey(string)) continue;
                this.log.warn("manatee kafka\u65b0\u589e\u76d1\u542ctopic: " + string);
                KfakaConsumerRunnable consumerRunnable = new KfakaConsumerRunnable();
                consumerRunnable.setConsumerConfigs(this.kfakaConfig.consumerConfigs());
                consumerRunnable.setTopicName(string);
                consumerRunnable.setModularityManager(this.modularityManager);
                ManateeKfakaConfig.kafkaConsumerRunnablePool.put(string, consumerRunnable);
                consumerRunnable.start();
            }
        }
        catch (Exception e) {
            this.log.error("manatee kafka scan topic error", (Throwable)e);
        }
    }

    public Logger getLog() {
        return this.log;
    }

    public AdminClient getAdminClient() {
        return this.adminClient;
    }

    public ManateeKfakaConfig getKfakaConfig() {
        return this.kfakaConfig;
    }

    public ModularityManager getModularityManager() {
        return this.modularityManager;
    }

    public ManateeConfig getManateeConfig() {
        return this.manateeConfig;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public void setAdminClient(AdminClient adminClient) {
        this.adminClient = adminClient;
    }

    public void setKfakaConfig(ManateeKfakaConfig kfakaConfig) {
        this.kfakaConfig = kfakaConfig;
    }

    public void setModularityManager(ModularityManager modularityManager) {
        this.modularityManager = modularityManager;
    }

    public void setManateeConfig(ManateeConfig manateeConfig) {
        this.manateeConfig = manateeConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaTopicScanThread)) {
            return false;
        }
        KafkaTopicScanThread other = (KafkaTopicScanThread)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Logger this$log = this.getLog();
        Logger other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        AdminClient this$adminClient = this.getAdminClient();
        AdminClient other$adminClient = other.getAdminClient();
        if (this$adminClient == null ? other$adminClient != null : !this$adminClient.equals(other$adminClient)) {
            return false;
        }
        ManateeKfakaConfig this$kfakaConfig = this.getKfakaConfig();
        ManateeKfakaConfig other$kfakaConfig = other.getKfakaConfig();
        if (this$kfakaConfig == null ? other$kfakaConfig != null : !this$kfakaConfig.equals(other$kfakaConfig)) {
            return false;
        }
        ModularityManager this$modularityManager = this.getModularityManager();
        ModularityManager other$modularityManager = other.getModularityManager();
        if (this$modularityManager == null ? other$modularityManager != null : !this$modularityManager.equals(other$modularityManager)) {
            return false;
        }
        ManateeConfig this$manateeConfig = this.getManateeConfig();
        ManateeConfig other$manateeConfig = other.getManateeConfig();
        return !(this$manateeConfig == null ? other$manateeConfig != null : !this$manateeConfig.equals(other$manateeConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaTopicScanThread;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Logger $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        AdminClient $adminClient = this.getAdminClient();
        result = result * 59 + ($adminClient == null ? 43 : $adminClient.hashCode());
        ManateeKfakaConfig $kfakaConfig = this.getKfakaConfig();
        result = result * 59 + ($kfakaConfig == null ? 43 : $kfakaConfig.hashCode());
        ModularityManager $modularityManager = this.getModularityManager();
        result = result * 59 + ($modularityManager == null ? 43 : $modularityManager.hashCode());
        ManateeConfig $manateeConfig = this.getManateeConfig();
        result = result * 59 + ($manateeConfig == null ? 43 : $manateeConfig.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "KafkaTopicScanThread(log=" + this.getLog() + ", adminClient=" + this.getAdminClient() + ", kfakaConfig=" + this.getKfakaConfig() + ", modularityManager=" + this.getModularityManager() + ", manateeConfig=" + this.getManateeConfig() + ")";
    }
}

