/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.function.collection;

import com.manatee.common.util.NumberUtils;
import com.manatee.common.util.StringUtil;
import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class SortListFun
extends AbstractFunction {
    private String name = "sortList";

    public String getName() {
        return this.name;
    }

    public Object doFunction(FunctionContent content) {
        List<Map<String, Object>> mapList;
        this.checkParamSize(content);
        if (!this.checkParamExist(content).booleanValue()) {
            return null;
        }
        List parameters = content.getParameters();
        List list = (List)content.getParameter(0);
        if (parameters.size() == 5) {
            String key1 = content.getStrParameter(1);
            String sort1 = content.getStrParameter(2);
            String key2 = content.getStrParameter(3);
            String sort2 = content.getStrParameter(4);
            ArrayList<Boolean> sorts = new ArrayList<Boolean>();
            List<String> keys = Arrays.asList(key1, key2);
            if (StringUtil.isNotBlank((String)sort1) && "desc".equalsIgnoreCase(sort1)) {
                sorts.add(false);
            } else {
                sorts.add(true);
            }
            if (StringUtil.isNotBlank((String)sort2) && "desc".equalsIgnoreCase(sort2)) {
                sorts.add(false);
            } else {
                sorts.add(true);
            }
            mapList = this.sortListByKeys(list, keys, sorts);
        } else {
            String sort;
            String key = content.getStrParameter(1);
            mapList = this.sortListByKey(list, key);
            if (parameters.size() > 2 && StringUtil.isNotBlank((String)(sort = content.getStrParameter(2))) && "desc".equals(sort.toLowerCase().trim())) {
                Collections.reverse(mapList);
            }
        }
        return mapList;
    }

    public Integer getMinParamSize() {
        return 2;
    }

    public Integer getMaxParamSize() {
        return 5;
    }

    public List<Map<String, Object>> sortListByKey(List<Map<String, Object>> list, String key) {
        if (list == null) {
            return null;
        }
        ArrayList<Map<String, Object>> sortList = new ArrayList<Map<String, Object>>();
        if (list.isEmpty()) {
            return sortList;
        }
        sortList.addAll(list);
        ListComparator listComparator = new ListComparator();
        listComparator.setKey(key);
        Collections.sort(sortList, listComparator);
        return sortList;
    }

    public List<Map<String, Object>> sortListByKeys(List<Map<String, Object>> list, List<String> keys, List<Boolean> sorts) {
        if (list == null) {
            return null;
        }
        ArrayList<Map<String, Object>> sortList = new ArrayList<Map<String, Object>>();
        if (list.isEmpty()) {
            return sortList;
        }
        sortList.addAll(list);
        MultiFieldListComparator multiFieldListComparator = new MultiFieldListComparator(keys, sorts);
        Collections.sort(sortList, multiFieldListComparator);
        return sortList;
    }

    static class MultiFieldListComparator
    implements Comparator<Map<String, Object>> {
        private List<String> sortKeys;
        private List<Boolean> ascending;

        public MultiFieldListComparator(List<String> sortKeys, List<Boolean> ascending) {
            if (sortKeys.size() != ascending.size()) {
                throw new IllegalArgumentException("Each sort key must have a corresponding ascending value.");
            }
            this.sortKeys = sortKeys;
            this.ascending = ascending;
        }

        @Override
        public int compare(Map<String, Object> map1, Map<String, Object> map2) {
            for (int i = 0; i < this.sortKeys.size(); ++i) {
                int result;
                String key = this.sortKeys.get(i);
                Boolean asc = this.ascending.get(i);
                Object val1 = map1.get(key);
                Object val2 = map2.get(key);
                if (val1 == null && val2 == null) continue;
                if (val1 == null) {
                    return asc != false ? 1 : -1;
                }
                if (val2 == null) {
                    return asc != false ? -1 : 1;
                }
                if (val1 instanceof String && val2 instanceof String) {
                    result = ((String)val1).compareTo((String)val2);
                    if (result == 0) continue;
                    return asc != false ? result : -result;
                }
                if (val1 instanceof Number && val2 instanceof Number) {
                    double double2;
                    double double1 = ((Number)val1).doubleValue();
                    int result2 = Double.compare(double1, double2 = ((Number)val2).doubleValue());
                    if (result2 == 0) continue;
                    return asc != false ? result2 : -result2;
                }
                if (!(val1 instanceof Date) || !(val2 instanceof Date) || (result = ((Date)val1).compareTo((Date)val2)) == 0) continue;
                return asc != false ? result : -result;
            }
            return 0;
        }
    }

    class ListComparator
    implements Comparator<Map<String, Object>> {
        private String key;

        ListComparator() {
        }

        public void setKey(String key) {
            this.key = key;
        }

        @Override
        public int compare(Map<String, Object> map1, Map<String, Object> map2) {
            Object obj1 = map1.get(this.key);
            Object obj2 = map2.get(this.key);
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 != null && obj2 == null) {
                return 1;
            }
            if (obj1 == null && obj2 != null) {
                return -1;
            }
            if (obj1 instanceof String && obj2 instanceof String) {
                String str1 = (String)obj1;
                String str2 = (String)obj2;
                return str1.compareTo(str2);
            }
            if (NumberUtils.isNumeric((String)(obj1 + "")) && NumberUtils.isNumeric((String)(obj2 + ""))) {
                Double double1 = Double.valueOf(obj1 + "");
                Double double2 = Double.valueOf(obj2 + "");
                return double1.compareTo(double2);
            }
            if (obj1 instanceof Date && obj2 instanceof Date) {
                Date date1 = (Date)obj1;
                Date date2 = (Date)obj2;
                return date1.compareTo(date2);
            }
            return 0;
        }
    }
}

