/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.fun.encrypt;

import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.lowcode.util.sm.SMUtil;
import com.manatee.lowcode.util.sm.sm2.SM2EncDecUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SM2EncryptFun
extends AbstractFunction {
    private static Logger LOGGER = LoggerFactory.getLogger(SM2EncryptFun.class);

    public String getName() {
        return "SM2Encrypt";
    }

    public Object doFunction(FunctionContent content) {
        this.checkParamSize(content);
        if (!this.checkParamExist(content).booleanValue()) {
            return null;
        }
        List parameters = content.getParameters();
        String publicKey = (String)parameters.get(0);
        String param = (String)parameters.get(1);
        byte[] sourceData = param.getBytes();
        try {
            String cipherText = SM2EncDecUtils.encrypt((byte[])SMUtil.hexToByte((String)publicKey), (byte[])sourceData);
            return cipherText;
        }
        catch (Exception e) {
            LOGGER.error("\u5bc6\u94a5\u9519\u8bef publicKey:{}, e:{}", (Object)publicKey, (Object)e);
            throw new RuntimeException(String.format("\u51fd\u6570\uff1a%s\uff0c\u56fd\u5bc62\u52a0\u5bc6\u5931\u8d25\uff0c\u516c\u94a5\u9519\u8bef", this.getName()));
        }
    }

    public Integer getMinParamSize() {
        return 2;
    }

    public Integer getMaxParamSize() {
        return 2;
    }
}

