/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.camunda.process.constants.BpmTaskStatusEnum;
import com.manatee.camunda.process.service.SpecifyNodeApprovalGateWay;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.common.util.tool.core.util.IdUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.Query;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.MultiInstanceLoopCharacteristics;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.bpmn.instance.UserTask;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaProperties;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ManateeTaskService {
    private static final Logger log = LoggerFactory.getLogger(ManateeTaskService.class);
    @Autowired
    private IdentityService identityService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Resource
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;

    public JSONObject withdraw(String userId, String taskId, String message) throws BizException {
        JSONObject r;
        String msg = "withdraw@@:" + message;
        String closeTaskVal = "withdraw@@:close";
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId).finished().singleResult();
        String processInstanceId = "";
        String processDefinitionId = "";
        String taskDefKey = "";
        String assignee = "";
        if (historicTaskInstance == null) {
            Task task2 = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
            if (task2 == null) {
                throw new BizException(ResultCode.SYSTEM_ERROR, "\u4efb\u52a1\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5");
            }
            processInstanceId = task2.getProcessInstanceId();
            processDefinitionId = task2.getProcessDefinitionId();
            taskDefKey = task2.getTaskDefinitionKey();
            assignee = task2.getAssignee();
        } else {
            processInstanceId = historicTaskInstance.getProcessInstanceId();
            processDefinitionId = historicTaskInstance.getProcessDefinitionId();
            taskDefKey = historicTaskInstance.getTaskDefinitionKey();
            assignee = historicTaskInstance.getAssignee();
        }
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new BizException(ResultCode.BIZ_ERROR, "\u6d41\u7a0b\u5df2\u7ed3\u675f\uff0c\u65e0\u6cd5\u53d6\u56de");
        }
        if (StringUtils.isNotBlank((CharSequence)assignee) && !userId.equals(assignee) && this.checkTaskIsForward(processInstanceId, taskDefKey, assignee)) {
            throw new BizException(ResultCode.SYSTEM_ERROR, "\u4efb\u52a1\u5df2\u8f6c\u4ea4\uff0c\u65e0\u6cd5\u53d6\u56de");
        }
        int nodeType = this.checkNodeType(processInstanceId, taskId, taskDefKey);
        if ((nodeType == 3 || nodeType == 1 || nodeType == 4) && (r = this.addSignerCanWithdraw(processInstanceId, taskId, taskDefKey, nodeType)) != null) {
            r.put("processId", (Object)processInstanceId);
            log.info("withdraw:{}", (Object)r.toJSONString());
            return r;
        }
        if (nodeType == 0 && historicTaskInstance == null) {
            throw new BizException(ResultCode.SYSTEM_ERROR, "\u4efb\u52a1\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5");
        }
        BpmnModelInstance bpmnModelInstance = this.repositoryService.getBpmnModelInstance(processDefinitionId);
        FlowNode element = (FlowNode)bpmnModelInstance.getModelElementById(this.getActivityId(taskDefKey));
        ArrayList<FlowNode> allNode = new ArrayList<FlowNode>();
        this.selectOutAllNode(element, allNode);
        ArrayList<FlowNode> allNode_ = new ArrayList<FlowNode>();
        this.selectOutAllNode(element, allNode_, false);
        List userTaskList = this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId).finished().list();
        List userTaskList1 = userTaskList.stream().filter(userTask -> allNode.stream().anyMatch(flowNode -> flowNode.getId().equals(userTask.getTaskDefinitionKey()))).filter(task -> this.historyService.createHistoricVariableInstanceQuery().variableName(closeTaskVal).taskIdIn(new String[]{task.getId()}).singleResult() == null).collect(Collectors.toList());
        ArrayList cancelTaskList = new ArrayList();
        ArrayList createTaskList = new ArrayList();
        List activeTaskList = this.taskService.createTaskQuery().processInstanceId(processInstanceId).active().list();
        List<Task> activeTaskList1 = activeTaskList.stream().filter(task -> allNode.stream().anyMatch(flowNode -> flowNode.getId().equals(task.getTaskDefinitionKey()))).collect(Collectors.toList());
        List activeTaskList2 = activeTaskList.stream().filter(task -> allNode_.stream().anyMatch(flowNode -> flowNode.getId().equals(task.getTaskDefinitionKey()))).collect(Collectors.toList());
        if (activeTaskList1.size() != activeTaskList2.size()) {
            throw new BizException(ResultCode.SYSTEM_ERROR, "\u4efb\u52a1\u65e0\u6cd5\u53d6\u56de,\u5df2\u5b58\u5728\u5b8c\u6210\u7684\u540e\u7eed\u4efb\u52a1");
        }
        FlowNode n = this.getNextParallelGateway(element);
        if (n == null && activeTaskList2.isEmpty()) {
            throw new BizException(ResultCode.SYSTEM_ERROR, "\u4efb\u52a1\u65e0\u6cd5\u53d6\u56de,\u5df2\u5b58\u5728\u5b8c\u6210\u7684\u540e\u7eed\u4efb\u52a1");
        }
        for (Object task3 : activeTaskList2) {
            JSONArray taskAddSignerHisNodeInfos;
            List<JSONObject> taskNodeList;
            int nt = this.checkNodeType(processInstanceId, task3.getId(), task3.getTaskDefinitionKey());
            if (nt == 2 || nt == 3 || nt == 4) {
                throw new BizException(ResultCode.SYSTEM_ERROR, "\u4efb\u52a1\u65e0\u6cd5\u53d6\u56de,\u540e\u7eed\u4efb\u52a1\u5df2\u6267\u884c\u52a0\u7b7e\u64cd\u4f5c");
            }
            if (nt != 1 || (long)(taskNodeList = this.getAddSignerNodeInfos((List)(taskAddSignerHisNodeInfos = JSONObject.parseArray((String)((String)this.taskService.getVariableLocal(task3.getId(), "MANATEE_TASK_ADD_SIGNER_HIS_NODE_INFO")))), "before")).size() == this.taskService.createTaskQuery().taskParentTaskId(task3.getId()).count()) continue;
            throw new BizException(ResultCode.SYSTEM_ERROR, "\u4efb\u52a1\u65e0\u6cd5\u53d6\u56de,\u540e\u7eed\u4efb\u52a1\u5df2\u6267\u884c\u52a0\u7b7e\u64cd\u4f5c");
        }
        ArrayList<FlowNode> inNodes = new ArrayList();
        for (Task activeTask : activeTaskList1) {
            FlowNode node = (FlowNode)bpmnModelInstance.getModelElementById(activeTask.getTaskDefinitionKey());
            this.selectInAllNode(node, inNodes, false, false);
        }
        String finalTaskDefKey = taskDefKey;
        inNodes = inNodes.stream().filter(flowNode -> !flowNode.getId().equals(finalTaskDefKey)).collect(Collectors.toList());
        ProcessInstanceModificationBuilder re = this.runtimeService.createProcessInstanceModification(processInstanceId);
        re.startBeforeActivity(taskDefKey);
        if (n != null) {
            if (activeTaskList1.isEmpty()) {
                List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityId(n.getId()).unfinished().list();
                ((HistoricActivityInstance)historicActivityInstances.get(0)).getExecutionId();
                re.cancelActivityInstance(((HistoricActivityInstance)historicActivityInstances.get(0)).getId());
            } else {
                inNodes.forEach(flowNode -> {
                    ProcessInstanceModificationInstantiationBuilder cfr_ignored_0 = (ProcessInstanceModificationInstantiationBuilder)re.startBeforeActivity(n.getId());
                });
            }
        }
        activeTaskList1.forEach(task -> this.taskService.setVariableLocal(task.getId(), closeTaskVal, (Object)closeTaskVal));
        String finalProcessInstanceId = processInstanceId;
        activeTaskList1.forEach(task -> {
            this.taskService.createComment(task.getId(), finalProcessInstanceId, msg);
            re.cancelAllForActivity(task.getTaskDefinitionKey());
            HashMap<String, String> c = new HashMap<String, String>();
            c.put("taskId", task.getId());
            c.put("taskDefKey", task.getTaskDefinitionKey());
            c.put("taskName", task.getName());
            c.put("assignee", task.getAssignee());
            c.put("processId", finalProcessInstanceId);
            cancelTaskList.add(c);
        });
        re.execute();
        this.taskService.createComment(taskId, processInstanceId, msg);
        JSONObject r2 = new JSONObject();
        if (nodeType == 1 || nodeType == 3) {
            r2 = this.addSignerBack(processInstanceId, taskDefKey);
        }
        r2.put("cancelTask", cancelTaskList);
        r2.put("processId", (Object)processInstanceId);
        log.info("withdraw:{}", (Object)r2.toJSONString());
        return r2;
    }

    public List<Task> checkTaskIsForward(List<Task> taskList) {
        ArrayList<Task> forwardTaskList = new ArrayList<Task>();
        for (Task task : taskList) {
            if (!this.checkTaskIsForward(task.getProcessInstanceId(), task.getTaskDefinitionKey(), task.getAssignee())) continue;
            forwardTaskList.add(task);
        }
        return forwardTaskList;
    }

    public boolean checkTaskIsForward(String processInstanceId, String taskDefKey, String assignee) {
        AtomicBoolean i = new AtomicBoolean(false);
        List historicVariableInstanceList = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceId).list();
        historicVariableInstanceList.forEach(historicVariableInstance -> {
            if (historicVariableInstance.getName().contains(taskDefKey) && historicVariableInstance.getName().contains("MANATEE_FORWARD_TASK_USER") && historicVariableInstance.getValue().toString().equals(assignee)) {
                i.set(true);
            }
        });
        return i.get();
    }

    public FlowNode getNextParallelGateway(FlowNode element) {
        Collection sequenceFlow = element.getOutgoing();
        Iterator entries = sequenceFlow.iterator();
        ArrayList<FlowNode> node = new ArrayList<FlowNode>();
        while (entries.hasNext()) {
            SequenceFlow flow = (SequenceFlow)entries.next();
            FlowNode element1 = flow.getTarget();
            node.add(element1);
        }
        for (FlowNode flowElement : node) {
            if (!Objects.equals(flowElement.getElementType().getTypeName(), "parallelGateway")) continue;
            return flowElement;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rejectToLastNode(String userId, String processInstanceId, String message, String currentTaskId, String newTaksId) throws BizException {
        if (StringUtils.equals((CharSequence)currentTaskId, (CharSequence)newTaksId)) {
            throw new BizException(ResultCode.SYSTEM_ERROR, "\u5f53\u524d\u4efb\u52a1\u4e0e\u9a73\u56de\u8282\u70b9\u91cd\u590d\uff0c\u65e0\u6cd5\u53d6\u56de");
        }
        List<HistoricActivityInstance> allHistoricTaskList = this.historyCompleteTaskOrderByDesc(processInstanceId);
        Task currentTask = (Task)this.taskService.createTaskQuery().processInstanceId(processInstanceId).taskId(currentTaskId).singleResult();
        if (currentTask == null) {
            throw new BizException(ResultCode.CONF_ERROR, "\u4efb\u52a1id\u9519\u8bef\uff0c \u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
        }
        String activityId = currentTask.getTaskDefinitionKey();
        String assignee = currentTask.getAssignee();
        String processDefinitionId = currentTask.getProcessDefinitionId();
        String newTaskKey = "";
        for (HistoricActivityInstance historicActivityInstance : allHistoricTaskList) {
            if (!StrUtil.equals((CharSequence)historicActivityInstance.getTaskId(), (CharSequence)newTaksId)) continue;
            newTaskKey = this.getActivityId(historicActivityInstance);
            break;
        }
        BpmnModelInstance bpmnModelInstance = this.repositoryService.getBpmnModelInstance(processDefinitionId);
        FlowNode element = (FlowNode)bpmnModelInstance.getModelElementById(activityId);
        List<HistoricActivityInstance> userTaskList = this.historyCompleteUserTaskOrderByDesc(processInstanceId);
        List<HistoricActivityInstance> cancelHistoricTaskList = this.historyCancelTaskOrderByDesc(processInstanceId);
        List<HistoricActivityInstance> historyActivities = allHistoricTaskList.stream().filter(item -> !cancelHistoricTaskList.stream().map(HistoricActivityInstance::getId).collect(Collectors.toList()).contains(item.getId())).collect(Collectors.toList());
        List<HistoricActivityInstance> activities = this.activityTask(processInstanceId);
        if (userTaskList == null || userTaskList.size() <= 0) throw new BizException(ResultCode.BIZ_ERROR, "\u7b2c\u4e00\u7528\u6237\u8282\u70b9");
        HashMap<String, String> withdrawVariable = new HashMap<String, String>(2);
        withdrawVariable.put("user", assignee);
        message = "withdraw@@:" + message;
        this.taskService.createComment(currentTask.getId(), processInstanceId, message);
        ArrayList<FlowNode> startNode = new ArrayList<FlowNode>();
        ArrayList<FlowNode> cancelNode = new ArrayList<FlowNode>();
        cancelNode.add(element);
        this.selectStartNode(element, startNode, cancelNode, historyActivities, activities);
        if (startNode.size() <= 0) throw new BizException(ResultCode.BIZ_ERROR, "\u9a73\u56de\u5931\u8d25");
        this.identityService.setAuthenticatedUserId(userId);
        ProcessInstanceModificationBuilder re = this.runtimeService.createProcessInstanceModification(processInstanceId);
        HashMap variable = this.runtimeService.getVariable(processInstanceId, "MANATEE_FORWARD_TASK_USER");
        UserTask userTask = (UserTask)element;
        if (variable != null) {
            Map variableMap = variable;
            variableMap.put(element.getId(), userTask.getCamundaAssignee());
        } else {
            variable = new HashMap();
            ((Map)variable).put(element.getId(), userTask.getCamundaAssignee());
        }
        this.runtimeService.setVariable(processInstanceId, "MANATEE_FORWARD_TASK_USER", variable);
        ArrayList<String> completeTaksIds = new ArrayList<String>(startNode.size());
        for (FlowNode node : cancelNode) {
            re.cancelAllForActivity(node.getId());
        }
        for (FlowNode node : startNode) {
            ((ProcessInstanceModificationInstantiationBuilder)re.startBeforeActivity(node.getId())).setVariables(withdrawVariable);
            completeTaksIds.add(node.getId());
        }
        re.setAnnotation(message).execute();
        List list = this.taskService.createTaskQuery().processInstanceId(processInstanceId).taskDefinitionKeyIn((String[])ArrayUtil.toArray(completeTaksIds, String.class)).active().list();
        for (Task task : list) {
            if (task.getTaskDefinitionKey().equals(newTaskKey)) continue;
            this.taskService.createComment(task.getId(), task.getProcessInstanceId(), message);
            this.taskService.complete(task.getId());
        }
    }

    public void selectStartNode(FlowNode element, List<FlowNode> startNode, List<FlowNode> cancelNode, List<HistoricActivityInstance> historyActivities, List<HistoricActivityInstance> activities) throws BizException {
        Collection sequenceFlow = element.getIncoming();
        Iterator entries = sequenceFlow.iterator();
        ArrayList<FlowNode> node = new ArrayList<FlowNode>();
        while (entries.hasNext()) {
            SequenceFlow flow = (SequenceFlow)entries.next();
            FlowNode element1 = flow.getSource();
            node.add(element1);
        }
        ArrayList<FlowNode> flowElementList = new ArrayList<FlowNode>();
        if (Objects.equals(element.getElementType().getTypeName(), "parallelGateway")) {
            flowElementList.addAll(node);
        } else {
            block1: for (HistoricActivityInstance historyActivity : historyActivities) {
                for (FlowNode flowNode : node) {
                    String activityId = this.getActivityId(historyActivity);
                    if (!Objects.equals(activityId, flowNode.getId())) continue;
                    flowElementList.add(flowNode);
                    break block1;
                }
            }
        }
        for (FlowNode flowElement : flowElementList) {
            if (Objects.equals(flowElement.getElementType().getTypeName(), "startEvent")) {
                throw new BizException(ResultCode.BIZ_ERROR, "\u5f00\u59cb\u8282\u70b9\u4e0d\u53ef\u9a73\u56de");
            }
            if (Objects.equals(flowElement.getElementType().getTypeName(), "userTask")) {
                startNode.add(flowElement);
                continue;
            }
            if (Objects.equals(flowElement.getElementType().getTypeName(), "exclusiveGateway")) {
                this.selectStartNode(flowElement, startNode, cancelNode, historyActivities, activities);
                continue;
            }
            if (!Objects.equals(flowElement.getElementType().getTypeName(), "parallelGateway")) continue;
            this.selectStartNode(flowElement, startNode, cancelNode, historyActivities, activities);
            Collection gateWayIncoming = element.getIncoming();
            if (gateWayIncoming.size() != 1) continue;
            Collection sequenceOut = flowElement.getOutgoing();
            for (SequenceFlow flow1 : sequenceOut) {
                FlowNode outElement = flow1.getTarget();
                if (Objects.equals(outElement.getId(), flowElement.getId())) continue;
                this.selectCancelNode(outElement, cancelNode, activities);
            }
        }
    }

    public void selectCancelNode(FlowNode element, List<FlowNode> cancelNode, List<HistoricActivityInstance> list) {
        if (!Objects.equals(element.getElementType().getTypeName(), "noneEndEvent")) {
            boolean bool = list.stream().anyMatch(obj -> {
                String activityId = this.getActivityId((HistoricActivityInstance)obj);
                return activityId.equals(element.getId());
            });
            if (bool) {
                cancelNode.add(element);
            } else {
                Collection sequenceOut = element.getOutgoing();
                for (SequenceFlow flow1 : sequenceOut) {
                    FlowNode outElement = flow1.getTarget();
                    this.selectCancelNode(outElement, cancelNode, list);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rejectToBeforeNode(String userId, String processInstanceId, String message, String currentTaskId, String targetTaskId) throws BizException {
        Task currentTask = (Task)this.taskService.createTaskQuery().processInstanceId(processInstanceId).taskId(currentTaskId).singleResult();
        List<HistoricActivityInstance> userTaskList = this.historyCompleteUserTaskOrderByDesc(processInstanceId);
        List<HistoricActivityInstance> allHistoricTaskList = this.historyCompleteTaskOrderByDesc(processInstanceId);
        List<HistoricActivityInstance> activities = this.activityTask(processInstanceId);
        if (userTaskList == null || userTaskList.size() <= 0) throw new BizException(ResultCode.BIZ_ERROR, "\u7b2c\u4e00\u7528\u6237\u8282\u70b9");
        BpmnModelInstance bpmnModelInstance = this.repositoryService.getBpmnModelInstance(currentTask.getProcessDefinitionId());
        HistoricTaskInstance targetTask = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(targetTaskId).singleResult();
        FlowNode targetTaskNode = (FlowNode)bpmnModelInstance.getModelElementById(targetTask.getTaskDefinitionKey());
        FlowNode currentTaskNode = (FlowNode)bpmnModelInstance.getModelElementById(currentTask.getTaskDefinitionKey());
        ArrayList<FlowNode> startNode = new ArrayList<FlowNode>();
        ArrayList<FlowNode> cancelNode = new ArrayList<FlowNode>();
        if (StringUtils.equals((CharSequence)currentTask.getId(), (CharSequence)targetTaskNode.getId())) {
            throw new BizException(ResultCode.SYSTEM_ERROR, "\u5f53\u524d\u4efb\u52a1\u4e0e\u9a73\u56de\u8282\u70b9\u91cd\u590d\uff0c\u65e0\u6cd5\u9a73\u56de");
        }
        if (currentTaskNode != null) {
            cancelNode.add(currentTaskNode);
        } else {
            this.taskService.deleteTask(currentTask.getId());
        }
        this.selectStartNodeByTargetNode((FlowNode)targetTaskNode.getSucceedingNodes().singleResult(), startNode, allHistoricTaskList, activities, cancelNode);
        if (startNode.size() <= 0) throw new BizException(ResultCode.BIZ_ERROR, "\u9a73\u56de\u5931\u8d25");
        this.taskService.createComment(currentTask.getId(), processInstanceId, "return@@:" + message);
        this.identityService.setAuthenticatedUserId(userId);
        ProcessInstanceModificationBuilder re = this.runtimeService.createProcessInstanceModification(currentTask.getProcessInstanceId());
        for (FlowNode node : cancelNode) {
            re.cancelAllForActivity(node.getId());
        }
        for (FlowNode node : startNode) {
            re.startBeforeActivity(node.getId());
        }
        re.setAnnotation(currentTask.getId()).execute();
    }

    public void rejectToTargetNode(String userId, String processInstanceId, String message, String currentTaskId, String targetTaskId, int backType) throws BizException {
        Task currentTask = (Task)this.taskService.createTaskQuery().processInstanceId(processInstanceId).taskId(currentTaskId).singleResult();
        List<HistoricActivityInstance> userTaskList = this.historyCompleteUserTaskOrderByDesc(processInstanceId);
        List<HistoricActivityInstance> allHistoricTaskList = this.historyCompleteTaskOrderByDesc(processInstanceId);
        List<HistoricActivityInstance> activities = this.activityTask(processInstanceId);
        if (userTaskList != null && userTaskList.size() > 0) {
            BpmnModelInstance bpmnModelInstance = this.repositoryService.getBpmnModelInstance(currentTask.getProcessDefinitionId());
            HistoricTaskInstance targetTask = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(targetTaskId).singleResult();
            FlowNode targetTaskNode = (FlowNode)bpmnModelInstance.getModelElementById(targetTask.getTaskDefinitionKey());
            FlowNode currentTaskNode = (FlowNode)bpmnModelInstance.getModelElementById(currentTask.getTaskDefinitionKey());
            ArrayList<FlowNode> startNode = new ArrayList<FlowNode>();
            HashSet<String> cancelNode = new HashSet<String>();
            if (StringUtils.equals((CharSequence)currentTask.getId(), (CharSequence)targetTaskNode.getId())) {
                throw new BizException(ResultCode.SYSTEM_ERROR, "\u5f53\u524d\u4efb\u52a1\u4e0e\u9a73\u56de\u8282\u70b9\u91cd\u590d\uff0c\u65e0\u6cd5\u9a73\u56de");
            }
            String newTaskKey = "";
            for (HistoricActivityInstance historicActivityInstance : allHistoricTaskList) {
                if (!StrUtil.equals((CharSequence)historicActivityInstance.getTaskId(), (CharSequence)targetTaskId)) continue;
                newTaskKey = this.getActivityId(historicActivityInstance);
                break;
            }
            if (currentTaskNode != null) {
                cancelNode.add(currentTaskNode.getId());
            } else {
                this.taskService.deleteTask(currentTask.getId());
            }
            HashSet<String> needCompleteIds = new HashSet<String>();
            HashSet<String> executedIds = new HashSet<String>();
            cancelNode.add(currentTaskNode.getId());
            executedIds.add(targetTaskNode.getId());
            executedIds.add(currentTaskNode.getId());
            this.selectStartNodeByTargetNode(targetTaskNode, currentTaskNode, cancelNode, startNode, executedIds, needCompleteIds, Boolean.FALSE);
            this.taskService.createComment(currentTask.getId(), processInstanceId, "return@@:" + message);
            this.identityService.setAuthenticatedUserId(userId);
            ProcessInstanceModificationBuilder re = this.runtimeService.createProcessInstanceModification(processInstanceId);
            for (String string : cancelNode) {
                re.cancelAllForActivity(string);
            }
            if (startNode.size() > 0) {
                for (FlowNode flowNode : startNode) {
                    FlowNode n = this.getNextParallelGateway(flowNode);
                    if (n == null) continue;
                    ProcessInstanceModificationBuilder re1 = this.runtimeService.createProcessInstanceModification(processInstanceId);
                    ((ProcessInstanceModificationInstantiationBuilder)re1.startBeforeActivity(n.getId())).execute();
                }
            }
            re.startBeforeActivity(targetTaskNode.getId());
            re.setAnnotation(currentTask.getId()).execute();
            List list = this.taskService.createTaskQuery().processInstanceId(processInstanceId).taskDefinitionKeyIn(needCompleteIds.toArray(new String[0])).active().list();
            for (Task task : list) {
                if (task.getTaskDefinitionKey().equals(newTaskKey)) continue;
                this.taskService.createComment(task.getId(), task.getProcessInstanceId(), "return@@:" + message);
                this.taskService.complete(task.getId());
            }
            if (backType == 1) {
                this.runtimeService.setVariable(processInstanceId, "MANATEE_BACK_LATESTTASKID", (Object)String.join((CharSequence)",", cancelNode));
            }
        } else {
            throw new BizException(ResultCode.BIZ_ERROR, "\u7b2c\u4e00\u7528\u6237\u8282\u70b9");
        }
    }

    public Map rejectToTargetNode_(String processInstanceId, String message, String targetTaskId, int backType, int gateWayOpenType) throws BizException {
        HistoricTaskInstance targetTask = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(targetTaskId).singleResult();
        Map r = this.specifyNodeApproval(processInstanceId, targetTask.getTaskDefinitionKey(), message, gateWayOpenType);
        if (backType == 1 && r.containsKey("cActList")) {
            List cActList = (List)r.get("cActList");
            ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            String cancelNode = this.genLastBackTask(cActList, processInstance);
            this.updateBackStrategy(processInstanceId, this.getActivityId(targetTask.getTaskDefinitionKey()), cancelNode);
        }
        log.info("rejectToTargetNode:{}", (Object)r);
        return r;
    }

    public FlowNode selectStartNodeByTargetNode(FlowNode currentTaskNode, FlowNode targetTaskNode, Set<String> cancelNode, List<FlowNode> startNode, Set<String> executedIds, Set<String> needCompleteIds, Boolean inParallelGateway) throws BizException {
        if (!StrUtil.equals((CharSequence)targetTaskNode.getElementType().getTypeName(), (CharSequence)"userTask")) {
            throw new BizException(ResultCode.BIZ_ERROR, "\u9000\u56de\u5931\u8d25\uff0c\u76ee\u6807\u8282\u70b9\u4e0d\u662f\u7528\u6237\u4efb\u52a1");
        }
        if (StrUtil.equals((CharSequence)currentTaskNode.getId(), (CharSequence)targetTaskNode.getId())) {
            return currentTaskNode;
        }
        Collection outgoing = currentTaskNode.getOutgoing();
        for (SequenceFlow next : outgoing) {
            FlowNode target = next.getTarget();
            executedIds.add(target.getId());
            if (StrUtil.equals((CharSequence)target.getElementType().getTypeName(), (CharSequence)"userTask")) {
                if (StrUtil.equals((CharSequence)target.getId(), (CharSequence)targetTaskNode.getId())) {
                    return target;
                }
                return this.selectStartNodeByTargetNode(target, targetTaskNode, cancelNode, startNode, executedIds, needCompleteIds, inParallelGateway);
            }
            if (StrUtil.equals((CharSequence)target.getElementType().getTypeName(), (CharSequence)"exclusiveGateway")) {
                return this.selectStartNodeByTargetNode(target, targetTaskNode, cancelNode, startNode, executedIds, needCompleteIds, inParallelGateway);
            }
            if (!StrUtil.equals((CharSequence)target.getElementType().getTypeName(), (CharSequence)"parallelGateway")) continue;
            boolean inParallelGatewayFlag = inParallelGateway;
            Collection gateWayIncoming = target.getIncoming();
            if (gateWayIncoming.size() == 1) {
                inParallelGateway = Boolean.TRUE;
            }
            FlowNode flowNode = this.selectStartNodeByTargetNode(target, targetTaskNode, cancelNode, startNode, executedIds, needCompleteIds, inParallelGateway);
            if (gateWayIncoming.size() > 1) {
                for (SequenceFlow sequenceFlow : gateWayIncoming) {
                    FlowNode source = sequenceFlow.getSource();
                    if (executedIds.contains(source.getId()) || inParallelGatewayFlag) continue;
                    startNode.add(source);
                    needCompleteIds.add(source.getId());
                }
                inParallelGateway = Boolean.FALSE;
            }
            return flowNode;
        }
        return null;
    }

    public void selectStartNodeByTargetNode(FlowNode element, List<FlowNode> startNode, List<HistoricActivityInstance> historyActivities, List<HistoricActivityInstance> activities, List<FlowNode> cancelNode) throws BizException {
        Collection sequenceFlow = element.getIncoming();
        Iterator entries = sequenceFlow.iterator();
        ArrayList<FlowNode> node = new ArrayList<FlowNode>();
        while (entries.hasNext()) {
            SequenceFlow flow = (SequenceFlow)entries.next();
            FlowNode element1 = flow.getSource();
            node.add(element1);
        }
        ArrayList<FlowNode> flowElementList = new ArrayList<FlowNode>();
        if (Objects.equals(element.getElementType().getTypeName(), "parallelGateway")) {
            flowElementList.addAll(node);
        } else {
            block1: for (HistoricActivityInstance historyActivity : historyActivities) {
                String activityId = this.getActivityId(historyActivity);
                for (FlowNode flowNode : node) {
                    if (!Objects.equals(activityId, flowNode.getId())) continue;
                    flowElementList.add(flowNode);
                    break block1;
                }
            }
        }
        for (FlowNode flowElement : flowElementList) {
            if (Objects.equals(flowElement.getElementType().getTypeName(), "startEvent")) {
                throw new BizException(ResultCode.BIZ_ERROR, "\u5f00\u59cb\u8282\u70b9\u4e0d\u53ef\u9a73\u56de");
            }
            if (Objects.equals(flowElement.getElementType().getTypeName(), "userTask")) {
                startNode.add(flowElement);
                this.selectStartNodeByTargetNode(flowElement, startNode, historyActivities, activities, cancelNode);
                continue;
            }
            if (Objects.equals(flowElement.getElementType().getTypeName(), "exclusiveGateway")) {
                this.selectStartNodeByTargetNode(flowElement, startNode, historyActivities, activities, cancelNode);
                continue;
            }
            if (!Objects.equals(flowElement.getElementType().getTypeName(), "parallelGateway")) continue;
            this.selectStartNodeByTargetNode(flowElement, startNode, historyActivities, activities, cancelNode);
            Collection gateWayIncoming = element.getIncoming();
            if (gateWayIncoming.size() != 1) continue;
            Collection sequenceOut = flowElement.getOutgoing();
            for (SequenceFlow flow1 : sequenceOut) {
                FlowNode outElement = flow1.getTarget();
                if (Objects.equals(outElement.getId(), flowElement.getId())) continue;
                this.selectCancelNode(outElement, cancelNode, activities);
            }
        }
    }

    public void selectInAllNode(FlowNode element, List<FlowNode> allNode, boolean isAll, boolean isSkipReviewed) throws BizException {
        Collection sequenceFlow = element.getIncoming();
        Iterator entries = sequenceFlow.iterator();
        ArrayList<FlowNode> node = new ArrayList<FlowNode>();
        while (entries.hasNext()) {
            SequenceFlow flow = (SequenceFlow)entries.next();
            FlowNode element1 = flow.getSource();
            node.add(element1);
        }
        for (FlowNode flowElement : node) {
            if (allNode.contains(flowElement)) continue;
            if (Objects.equals(flowElement.getElementType().getTypeName(), "exclusiveGateway")) {
                this.selectInAllNode(flowElement, allNode, isAll, isSkipReviewed);
                continue;
            }
            if (Objects.equals(flowElement.getElementType().getTypeName(), "parallelGateway")) {
                this.selectInAllNode(flowElement, allNode, isAll, isSkipReviewed);
                continue;
            }
            if (isSkipReviewed) {
                if (this.getNodeType(element) == 2) {
                    this.selectInAllNode(flowElement, allNode, isAll, false);
                    continue;
                }
                if (allNode.contains(flowElement)) {
                    allNode.remove(flowElement);
                }
                allNode.add(flowElement);
                if (!isAll) continue;
                this.selectInAllNode(flowElement, allNode, true, isSkipReviewed);
                continue;
            }
            allNode.add(flowElement);
            if (!isAll) continue;
            this.selectInAllNode(flowElement, allNode, true, isSkipReviewed);
        }
    }

    public void selectOutAllNode(FlowNode element, List<FlowNode> allNode) throws BizException {
        this.selectOutAllNode(element, allNode, true);
    }

    public void selectOutAllNode(FlowNode element, List<FlowNode> allNode, boolean isAll) throws BizException {
        Collection sequenceFlow = element.getOutgoing();
        Iterator entries = sequenceFlow.iterator();
        ArrayList<FlowNode> node = new ArrayList<FlowNode>();
        while (entries.hasNext()) {
            SequenceFlow flow = (SequenceFlow)entries.next();
            FlowNode element1 = flow.getTarget();
            node.add(element1);
        }
        for (FlowNode flowElement : node) {
            if (allNode.contains(flowElement)) continue;
            if (Objects.equals(flowElement.getElementType().getTypeName(), "exclusiveGateway")) {
                this.selectOutAllNode(flowElement, allNode, isAll);
                continue;
            }
            if (Objects.equals(flowElement.getElementType().getTypeName(), "parallelGateway")) {
                this.selectOutAllNode(flowElement, allNode, isAll);
                continue;
            }
            allNode.add(flowElement);
            if (!isAll) continue;
            this.selectOutAllNode(flowElement, allNode, isAll);
        }
    }

    private List<HistoricActivityInstance> historyCompleteUserTaskOrderByDesc(String processInstanceId) {
        return ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().activityType("userTask").processInstanceId(processInstanceId).finished().orderByHistoricActivityInstanceEndTime().desc()).list();
    }

    public List<HistoricActivityInstance> historyCompleteTaskOrderByDesc(String processInstanceId) {
        return ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).finished().orderByHistoricActivityInstanceEndTime().desc()).list();
    }

    private List<HistoricActivityInstance> historyCancelTaskOrderByDesc(String processInstanceId) {
        return ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).canceled().orderByHistoricActivityInstanceEndTime().desc()).list();
    }

    public List<HistoricActivityInstance> activityTask(String processInstanceId) {
        return this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).unfinished().list();
    }

    public String getActivityId(HistoricActivityInstance activityInstance) {
        if (Objects.isNull(activityInstance)) {
            return "";
        }
        return this.getActivityId(activityInstance.getActivityId());
    }

    public String getActivityId(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return "";
        }
        String activityId = key;
        if (activityId.indexOf("#") > 0) {
            return activityId.substring(0, activityId.indexOf("#"));
        }
        return activityId;
    }

    public int checkNodeType(String processId, String taskId, String taskDefKey) {
        String taskKey = this.getActivityId(taskDefKey);
        VariableInstance strategyVariableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processId}).variableName("MANATEE_TASK_ADD_SIGNER_STRATEGY:" + taskKey).singleResult();
        if (strategyVariableInstance == null) {
            return 0;
        }
        boolean isInnerNode = taskDefKey.contains("#addSigner:");
        String singerType = "";
        Task pTask = (Task)this.taskService.createTaskQuery().processInstanceId(processId).taskDefinitionKey(taskKey).singleResult();
        JSONArray taskAddSignerHisNodeInfos = new JSONArray();
        if (pTask == null) {
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processId).taskDefinitionKey(taskKey).list().get(0);
            HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processId).variableName("MANATEE_TASK_ADD_SIGNER_HIS_NODE_INFO").activityInstanceIdIn(new String[]{historicTaskInstance.getActivityInstanceId()}).list().get(0);
            String taskAddSignerHisNodeInfoStr = historicVariableInstance.getValue().toString();
            taskAddSignerHisNodeInfos = JSON.parseArray((String)taskAddSignerHisNodeInfoStr);
        } else {
            taskAddSignerHisNodeInfos = JSONObject.parseArray((String)((String)this.taskService.getVariableLocal(pTask.getId(), "MANATEE_TASK_ADD_SIGNER_HIS_NODE_INFO")));
        }
        for (int i = 0; i < taskAddSignerHisNodeInfos.size(); ++i) {
            JSONObject taskAddSignerHisNodeInfo = (JSONObject)taskAddSignerHisNodeInfos.get(i);
            singerType = taskAddSignerHisNodeInfo.getString("addSignerType");
        }
        if (singerType.equals("after")) {
            return isInnerNode ? 3 : 4;
        }
        return isInnerNode ? 1 : 2;
    }

    public JSONObject addSignerCanWithdraw(String processId, String taskId, String taskDefKey, int nodeType) throws BizException {
        List cancelAddSignerTask;
        String taskDefKey_;
        String taskDefKey_2;
        String taskKey = this.getActivityId(taskDefKey);
        List taskList = this.taskService.createTaskQuery().processInstanceId(processId).taskDefinitionKey(taskKey).active().list();
        if (taskList.size() <= 0) {
            throw new BizException(ResultCode.BIZ_ERROR, "\u53d6\u56de\u5931\u8d25\uff0c\u672a\u627e\u5230\u9000\u56de\u8282\u70b9");
        }
        VariableInstance strategyVariableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processId}).variableName("MANATEE_TASK_ADD_SIGNER_STRATEGY:" + taskKey).singleResult();
        String addSignerType = "";
        addSignerType = nodeType == 1 ? "before" : "after";
        Task pTask = (Task)taskList.get(0);
        JSONArray taskAddSignerHisNodeInfos = JSONObject.parseArray((String)((String)this.taskService.getVariableLocal(pTask.getId(), "MANATEE_TASK_ADD_SIGNER_HIS_NODE_INFO")));
        List<JSONObject> taskNodeList = this.getAddSignerNodeInfos((List)taskAddSignerHisNodeInfos, addSignerType);
        int index = -1;
        if (nodeType != 4) {
            for (int i = 0; i < taskNodeList.size(); ++i) {
                JSONObject taskAddSignerNodeInfo = taskNodeList.get(i);
                taskDefKey_2 = taskAddSignerNodeInfo.getString("taskDefKey");
                if (!taskDefKey_2.equals(taskDefKey)) continue;
                index = i;
            }
            if (index == -1) {
                throw new BizException(ResultCode.BIZ_ERROR, "\u53d6\u56de\u5931\u8d25\uff0c\u672a\u627e\u5230\u9000\u56de\u8282\u70b9");
            }
        }
        ArrayList addSignerCancelTaskIds = new ArrayList();
        if (nodeType == 1) {
            if (index < taskNodeList.size() - 1) {
                taskDefKey_ = taskNodeList.get(index + 1).getString("taskDefKey");
                cancelAddSignerTask = this.taskService.createTaskQuery().processInstanceId(processId).taskDefinitionKey(taskDefKey_).active().list();
                if (cancelAddSignerTask.size() <= 0) {
                    throw new BizException(ResultCode.BIZ_ERROR, "\u53d6\u56de\u5931\u8d25\uff0c\u540e\u52a0\u7b7e\u8282\u70b9\u5df2\u6267\u884c");
                }
            }
            return this.addSignerBack(processId, taskDefKey);
        }
        if (nodeType == 4) {
            ArrayList cancelTaskList = new ArrayList();
            taskDefKey_2 = taskNodeList.get(0).getString("taskDefKey");
            List cancelAddSignerTask2 = this.taskService.createTaskQuery().processInstanceId(processId).taskDefinitionKey(taskDefKey_2).active().list();
            if (cancelAddSignerTask2.size() > 0) {
                cancelAddSignerTask2 = this.taskService.createTaskQuery().processInstanceId(processId).taskParentTaskId(taskId).active().list();
                cancelAddSignerTask2.forEach(task -> {
                    this.taskService.createComment(task.getId(), processId, "return@@:\u53d6\u56de");
                    this.taskService.deleteTask(task.getId(), "\u53d6\u56de");
                    addSignerCancelTaskIds.add(task.getId());
                });
                ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processId).startBeforeActivity(taskDefKey)).execute();
                this.taskService.createComment(taskId, processId, "return@@:\u53d6\u56de");
                List historicActivityInstanceList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processId).unfinished().list();
                historicActivityInstanceList.forEach(activityInstance -> {
                    if (activityInstance.getTaskId().equals(taskId)) {
                        this.runtimeService.createProcessInstanceModification(processId).cancelActivityInstance(activityInstance.getId()).execute();
                    }
                });
                this.taskService.deleteTask(taskId, "\u53d6\u56de");
                HashMap<String, String> c = new HashMap<String, String>();
                c.put("taskId", taskId);
                c.put("taskDefKey", taskDefKey);
                c.put("processId", processId);
                cancelTaskList.add(c);
                JSONObject r = new JSONObject();
                r.put("cancelTask", cancelTaskList);
                r.put("addSignerCancelTaskIds", addSignerCancelTaskIds);
                return r;
            }
            throw new BizException(ResultCode.BIZ_ERROR, "\u53d6\u56de\u5931\u8d25\uff0c\u540e\u52a0\u7b7e\u8282\u70b9\u5df2\u6267\u884c");
        }
        if (index < taskNodeList.size() - 1) {
            taskDefKey_ = taskNodeList.get(index + 1).getString("taskDefKey");
            cancelAddSignerTask = this.taskService.createTaskQuery().processInstanceId(processId).taskDefinitionKey(taskDefKey_).active().list();
            if (cancelAddSignerTask.size() > 0) {
                return this.addSignerBack(processId, taskDefKey);
            }
            throw new BizException(ResultCode.BIZ_ERROR, "\u53d6\u56de\u5931\u8d25\uff0c\u540e\u52a0\u7b7e\u8282\u70b9\u5df2\u6267\u884c");
        }
        return null;
    }

    public JSONObject addSignerBack(String processId, String taskDefKey) throws BizException {
        String taskKey = this.getActivityId(taskDefKey);
        VariableInstance strategyVariableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processId}).variableName("MANATEE_TASK_ADD_SIGNER_STRATEGY:" + taskKey).singleResult();
        String addSignerType = "";
        Task pTask = (Task)this.taskService.createTaskQuery().processInstanceId(processId).taskDefinitionKey(taskKey).singleResult();
        JSONArray taskAddSignerHisNodeInfos = JSONObject.parseArray((String)((String)this.taskService.getVariableLocal(pTask.getId(), "MANATEE_TASK_ADD_SIGNER_HIS_NODE_INFO")));
        for (int i = 0; i < taskAddSignerHisNodeInfos.size(); ++i) {
            JSONObject taskAddSignerNodeInfo = (JSONObject)taskAddSignerHisNodeInfos.get(i);
            addSignerType = taskAddSignerNodeInfo.getString("addSignerType");
        }
        JSONArray strategyList = (JSONArray)strategyVariableInstance.getValue();
        List<JSONObject> taskNodeList = this.getAddSignerNodeInfos((List)taskAddSignerHisNodeInfos, addSignerType);
        int index = -1;
        for (int i = 0; i < taskNodeList.size(); ++i) {
            JSONObject taskAddSignerNodeInfo = taskNodeList.get(i);
            String taskDefKey_ = taskAddSignerNodeInfo.getString("taskDefKey");
            if (!taskDefKey_.equals(taskDefKey)) continue;
            index = i;
        }
        if (index == -1) {
            throw new BizException(ResultCode.BIZ_ERROR, "\u9000\u56de\u5931\u8d25\uff0c\u672a\u627e\u5230\u9000\u56de\u8282\u70b9");
        }
        ArrayList<JSONObject> preNodeList = new ArrayList<JSONObject>();
        for (int i = index; i < taskNodeList.size(); ++i) {
            JSONObject taskAddSignerNodeInfo = taskNodeList.get(i);
            preNodeList.add(taskAddSignerNodeInfo);
        }
        List cancelTask = this.taskService.createTaskQuery().processInstanceId(processId).taskParentTaskId(pTask.getId()).list();
        ArrayList addSignerCancelTaskIds = new ArrayList();
        cancelTask.forEach(task -> {
            this.taskService.createComment(task.getId(), processId, "return@@:\u53d6\u56de");
            this.taskService.deleteTask(task.getId(), "\u53d6\u56de");
            addSignerCancelTaskIds.add(task.getId());
        });
        JSONArray newSubTaskInfos = this.addSignerBackBeforeMaterial(processId, pTask, strategyList, (List)taskAddSignerHisNodeInfos, preNodeList);
        JSONObject jsonobject = new JSONObject();
        jsonobject.put("addSignerCancelTaskIds", addSignerCancelTaskIds);
        jsonobject.put("newSubTaskInfos", (Object)newSubTaskInfos);
        jsonobject.put("processId", (Object)processId);
        log.info("backBeforeMaterial:{}", (Object)jsonobject.toJSONString());
        return jsonobject;
    }

    public JSONArray addSignerBackBeforeMaterial(String processId, Task pTask, JSONArray strategyList, List taskAddsignerHisNodeInfos, List<JSONObject> preNodeList) {
        this.taskService.setVariableLocal(pTask.getId(), "MANATEE_TASK_ADD_SIGNER_NODE_INFO", null);
        JSONArray subTaskInfos = new JSONArray();
        for (JSONObject preNode : preNodeList) {
            JSONObject strategy = strategyList.getJSONObject(taskAddsignerHisNodeInfos.indexOf(preNode));
            subTaskInfos.add((Object)this.addSignerBackBeforeMaterial(processId, pTask, preNode, strategy));
        }
        return subTaskInfos;
    }

    public JSONObject addSignerBackBeforeMaterial(String processId, Task pTask, JSONObject taskAddSignerHisNodeInfo, JSONObject strategy) {
        String addSignerType = taskAddSignerHisNodeInfo.getString("addSignerType");
        String processorType = taskAddSignerHisNodeInfo.getString("processorType");
        String approvedUserNo = "";
        String approvedRoleCode = "";
        if (strategy.containsKey((Object)"approvedUserNo")) {
            approvedUserNo = strategy.getString("approvedUserNo");
        }
        if (strategy.containsKey((Object)"approvedRoleCode")) {
            approvedRoleCode = strategy.getString("approvedRoleCode");
        }
        String taskDefKey = taskAddSignerHisNodeInfo.getString("taskDefKey");
        String nodeName = taskAddSignerHisNodeInfo.getString("nodeName");
        JSONArray subTaskInfos = taskAddSignerHisNodeInfo.getJSONArray("subTaskInfos");
        ArrayList<JSONObject> newSubTaskInfos = new ArrayList<JSONObject>();
        for (Object subTaskInfo : subTaskInfos) {
            JSONObject taskInfo = (JSONObject)subTaskInfo;
            TaskEntity newTaskEntity = (TaskEntity)this.taskService.newTask(IdUtil.fastSimpleUUID());
            newTaskEntity.setProcessInstanceId(processId);
            if (StringUtils.equals((CharSequence)processorType, (CharSequence)"user")) {
                newTaskEntity.setAssignee(taskInfo.getString("taskAssignee"));
            }
            newTaskEntity.setName(nodeName);
            newTaskEntity.setParentTaskId(pTask.getId());
            newTaskEntity.setDescription("@@addSigner:" + nodeName);
            newTaskEntity.setDueDate(pTask.getDueDate());
            newTaskEntity.setCaseExecutionId(pTask.getCaseExecutionId());
            newTaskEntity.setPriority(pTask.getPriority());
            newTaskEntity.setProcessDefinitionId(pTask.getProcessDefinitionId());
            newTaskEntity.setTaskDefinitionKey(taskDefKey);
            this.taskService.saveTask((Task)newTaskEntity);
            this.taskService.setVariableLocal(newTaskEntity.getId(), "ADD_SIGNER_TYPE", (Object)addSignerType);
            this.taskService.setVariableLocal(newTaskEntity.getId(), "PROCESSOR_TYPE", (Object)processorType);
            JSONObject subTask = new JSONObject();
            subTask.put("taskId", (Object)newTaskEntity.getId());
            subTask.put("status", (Object)BpmTaskStatusEnum.WAIT.getStatus());
            subTask.put("addSignerType", (Object)addSignerType);
            subTask.put("processorType", (Object)processorType);
            subTask.put("approvedUserNo", (Object)approvedUserNo);
            subTask.put("approvedRoleCode", (Object)approvedRoleCode);
            subTask.put("nodeName", (Object)nodeName);
            subTask.put("taskDefinitionKey", (Object)newTaskEntity.getTaskDefinitionKey());
            if (StringUtils.equals((CharSequence)processorType, (CharSequence)"user")) {
                subTask.put("taskAssignee", (Object)taskInfo.getString("taskAssignee"));
            }
            newSubTaskInfos.add(subTask);
        }
        JSONObject subTaskInfo = new JSONObject();
        subTaskInfo.put("nodeName", (Object)nodeName);
        subTaskInfo.put("subTaskInfos", newSubTaskInfos);
        subTaskInfo.put("taskDefKey", (Object)taskDefKey);
        subTaskInfo.put("addSignerType", (Object)addSignerType);
        subTaskInfo.put("processorType", (Object)processorType);
        subTaskInfo.put("pTaskId", (Object)pTask.getId());
        subTaskInfo.put("strategy", (Object)strategy);
        subTaskInfo.put("status", (Object)BpmTaskStatusEnum.WAIT.getStatus());
        this.taskService.setVariableLocal(pTask.getId(), "MANATEE_TASK_ADD_SIGNER_STATUS", (Object)BpmTaskStatusEnum.WAIT.getStatus());
        Object taskAddsignerNodeInfo = JSONObject.parseArray((String)((String)this.taskService.getVariableLocal(pTask.getId(), "MANATEE_TASK_ADD_SIGNER_NODE_INFO")));
        if (taskAddsignerNodeInfo == null) {
            taskAddsignerNodeInfo = new ArrayList();
        } else {
            taskAddsignerNodeInfo.add(subTaskInfo);
        }
        this.taskService.setVariableLocal(pTask.getId(), "MANATEE_TASK_ADD_SIGNER_NODE_INFO", (Object)JSONObject.toJSONString((Object)taskAddsignerNodeInfo));
        return subTaskInfo;
    }

    public List<JSONObject> getAddSignerNodeInfos(List taskAddsignerHisNodeInfos, String addsignerType) {
        LinkedList<JSONObject> r = new LinkedList<JSONObject>();
        for (Object taskAddsignerNodeobj : taskAddsignerHisNodeInfos) {
            JSONObject taskAddSignerNodeInfo = (JSONObject)taskAddsignerNodeobj;
            String taskDefKey_ = taskAddSignerNodeInfo.getString("taskDefKey");
            String type = taskAddSignerNodeInfo.getString("addSignerType");
            if (!type.equals(addsignerType)) continue;
            r.add(taskAddSignerNodeInfo);
        }
        return r;
    }

    public JSONObject addSignerBackBeforeMaterial(String processId, Task newTask) {
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processId).taskDefinitionKey(newTask.getTaskDefinitionKey()).finished().orderByHistoricActivityInstanceStartTime().desc()).list().get(0);
        if (historicTaskInstance != null) {
            HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processId).variableName("MANATEE_TASK_ADD_SIGNER_HIS_NODE_INFO").activityInstanceIdIn(new String[]{historicTaskInstance.getActivityInstanceId()}).singleResult();
            HistoricVariableInstance strategyVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processId).variableName("MANATEE_TASK_ADD_SIGNER_STRATEGY:" + newTask.getTaskDefinitionKey()).singleResult();
            if (historicVariableInstance != null) {
                HistoricVariableInstance addsignerTypeVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processId).variableName("ADD_SIGNER_TYPE").activityInstanceIdIn(new String[]{historicTaskInstance.getActivityInstanceId()}).singleResult();
                HistoricVariableInstance processorTypeVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processId).variableName("PROCESSOR_TYPE").activityInstanceIdIn(new String[]{historicTaskInstance.getActivityInstanceId()}).singleResult();
                String taskAddSignerHisNodeInfoStr = historicVariableInstance.getValue().toString();
                JSONArray taskAddSignerHisNodeInfos = JSON.parseArray((String)taskAddSignerHisNodeInfoStr);
                JSONArray strategyList = (JSONArray)strategyVariableInstance.getValue();
                JSONObject strategy = strategyList.getJSONObject(strategyList.size() - 1);
                JSONObject taskAddSignerHisNodeInfo = taskAddSignerHisNodeInfos.getJSONObject(taskAddSignerHisNodeInfos.size() - 1);
                String addSignerType = taskAddSignerHisNodeInfo.getString("addSignerType");
                String processorType = taskAddSignerHisNodeInfo.getString("processorType");
                this.taskService.setVariableLocal(newTask.getId(), "MANATEE_TASK_ADD_SIGNER_HIS_NODE_INFO", (Object)taskAddSignerHisNodeInfoStr);
                if (addSignerType.equals("after")) {
                    return this.addSignerBackBeforeMaterial(processId, newTask, taskAddSignerHisNodeInfo, strategy);
                }
            }
        }
        return null;
    }

    public Map specifyNodeApproval(String processInstanceId, String taskDefKey, String message, int gateWayOpenType) throws BizException {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new BizException(ResultCode.SYSTEM_ERROR, "\u5de5\u4f5c\u6d41\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5");
        }
        BpmnModelInstance bpmnodelInstance = this.repositoryService.getBpmnModelInstance(processInstance.getProcessDefinitionId());
        FlowNode element = (FlowNode)bpmnodelInstance.getModelElementById(taskDefKey);
        if (element == null) {
            throw new BizException(ResultCode.SYSTEM_ERROR, "\u4efb\u52a1\u8282\u70b9\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5");
        }
        if (!Objects.equals(element.getElementType().getTypeName(), "userTask")) {
            throw new BizException(ResultCode.SYSTEM_ERROR, "\u975e\u4efb\u52a1\u8282\u70b9,\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5");
        }
        ArrayList<FlowNode> allNodes = new ArrayList<FlowNode>();
        this.selectInAllNode(element, allNodes, true, true);
        allNodes.add(element);
        ArrayList cancelTaskList = new ArrayList();
        ArrayList fTaskList = new ArrayList();
        List<Object> cTaskList = new ArrayList();
        ArrayList c1TaskList = new ArrayList();
        ArrayList cActList = new ArrayList();
        List taskList = this.taskService.createTaskQuery().processInstanceId(processInstanceId).active().list();
        ProcessInstanceModificationBuilder re = this.runtimeService.createProcessInstanceModification(processInstanceId);
        List<Execution> executionList = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).active().list();
        executionList = executionList.stream().filter(e -> ((ExecutionEntity)e).getActivityId() != null && ((ExecutionEntity)e).getActivityInstanceId() != null).collect(Collectors.toList());
        if (gateWayOpenType != 1) {
            for (Task task : taskList) {
                this.taskService.createComment(task.getId(), processInstanceId, "cancel@@:" + message);
            }
            for (Execution execution : executionList) {
                HashMap<String, String> c = new HashMap<String, String>();
                c.put("nodeDefKey", ((ExecutionEntity)execution).getActivityId());
                c.put("activityInstanceId", ((ExecutionEntity)execution).getActivityInstanceId());
                re.cancelActivityInstance(((ExecutionEntity)execution).getActivityInstanceId());
                cActList.add(c);
            }
        }
        this.startBeforeActivity(re, element);
        re.execute();
        SpecifyNodeApprovalGateWay snGateWay = this.doGateWay(element, processInstanceId, gateWayOpenType, null);
        for (Object task : taskList) {
            HashMap<String, String> c = new HashMap<String, String>();
            c.put("taskId", task.getId());
            c.put("taskDefKey", task.getTaskDefinitionKey());
            c.put("taskName", task.getName());
            c.put("assignee", task.getAssignee());
            c.put("processId", processInstanceId);
            cancelTaskList.add(c);
            if (allNodes.stream().anyMatch(arg_0 -> this.lambda$specifyNodeApproval$18((Task)task, arg_0))) {
                fTaskList.add(c);
                continue;
            }
            c1TaskList.add(c);
        }
        if (gateWayOpenType == 1) {
            ArrayList arrayList = new ArrayList();
            for (SpecifyNodeApprovalGateWay.Gateway gateway : snGateWay.getGatewayList()) {
                int gateWaySize = gateway.getOtherWayList().size();
                if (gateWaySize <= 0) continue;
                for (FlowNode f : gateway.getOtherWayList()) {
                    ArrayList<FlowNode> allNodes_ = new ArrayList<FlowNode>();
                    this.selectInAllNode(f, allNodes_, true, false);
                    allNodes_.add(f);
                    executionList.forEach(e -> {
                        String actId = this.getActivityId(((ExecutionEntity)e).getActivityId());
                        if (allNodes_.stream().anyMatch(node -> node.getId().equals(actId))) {
                            executionList_.add(e);
                        }
                    });
                }
            }
            ArrayList<Execution> finalExecutionList = new ArrayList<Execution>();
            finalExecutionList.addAll(executionList);
            arrayList.forEach(e -> finalExecutionList.remove(e));
            cancelTaskList = new ArrayList();
            for (Execution e3 : finalExecutionList) {
                if (((ExecutionEntity)e3).getActivityId() == null && ((ExecutionEntity)e3).getActivityInstanceId() != null) continue;
                List<Task> taskList_ = new ArrayList();
                String tId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(((ExecutionEntity)e3).getActivityInstanceId()).singleResult()).getTaskId();
                Task task = null;
                if (tId != null) {
                    task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstanceId).taskId(tId).singleResult();
                }
                if (task != null) {
                    taskList_ = this.taskService.createTaskQuery().processInstanceId(processInstanceId).taskParentTaskId(task.getId()).list();
                    taskList_.forEach(t -> this.runtimeService.createProcessInstanceModification(processInstanceId).cancelAllForActivity(t.getTaskDefinitionKey()).execute());
                    taskList_.add(task);
                }
                HashMap<String, String> c = new HashMap<String, String>();
                c.put("nodeDefKey", ((ExecutionEntity)e3).getActivityId());
                c.put("activityInstanceId", ((ExecutionEntity)e3).getActivityInstanceId());
                re.cancelActivityInstance(((ExecutionEntity)e3).getActivityInstanceId());
                cActList.add(c);
                this.runtimeService.createProcessInstanceModification(processInstanceId).cancelActivityInstance(((ExecutionEntity)e3).getActivityInstanceId()).execute();
                if (task == null) continue;
                for (Task t2 : taskList_) {
                    HashMap<String, String> c2 = new HashMap<String, String>();
                    c2.put("taskId", t2.getId());
                    c2.put("taskDefKey", t2.getTaskDefinitionKey());
                    c2.put("taskName", t2.getName());
                    c2.put("assignee", t2.getAssignee());
                    c2.put("processId", processInstanceId);
                    cancelTaskList.add(c2);
                }
            }
            for (SpecifyNodeApprovalGateWay.Gateway gateway : snGateWay.getGatewayList()) {
                int gateWaySize = gateway.getOtherWayList().size();
                if (gateWaySize <= 0) continue;
                for (FlowNode f : gateway.getOtherWayList()) {
                    ArrayList<FlowNode> allNodes_ = new ArrayList<FlowNode>();
                    this.selectInAllNode(f, allNodes_, true, false);
                    allNodes_.add(f);
                    AtomicBoolean hasMatch = new AtomicBoolean(false);
                    executionList.forEach(e -> {
                        String actId = this.getActivityId(((ExecutionEntity)e).getActivityId());
                        if (allNodes_.stream().anyMatch(node -> node.getId().equals(actId))) {
                            hasMatch.set(true);
                        }
                    });
                    if (hasMatch.get()) continue;
                    ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity(gateway.getGatewayNode().getId())).execute();
                }
            }
        }
        if (snGateWay.getGatewayList().size() > 0) {
            for (SpecifyNodeApprovalGateWay.Gateway gateway : snGateWay.getGatewayList()) {
                for (FlowNode node : gateway.getOtherWayList()) {
                    ArrayList<FlowNode> allNodes_ = new ArrayList<FlowNode>();
                    this.selectInAllNode(node, allNodes_, true, true);
                    allNodes_.add(node);
                    c1TaskList.forEach(t -> {
                        if (allNodes_.stream().anyMatch(flowNode -> flowNode.getId().equals(this.getActivityId((String)t.get("taskDefKey"))))) {
                            fTaskList.add(t);
                        }
                    });
                }
            }
        }
        cTaskList = c1TaskList.stream().filter(e -> !fTaskList.contains(e)).collect(Collectors.toList());
        HashMap hashMap = new HashMap();
        hashMap.put("cancelTask", cancelTaskList);
        hashMap.put("fTaskList", fTaskList);
        hashMap.put("cTaskList", cTaskList);
        hashMap.put("cActList", cActList);
        return hashMap;
    }

    public String genLastBackTask(List<Map> cActList, ProcessInstance processInstance) throws BizException {
        ArrayList<FlowNode> userTaskNodeList = new ArrayList<FlowNode>();
        ArrayList<FlowNode> gateWayNodeList = new ArrayList<FlowNode>();
        for (Map map : cActList) {
            String string = (String)map.get("nodeDefKey");
            String activityInstanceId = (String)map.get("activityInstanceId");
            BpmnModelInstance bpmnModelInstance = this.repositoryService.getBpmnModelInstance(processInstance.getProcessDefinitionId());
            FlowNode element = (FlowNode)bpmnModelInstance.getModelElementById(string);
            if (Objects.equals(element.getElementType().getTypeName(), "userTask")) {
                userTaskNodeList.add(element);
                continue;
            }
            if (!Objects.equals(element.getElementType().getTypeName(), "parallelGateway")) continue;
            gateWayNodeList.add(element);
        }
        ArrayList<FlowNode> lastBackTaskNodeList = new ArrayList<FlowNode>();
        for (FlowNode flowNode : gateWayNodeList) {
            ArrayList<FlowNode> inNodes = new ArrayList<FlowNode>();
            this.selectInAllNode(flowNode, inNodes, false, false);
            for (FlowNode f : inNodes) {
                ArrayList<FlowNode> allNodes = new ArrayList<FlowNode>();
                this.selectInAllNode(f, allNodes, false, false);
                allNodes.add(f);
                boolean isEnd = true;
                for (FlowNode uf : userTaskNodeList) {
                    if (!allNodes.contains(uf)) continue;
                    isEnd = false;
                }
                if (!isEnd) continue;
                lastBackTaskNodeList.add(f);
            }
        }
        ArrayList<FlowNode> arrayList = new ArrayList<FlowNode>();
        for (FlowNode f : lastBackTaskNodeList) {
            if (this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).activityId(f.getId()).finished().count() <= 0L) continue;
            arrayList.add(f);
        }
        HashSet hashSet = new HashSet();
        arrayList.forEach(t -> lastTaskDef.add(this.getActivityId(t.getId()) + "#@@finished"));
        userTaskNodeList.forEach(t -> lastTaskDef.add(this.getActivityId(t.getId())));
        String lastTaskDefKey = String.join((CharSequence)",", hashSet);
        return lastTaskDefKey;
    }

    public void updateBackStrategy(String processId, String firstTaskKey, String lastTaskDefKey) {
        JSONObject backStrategy = new JSONObject();
        backStrategy.put("MANATEE_BACK_LATESTTASKID", (Object)lastTaskDefKey);
        backStrategy.put("MANATEE_BACK_FIRSTTASKID", (Object)firstTaskKey);
        JSONArray backStrategyList = this.getBackStrategy(processId);
        backStrategyList.add((Object)backStrategy);
        this.updateBackStrategy(processId, backStrategyList);
    }

    public void updateBackStrategy(String processId, JSONArray backStrategyList) {
        if (backStrategyList.size() > 0) {
            this.runtimeService.setVariable(processId, "MANATEE_BACK_LATESTTASKID", (Object)backStrategyList.toJSONString());
        } else {
            this.runtimeService.setVariable(processId, "MANATEE_BACK_LATESTTASKID", (Object)"");
        }
        this.runtimeService.setVariable(processId, "MANATEE_BACK_STRATEGYS", (Object)backStrategyList.toJSONString());
    }

    public JSONArray getBackStrategy(String processId) {
        JSONArray backStrategyList = new JSONArray();
        Object backStrategys = this.runtimeService.getVariable(processId, "MANATEE_BACK_STRATEGYS");
        if (backStrategys != null) {
            backStrategyList = JSONArray.parseArray((String)backStrategys.toString());
        }
        return backStrategyList;
    }

    public int getNodeType(FlowNode element) {
        JSONObject result = this.getNodeProperties(element);
        int nodeType = 1;
        if (result.containsKey((Object)"actions")) {
            String[] actionsArr;
            String actions = result.getString("actions");
            for (String action : actionsArr = actions.split(";")) {
                String v = action.split(":")[0];
                if (v.equals("reviewed")) {
                    nodeType = 2;
                    continue;
                }
                if (!v.equals("vote")) continue;
                nodeType = 3;
            }
        }
        if (result.containsKey((Object)"nodeType")) {
            nodeType = result.getIntValue("nodeType");
        }
        return nodeType;
    }

    public JSONObject getNodeProperties(FlowNode element) {
        Collection camundaProperties;
        Query elementsQuery;
        JSONObject result = new JSONObject();
        ExtensionElements extensionElements = element.getExtensionElements();
        if (extensionElements != null && (elementsQuery = extensionElements.getElementsQuery()) != null && CollUtil.isNotEmpty((Collection)(camundaProperties = ((CamundaProperties)elementsQuery.filterByType(CamundaProperties.class).singleResult()).getCamundaProperties()))) {
            for (CamundaProperty camundaProperty : camundaProperties) {
                result.put(camundaProperty.getCamundaName(), (Object)camundaProperty.getCamundaValue());
            }
        }
        return result;
    }

    public void startBeforeActivity(ProcessInstanceModificationBuilder re, FlowNode element) {
        UserTask userTask = (UserTask)element;
        MultiInstanceLoopCharacteristics next = null;
        try {
            Collection childElementsByType = userTask.getChildElementsByType(MultiInstanceLoopCharacteristics.class);
            for (MultiInstanceLoopCharacteristics multiInstanceLoopcharacteristics : childElementsByType) {
                log.info("DelegateExecution multiInstanceLoopCharacteristics: }", (Object)multiInstanceLoopcharacteristics.getId());
                next = multiInstanceLoopcharacteristics;
                if (next == null) continue;
                break;
            }
        }
        catch (Exception e) {
            re.startBeforeActivity(element.getId());
            return;
        }
        if (next == null) {
            re.startBeforeActivity(element.getId());
            return;
        }
        String key = element.getId() + "#multiInstanceBody";
        re.startBeforeActivity(key);
    }

    public SpecifyNodeApprovalGateWay doGateWay(FlowNode element, String processInstanceId, int gateWayOpenType, List<Execution> executionList) throws BizException {
        SpecifyNodeApprovalGateWay snGateWay = new SpecifyNodeApprovalGateWay(element);
        this.getOutParallelGateway(snGateWay, element);
        if (snGateWay.getGatewayList().size() > 0) {
            for (SpecifyNodeApprovalGateWay.Gateway gateway : snGateWay.getGatewayList()) {
                int gateWaySize = gateway.getOtherWayList().size();
                if (gateWaySize <= 0 || gateWayOpenType == 1) continue;
                for (int i = 0; i < gateWaySize; ++i) {
                    ProcessInstanceModificationBuilder re = this.runtimeService.createProcessInstanceModification(processInstanceId);
                    ((ProcessInstanceModificationInstantiationBuilder)re.startBeforeActivity(gateway.getGatewayNode().getId())).execute();
                }
            }
        }
        return snGateWay;
    }

    public FlowNode getOutParallelGateway(SpecifyNodeApprovalGateWay snGateWay, FlowNode element) throws BizException {
        Collection sequenceFlow = element.getOutgoing();
        Iterator entries = sequenceFlow.iterator();
        ArrayList<FlowNode> node = new ArrayList<FlowNode>();
        while (entries.hasNext()) {
            SequenceFlow flow = (SequenceFlow)entries.next();
            FlowNode element1 = flow.getTarget();
            node.add(element1);
        }
        Iterator iterator = node.iterator();
        if (iterator.hasNext()) {
            FlowNode flowElement = (FlowNode)iterator.next();
            if (Objects.equals(flowElement.getElementType().getTypeName(), "parallelGateway") && flowElement.getIncoming().size() > 1) {
                ArrayList<FlowNode> otherWayList = new ArrayList<FlowNode>();
                for (SequenceFlow sf : flowElement.getIncoming()) {
                    if (sf.getSource().equals(snGateWay.getBaseNode())) continue;
                    ArrayList<FlowNode> allNode = new ArrayList<FlowNode>();
                    this.selectInAllNode(sf.getSource(), allNode, true, true);
                    allNode.add(sf.getSource());
                    if (allNode.contains(snGateWay.getBaseNode())) continue;
                    otherWayList.add(sf.getSource());
                }
                if (otherWayList.size() > 0) {
                    snGateWay.addGateway(otherWayList, flowElement);
                }
            }
            return this.getOutParallelGateway(snGateWay, flowElement);
        }
        return null;
    }

    private /* synthetic */ boolean lambda$specifyNodeApproval$18(Task task, FlowNode flowNode) {
        return flowNode.getId().equals(this.getActivityId(task.getTaskDefinitionKey()));
    }
}

