/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.repository;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import javax.annotation.Resource;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.springframework.stereotype.Service;

@Service
public class CamundaDelDeploymentProcess
implements IProcess {
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private IVariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        String id = this.variableUtil.calVarInConf(content, "deploymentId");
        if (StrUtil.isNotBlank((CharSequence)id)) {
            this.repositoryService.deleteDeployment(id);
            return;
        }
        String prcesssKey = this.variableUtil.calVarInConf(content, "prcesssKey");
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(prcesssKey);
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitionQuery.singleResult();
        if (processDefinition == null) {
            throw new BizException(ResultCode.CONF_ERROR, "\u627e\u4e0d\u5230\u9700\u8981\u5220\u9664\u7684\u6d41\u7a0b");
        }
        String deploymentId = processDefinition.getDeploymentId();
        this.repositoryService.deleteDeployment(deploymentId);
        this.repositoryService.deleteProcessDefinition(processDefinition.getId());
    }

    public String getName() {
        return "camundaDelDeploymentProcess";
    }
}

