/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.mongo;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.mongo.domain.BaseMongoSqlInfo;
import com.manatee.mongo.domain.MongoOption;
import com.manatee.mongo.enums.MongoOperationTypeEnum;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.execute.DebugUtil;
import com.mongodb.BasicDBObject;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonNumber;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoSqlUtil {
    public static Object find(String bsonSql, MongoCollection<Document> collection, Boolean isFirst, List<MongoOption> mongoOptionList) {
        FindIterable findIterable = StringUtils.isBlank((CharSequence)bsonSql) ? collection.find() : collection.find(MongoSqlUtil.getBson(bsonSql));
        for (MongoOption mongoOption : mongoOptionList) {
            if ("sort".equals(mongoOption.getOptionName())) {
                findIterable = findIterable.sort(MongoSqlUtil.getBson(String.valueOf(mongoOption.getOptionValue())));
                continue;
            }
            if ("skip".equals(mongoOption.getOptionName())) {
                findIterable = findIterable.skip(Integer.valueOf(String.valueOf(mongoOption.getOptionValue())).intValue());
                continue;
            }
            if ("limit".equals(mongoOption.getOptionName())) {
                findIterable = findIterable.limit(Integer.valueOf(String.valueOf(mongoOption.getOptionValue())).intValue());
                continue;
            }
            if ("maxTimeMS".equals(mongoOption.getOptionName())) {
                findIterable = findIterable.maxTime(Long.valueOf(String.valueOf(mongoOption.getOptionValue())).longValue(), TimeUnit.MILLISECONDS);
                continue;
            }
            if ("maxAwaitTimeMS".equals(mongoOption.getOptionName())) {
                findIterable = findIterable.maxAwaitTime(Long.valueOf(String.valueOf(mongoOption.getOptionValue())).longValue(), TimeUnit.MILLISECONDS);
                continue;
            }
            throw new BizException(String.format("\u6682\u4e0d\u652f\u6301\u8be5\u9009\u9879,%s,\u8bf7\u8054\u7cfb\u6280\u672f\u652f\u6301\u4eba\u5458", mongoOption.getOptionName()));
        }
        if (isFirst.booleanValue()) {
            return JSONObject.parseObject((String)((Document)findIterable.first()).toJson());
        }
        return findIterable.into(new ArrayList());
    }

    public static Object updateOne(String bsonSql, MongoCollection<Document> collection) {
        List<Object> updateBsonArray = MongoSqlUtil.getUpdateBsonArray(bsonSql);
        Bson param1 = (Bson)updateBsonArray.get(0);
        if (updateBsonArray.size() == 2) {
            if (updateBsonArray.get(1) instanceof List) {
                List param2 = (List)updateBsonArray.get(1);
                return JSONObject.parseObject((String)JSONObject.toJSONString((Object)collection.updateOne(param1, param2)));
            }
            Bson param2 = (Bson)updateBsonArray.get(1);
            return JSONObject.parseObject((String)JSONObject.toJSONString((Object)collection.updateOne(param1, param2)));
        }
        throw new BizException("\u6682\u4e0d\u652f\u6301\u8be5\u8bed\u53e5\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u652f\u6301\u4eba\u5458");
    }

    public static Object updateMany(String bsonSql, MongoCollection<Document> collection) {
        List<Object> updateBsonArray = MongoSqlUtil.getUpdateBsonArray(bsonSql);
        Bson param1 = (Bson)updateBsonArray.get(0);
        if (updateBsonArray.size() == 2) {
            if (updateBsonArray.get(1) instanceof List) {
                List param2 = (List)updateBsonArray.get(1);
                return JSONObject.parseObject((String)JSONObject.toJSONString((Object)collection.updateMany(param1, param2)));
            }
            Bson param2 = (Bson)updateBsonArray.get(1);
            return JSONObject.parseObject((String)JSONObject.toJSONString((Object)collection.updateMany(param1, param2)));
        }
        throw new BizException("\u6682\u4e0d\u652f\u6301\u8be5\u8bed\u53e5\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u652f\u6301\u4eba\u5458");
    }

    public static Object aggregate(String bsonSql, MongoCollection<Document> collection, List<MongoOption> mongoOptionList) {
        BsonDocument aggregateDocument = MongoSqlUtil.getAggregateDocument(bsonSql);
        BsonArray bsonArray = aggregateDocument.getArray((Object)"bsonArray");
        List bsonList = bsonArray.stream().map(bsonValue -> bsonValue.asDocument()).collect(Collectors.toList());
        BsonDocument options = aggregateDocument.getDocument((Object)"options");
        for (String optionName : options.keySet()) {
            MongoOption option = new MongoOption();
            option.setOptionName(optionName);
            option.setOptionValue(options.get((Object)optionName));
            mongoOptionList.add(option);
        }
        AggregateIterable aggregateIterable = collection.aggregate(bsonList);
        for (MongoOption mongoOption : mongoOptionList) {
            Comparable<Boolean> value;
            BsonBoolean optionValue;
            if ("allowDiskUse".equals(mongoOption.getOptionName())) {
                if (mongoOption.getOptionValue() instanceof BsonBoolean) {
                    optionValue = (BsonBoolean)mongoOption.getOptionValue();
                    value = optionValue.getValue();
                } else {
                    value = Boolean.valueOf(String.valueOf(mongoOption.getOptionValue()));
                }
                aggregateIterable = aggregateIterable.allowDiskUse(value);
                continue;
            }
            if ("maxTimeMS".equals(mongoOption.getOptionName())) {
                if (mongoOption.getOptionValue() instanceof BsonInt32) {
                    optionValue = (BsonNumber)mongoOption.getOptionValue();
                    value = optionValue.longValue();
                } else {
                    value = Long.valueOf(String.valueOf(mongoOption.getOptionValue()));
                }
                aggregateIterable = aggregateIterable.maxTime(((Long)value).longValue(), TimeUnit.MILLISECONDS);
                continue;
            }
            if ("maxAwaitTimeMS".equals(mongoOption.getOptionName())) {
                if (mongoOption.getOptionValue() instanceof BsonNumber) {
                    optionValue = (BsonNumber)mongoOption.getOptionValue();
                    value = optionValue.longValue();
                } else {
                    value = Long.valueOf(String.valueOf(mongoOption.getOptionValue()));
                }
                aggregateIterable = aggregateIterable.maxAwaitTime(((Long)value).longValue(), TimeUnit.MILLISECONDS);
                continue;
            }
            throw new BizException(String.format("\u6682\u4e0d\u652f\u6301\u8be5\u9009\u9879,%s,\u8bf7\u8054\u7cfb\u6280\u672f\u652f\u6301\u4eba\u5458", mongoOption.getOptionName()));
        }
        return aggregateIterable.into(new ArrayList());
    }

    public static BaseMongoSqlInfo buildBaseMongoSqlInfo(String sql) throws BizException {
        sql = StringUtils.trim((String)sql);
        int collectionStart = sql.indexOf("db.") + 3;
        int collectionEnd = sql.indexOf(".", collectionStart);
        int operationEnd = sql.indexOf("(", collectionEnd);
        int bracketsEnd = MongoSqlUtil.getFirstBracketsEnd(sql, sql.length(), operationEnd);
        String collectionName = sql.substring(collectionStart, collectionEnd);
        String operationType = sql.substring(collectionEnd + 1, operationEnd);
        String bsonSql = sql.substring(operationEnd + 1, bracketsEnd);
        MongoOperationTypeEnum mongoOperationTypeEnum = MongoOperationTypeEnum.fromOperationType(operationType);
        BaseMongoSqlInfo baseMongoSqlInfo = new BaseMongoSqlInfo();
        baseMongoSqlInfo.setCollectionName(collectionName);
        baseMongoSqlInfo.setMongoOperationType(mongoOperationTypeEnum);
        baseMongoSqlInfo.setBsonSql(StringUtils.trim((String)bsonSql));
        MongoSqlUtil.fillMongoOption(sql, bracketsEnd, baseMongoSqlInfo.getMongoOptionList());
        return baseMongoSqlInfo;
    }

    private static Integer getFirstBracketsEnd(String sql, int sqlLength, int start) {
        int bracketsEnd = sql.indexOf(")", start);
        if (bracketsEnd + 1 >= sqlLength) {
            return bracketsEnd;
        }
        String nextChar = sql.substring(bracketsEnd + 1, bracketsEnd + 2);
        if (".".equals(nextChar) || ";".equals(nextChar)) {
            return bracketsEnd;
        }
        return MongoSqlUtil.getFirstBracketsEnd(sql, sqlLength, bracketsEnd + 1);
    }

    private static void fillMongoOption(String sql, int start, List<MongoOption> mongoOptionList) {
        int operationStart = sql.indexOf(".", start) + 1;
        int bracketsStart = sql.indexOf("(", operationStart);
        int bracketsEnd = sql.indexOf(")", bracketsStart);
        if (operationStart <= 0 || bracketsStart <= 0 || bracketsEnd <= 0) {
            return;
        }
        String optionName = sql.substring(operationStart, bracketsStart);
        String optionValue = sql.substring(bracketsStart + 1, bracketsEnd);
        MongoOption mongoOption = new MongoOption();
        mongoOption.setOptionName(optionName);
        mongoOption.setOptionValue(optionValue);
        mongoOptionList.add(mongoOption);
        MongoSqlUtil.fillMongoOption(sql, bracketsEnd, mongoOptionList);
    }

    public static List<Object> getUpdateBsonArray(String updatebson) {
        ArrayList<Object> params = new ArrayList<Object>();
        BsonArray bsonArray = BsonArray.parse((String)("[" + updatebson + "]"));
        for (BsonValue bsonValue : bsonArray) {
            if (bsonValue instanceof BsonDocument) {
                params.add(BasicDBObject.parse((String)((BsonDocument)bsonValue).toJson()));
                continue;
            }
            if (!(bsonValue instanceof BsonArray)) continue;
            params.add(((BsonArray)bsonValue).stream().map(BsonValue::asDocument).collect(Collectors.toList()));
        }
        return params;
    }

    public static BsonDocument getAggregateDocument(String bson) {
        BsonDocument result = new BsonDocument();
        BsonArray pipeline = new BsonArray();
        BsonDocument options = new BsonDocument();
        int pipelineEndIndex = bson.lastIndexOf("]");
        if (pipelineEndIndex != -1 && bson.length() >= pipelineEndIndex + 1) {
            String optionsStr;
            String pipelineStr = bson.substring(0, pipelineEndIndex + 1);
            pipeline = BsonArray.parse((String)pipelineStr);
            if (bson.length() >= pipelineEndIndex + 2 && StringUtils.isNotBlank((CharSequence)(optionsStr = bson.substring(pipelineEndIndex + 2))) && !optionsStr.startsWith(",") && !optionsStr.startsWith(";")) {
                options = BsonDocument.parse((String)optionsStr);
            }
        }
        result.append("bsonArray", (BsonValue)pipeline);
        result.append("options", (BsonValue)options);
        return result;
    }

    public static Bson getBson(String bson) {
        if (StringUtils.isBlank((CharSequence)bson)) {
            return new BasicDBObject();
        }
        return BasicDBObject.parse((String)bson);
    }

    public static Document getDocument(String bson) {
        return Document.parse((String)bson);
    }

    public static List<Bson> getBsonList(String bson) {
        return BsonArray.parse((String)bson).stream().map(BsonValue::asDocument).collect(Collectors.toList());
    }

    public static Bson getUpdateFilterBson(String bson) {
        Document document = Document.parse((String)("{" + bson + "}"));
        Set entrySet = BasicDBObject.parse((String)bson).entrySet();
        return null;
    }

    public static List<Bson> getUpdateBson(String bson) {
        return null;
    }

    public static List<Document> getDocumentList(String bson) {
        return BsonArray.parse((String)bson).stream().map(bsonValue -> Document.parse((String)bsonValue.asDocument().toJson())).collect(Collectors.toList());
    }

    public static void putExecuteSql(ProcessContent content, String executeSql) {
        if (DebugUtil.isDebug((ProcessContent)content)) {
            JSONObject executeSqlObj = new JSONObject();
            executeSqlObj.put("stepName", (Object)content.getStep().getTitle());
            executeSqlObj.put("executeSql", (Object)executeSql);
            executeSqlObj.put("nodeId", (Object)content.getStep().getId());
            content.getDebug().putExecuteSqls(executeSqlObj);
        }
    }
}

