/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.fun.impl.change;

import com.manatee.common.util.tool.core.util.NumberUtil;
import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.fun.util.FunctionContentUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BooleanFun
extends AbstractFunction {
    private static Logger log = LoggerFactory.getLogger(BooleanFun.class);
    private String name = "boolean";

    public String getName() {
        return this.name;
    }

    public Object doFunction(FunctionContent content) {
        this.checkParamSize(content);
        if (!this.checkParamExist(content).booleanValue()) {
            return null;
        }
        List parameters = content.getParameters();
        Object obj = parameters.get(0);
        try {
            if (NumberUtil.isNumber((CharSequence)obj.toString())) {
                return Integer.valueOf(obj.toString()) > 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            return Boolean.valueOf(obj + "");
        }
        catch (Throwable e2) {
            log.error("[LongFun.doFunction]_exception", e2);
            FunctionContentUtil.addUnBlockError((FunctionContent)content, (String)String.format("\u51fd\u6570\uff1a%s\uff0c\u8f6cboolean\u5931\u8d25", this.getName()), (String)this.getName());
            return null;
        }
    }

    public Integer getMinParamSize() {
        return 1;
    }

    public Integer getMaxParamSize() {
        return 1;
    }
}

