/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.http.cookie;

import com.manatee.common.util.tool.core.io.IORuntimeException;
import com.manatee.common.util.tool.core.util.URLUtil;
import com.manatee.common.util.tool.http.HttpConnection;
import com.manatee.common.util.tool.http.cookie.ThreadLocalCookieStore;
import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GlobalCookieManager {
    private static CookieManager cookieManager = new CookieManager(new ThreadLocalCookieStore(), CookiePolicy.ACCEPT_ALL);

    public static void setCookieManager(CookieManager customCookieManager) {
        cookieManager = customCookieManager;
    }

    public static CookieManager getCookieManager() {
        return cookieManager;
    }

    public static List<HttpCookie> getCookies(HttpConnection conn) {
        return cookieManager.getCookieStore().get(GlobalCookieManager.getURI(conn));
    }

    public static void add(HttpConnection conn) {
        Map<String, List<String>> cookieHeader;
        if (null == cookieManager) {
            return;
        }
        try {
            cookieHeader = cookieManager.get(GlobalCookieManager.getURI(conn), new HashMap<String, List<String>>(0));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        conn.header(cookieHeader, false);
    }

    public static void store(HttpConnection conn) {
        if (null == cookieManager) {
            return;
        }
        try {
            cookieManager.put(GlobalCookieManager.getURI(conn), conn.headers());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static URI getURI(HttpConnection conn) {
        return URLUtil.toURI(conn.getUrl());
    }
}

