/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.core.util;

import com.manatee.common.util.tool.core.exceptions.UtilException;
import com.manatee.common.util.tool.core.io.IORuntimeException;
import com.manatee.common.util.tool.core.io.IoUtil;
import com.manatee.common.util.tool.core.io.resource.ResourceUtil;
import com.manatee.common.util.tool.core.lang.Assert;
import com.manatee.common.util.tool.core.net.URLDecoder;
import com.manatee.common.util.tool.core.net.URLEncoder;
import com.manatee.common.util.tool.core.net.url.UrlQuery;
import com.manatee.common.util.tool.core.util.CharUtil;
import com.manatee.common.util.tool.core.util.CharsetUtil;
import com.manatee.common.util.tool.core.util.ClassLoaderUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.jar.JarFile;

public class URLUtil {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String JAR_URL_PREFIX = "jar:";
    public static final String WAR_URL_PREFIX = "war:";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    public static final String URL_PROTOCOL_VFSFILE = "vfsfile";
    public static final String URL_PROTOCOL_VFS = "vfs";
    public static final String JAR_URL_SEPARATOR = "!/";
    public static final String WAR_URL_SEPARATOR = "*/";

    public static URL url(String url) {
        return URLUtil.url(url, null);
    }

    public static URL url(String url, URLStreamHandler handler) {
        Assert.notNull(url, "URL must not be null", new Object[0]);
        if (url.startsWith(CLASSPATH_URL_PREFIX)) {
            url = url.substring(CLASSPATH_URL_PREFIX.length());
            return ClassLoaderUtil.getClassLoader().getResource(url);
        }
        try {
            return new URL(null, url, handler);
        }
        catch (MalformedURLException e) {
            try {
                return new File(url).toURI().toURL();
            }
            catch (MalformedURLException ex2) {
                throw new UtilException(e);
            }
        }
    }

    public static URI getStringURI(CharSequence content) {
        String contentStr = StrUtil.addPrefixIfNot(content, "string:///");
        return URI.create(contentStr);
    }

    public static URL toUrlForHttp(String urlStr) {
        return URLUtil.toUrlForHttp(urlStr, null);
    }

    public static URL toUrlForHttp(String urlStr, URLStreamHandler handler) {
        Assert.notBlank(urlStr, "Url is blank !", new Object[0]);
        urlStr = URLUtil.encodeBlank(urlStr);
        try {
            return new URL(null, urlStr, handler);
        }
        catch (MalformedURLException e) {
            throw new UtilException(e);
        }
    }

    public static String encodeBlank(CharSequence urlStr) {
        if (urlStr == null) {
            return null;
        }
        int len = urlStr.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = urlStr.charAt(i);
            if (CharUtil.isBlankChar(c)) {
                sb.append("%20");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static URL getURL(String pathBaseClassLoader) {
        return ResourceUtil.getResource(pathBaseClassLoader);
    }

    public static URL getURL(String path, Class<?> clazz) {
        return ResourceUtil.getResource(path, clazz);
    }

    public static URL getURL(File file) {
        Assert.notNull(file, "File is null !", new Object[0]);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new UtilException(e, "Error occured when get URL!", new Object[0]);
        }
    }

    public static URL[] getURLs(File ... files) {
        URL[] urls = new URL[files.length];
        try {
            for (int i = 0; i < files.length; ++i) {
                urls[i] = files[i].toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new UtilException(e, "Error occured when get URL!", new Object[0]);
        }
        return urls;
    }

    public static URI getHost(URL url) {
        if (null == url) {
            return null;
        }
        try {
            return new URI(url.getProtocol(), url.getHost(), null, null);
        }
        catch (URISyntaxException e) {
            throw new UtilException(e);
        }
    }

    @Deprecated
    public static String complateUrl(String baseUrl, String relativePath) {
        return URLUtil.completeUrl(baseUrl, relativePath);
    }

    public static String completeUrl(String baseUrl, String relativePath) {
        if (StrUtil.isBlank(baseUrl = URLUtil.normalize(baseUrl, false))) {
            return null;
        }
        try {
            URL absoluteUrl = new URL(baseUrl);
            URL parseUrl = new URL(absoluteUrl, relativePath);
            return parseUrl.toString();
        }
        catch (MalformedURLException e) {
            throw new UtilException(e);
        }
    }

    public static String encodeAll(String url) {
        return URLUtil.encodeAll(url, CharsetUtil.CHARSET_UTF_8);
    }

    public static String encodeAll(String url, Charset charset) throws UtilException {
        if (null == charset) {
            return url;
        }
        return URLEncoder.ALL.encode(url, charset);
    }

    public static String encode(String url) throws UtilException {
        return URLUtil.encode(url, CharsetUtil.CHARSET_UTF_8);
    }

    public static String encodeQuery(String url) throws UtilException {
        return URLUtil.encodeQuery(url, CharsetUtil.CHARSET_UTF_8);
    }

    public static String encode(String url, Charset charset) {
        if (StrUtil.isEmpty(url)) {
            return url;
        }
        if (null == charset) {
            charset = CharsetUtil.defaultCharset();
        }
        return URLEncoder.DEFAULT.encode(url, charset);
    }

    public static String encodeQuery(String url, Charset charset) {
        if (StrUtil.isEmpty(url)) {
            return url;
        }
        if (null == charset) {
            charset = CharsetUtil.defaultCharset();
        }
        return URLEncoder.QUERY.encode(url, charset);
    }

    public static String encode(String url, String charset) throws UtilException {
        if (StrUtil.isEmpty(url)) {
            return url;
        }
        return URLUtil.encode(url, StrUtil.isBlank(charset) ? CharsetUtil.defaultCharset() : CharsetUtil.charset(charset));
    }

    public static String encodeQuery(String url, String charset) throws UtilException {
        return URLUtil.encodeQuery(url, StrUtil.isBlank(charset) ? CharsetUtil.defaultCharset() : CharsetUtil.charset(charset));
    }

    public static String decode(String url) throws UtilException {
        return URLUtil.decode(url, "UTF-8");
    }

    public static String decode(String content, Charset charset) {
        if (null == charset) {
            return content;
        }
        return URLDecoder.decode(content, charset);
    }

    public static String decode(String content, String charset) throws UtilException {
        return URLUtil.decode(content, CharsetUtil.charset(charset));
    }

    public static String getPath(String uriStr) {
        return URLUtil.toURI(uriStr).getPath();
    }

    public static String getDecodedPath(URL url) {
        if (null == url) {
            return null;
        }
        String path = null;
        try {
            path = URLUtil.toURI(url).getPath();
        }
        catch (UtilException utilException) {
            // empty catch block
        }
        return null != path ? path : url.getPath();
    }

    public static URI toURI(URL url) throws UtilException {
        return URLUtil.toURI(url, false);
    }

    public static URI toURI(URL url, boolean isEncode) throws UtilException {
        if (null == url) {
            return null;
        }
        return URLUtil.toURI(url.toString(), isEncode);
    }

    public static URI toURI(String location) throws UtilException {
        return URLUtil.toURI(location, false);
    }

    public static URI toURI(String location, boolean isEncode) throws UtilException {
        if (isEncode) {
            location = URLUtil.encode(location);
        }
        try {
            return new URI(StrUtil.trim(location));
        }
        catch (URISyntaxException e) {
            throw new UtilException(e);
        }
    }

    public static boolean isFileURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_FILE.equals(protocol) || URL_PROTOCOL_VFSFILE.equals(protocol) || URL_PROTOCOL_VFS.equals(protocol);
    }

    public static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_JAR.equals(protocol) || URL_PROTOCOL_ZIP.equals(protocol) || URL_PROTOCOL_VFSZIP.equals(protocol) || URL_PROTOCOL_WSJAR.equals(protocol);
    }

    public static boolean isJarFileURL(URL url) {
        return URL_PROTOCOL_FILE.equals(url.getProtocol()) && url.getPath().toLowerCase().endsWith(".jar");
    }

    public static InputStream getStream(URL url) {
        Assert.notNull(url);
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedReader getReader(URL url, Charset charset) {
        return IoUtil.getReader(URLUtil.getStream(url), charset);
    }

    public static JarFile getJarFile(URL url) {
        try {
            JarURLConnection urlConnection = (JarURLConnection)url.openConnection();
            return urlConnection.getJarFile();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static String normalize(String url) {
        return URLUtil.normalize(url, false);
    }

    public static String normalize(String url, boolean isEncodePath) {
        return URLUtil.normalize(url, isEncodePath, false);
    }

    public static String normalize(String url, boolean isEncodePath, boolean replaceSlash) {
        String body;
        String protocol;
        if (StrUtil.isBlank(url)) {
            return url;
        }
        int sepIndex = url.indexOf("://");
        if (sepIndex > 0) {
            protocol = StrUtil.subPre(url, sepIndex + 3);
            body = StrUtil.subSuf(url, sepIndex + 3);
        } else {
            protocol = "http://";
            body = url;
        }
        int paramsSepIndex = StrUtil.indexOf(body, '?');
        String params = null;
        if (paramsSepIndex > 0) {
            params = StrUtil.subSuf(body, paramsSepIndex);
            body = StrUtil.subPre(body, paramsSepIndex);
        }
        if (StrUtil.isNotEmpty(body)) {
            body = body.replaceAll("^[\\\\/]+", "");
            body = body.replace("\\", "/");
            if (replaceSlash) {
                body = body.replaceAll("//+", "/");
            }
        }
        int pathSepIndex = StrUtil.indexOf(body, '/');
        String domain = body;
        String path = null;
        if (pathSepIndex > 0) {
            domain = StrUtil.subPre(body, pathSepIndex);
            path = StrUtil.subSuf(body, pathSepIndex);
        }
        if (isEncodePath) {
            path = URLUtil.encode(path);
        }
        return protocol + domain + StrUtil.nullToEmpty(path) + StrUtil.nullToEmpty(params);
    }

    public static String buildQuery(Map<String, ?> paramMap, Charset charset) {
        return UrlQuery.of(paramMap).build(charset);
    }

    public static long getContentLength(URL url) throws IORuntimeException {
        if (null == url) {
            return -1L;
        }
        URLConnection conn = null;
        try {
            conn = url.openConnection();
            long l = conn.getContentLengthLong();
            return l;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).disconnect();
            }
        }
    }

    public static String getDataUriBase64(String mimeType, String data) {
        return URLUtil.getDataUri(mimeType, null, "base64", data);
    }

    public static String getDataUri(String mimeType, String encoding, String data) {
        return URLUtil.getDataUri(mimeType, null, encoding, data);
    }

    public static String getDataUri(String mimeType, Charset charset, String encoding, String data) {
        StringBuilder builder = StrUtil.builder("data:");
        if (StrUtil.isNotBlank(mimeType)) {
            builder.append(mimeType);
        }
        if (null != charset) {
            builder.append(";charset=").append(charset.name());
        }
        if (StrUtil.isNotBlank(encoding)) {
            builder.append(';').append(encoding);
        }
        builder.append(',').append(data);
        return builder.toString();
    }
}

