/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util;

import com.manatee.common.util.StrUtils;
import com.manatee.process.constant.PatternPool;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtils {
    public static final String RE_CHINESE = "[\u4e00-\u9fff]";
    public static final String RE_CHINESES = "[\u4e00-\u9fff]+";
    public static final Set<Character> RE_KEYS = new HashSet<Character>(Arrays.asList(Character.valueOf('$'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('.'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('?'), Character.valueOf('\\'), Character.valueOf('^'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|')));

    public static String get(String regex, CharSequence content, int groupIndex) {
        if (null == content || null == regex) {
            return null;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RegexUtils.get(pattern, content, groupIndex);
    }

    public static String get(Pattern pattern, CharSequence content, int groupIndex) {
        if (null == content || null == pattern) {
            return null;
        }
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(groupIndex);
        }
        return null;
    }

    public static String replaceAll(CharSequence content, String regex, String replacementTemplate) {
        Pattern pattern = Pattern.compile(regex, 32);
        return RegexUtils.replaceAll(content, pattern, replacementTemplate);
    }

    public static String replaceAll(CharSequence content, Pattern pattern, String replacementTemplate) {
        if (StrUtils.isEmpty(content)) {
            return StrUtils.str(content);
        }
        Matcher matcher = pattern.matcher(content);
        boolean result = matcher.find();
        if (!result) {
            return StrUtils.str(content);
        }
        Set varNums = RegexUtils.findAll(PatternPool.GROUP_VAR, replacementTemplate, 1, new HashSet());
        StringBuffer sb = new StringBuffer();
        do {
            String replacement = replacementTemplate;
            for (String var : varNums) {
                int group = Integer.parseInt(var);
                replacement = replacement.replace("$" + var, matcher.group(group));
            }
            matcher.appendReplacement(sb, RegexUtils.escape(replacement));
        } while (result = matcher.find());
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static <T extends Collection<String>> T findAll(Pattern pattern, CharSequence content, int group, T collection) {
        if (null != pattern && null != content) {
            if (null == collection) {
                throw new NullPointerException("Null collection param provided!");
            }
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                collection.add((String)matcher.group(group));
            }
            return collection;
        }
        return null;
    }

    public static String escape(CharSequence content) {
        if (StrUtils.isBlank(content)) {
            return StrUtils.str(content);
        }
        StringBuilder builder = new StringBuilder();
        int len = content.length();
        for (int i = 0; i < len; ++i) {
            char current = content.charAt(i);
            if (RE_KEYS.contains(Character.valueOf(current))) {
                builder.append('\\');
            }
            builder.append(current);
        }
        return builder.toString();
    }
}

