/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.rocketmq.config;

import com.manatee.common.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ManateeRocketmqProducerConfig
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ManateeRocketmqProducerConfig.class);
    @Value(value="${rocketmq.producer.namesrvAddr:}")
    private String namesrvAddr;
    @Value(value="${rocketmq.producer.groupName:}")
    private String groupName;
    public static Map<String, DefaultMQProducer> producerMap = new HashMap<String, DefaultMQProducer>();
    public static String firstGroup;

    public void afterPropertiesSet() {
        if (StringUtil.isNotBlank((String)this.namesrvAddr) && StringUtil.isNotBlank((String)this.groupName)) {
            String[] groupNameArr;
            for (String group : groupNameArr = this.groupName.split(",")) {
                if (StringUtils.isBlank((CharSequence)firstGroup)) {
                    firstGroup = group;
                }
                DefaultMQProducer producer = new DefaultMQProducer(group);
                producer.setMqClientApiTimeout(10000);
                producer.setNamesrvAddr(this.namesrvAddr);
                try {
                    producer.start();
                    producerMap.put(group, producer);
                }
                catch (MQClientException e) {
                    log.error("RocketmqProducer\u542f\u52a8\u5f02\u5e38\uff1a", (Throwable)e);
                }
            }
        }
    }

    @PreDestroy
    private void destroy() {
        if (producerMap != null && producerMap.size() > 0) {
            for (String group : producerMap.keySet()) {
                DefaultMQProducer producer = producerMap.get(group);
                producer.shutdown();
                System.out.println("RocketmqProducer shutdown......................");
            }
        }
    }

    public String getNamesrvAddr() {
        return this.namesrvAddr;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setNamesrvAddr(String namesrvAddr) {
        this.namesrvAddr = namesrvAddr;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ManateeRocketmqProducerConfig)) {
            return false;
        }
        ManateeRocketmqProducerConfig other = (ManateeRocketmqProducerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$namesrvAddr = this.getNamesrvAddr();
        String other$namesrvAddr = other.getNamesrvAddr();
        if (this$namesrvAddr == null ? other$namesrvAddr != null : !this$namesrvAddr.equals(other$namesrvAddr)) {
            return false;
        }
        String this$groupName = this.getGroupName();
        String other$groupName = other.getGroupName();
        return !(this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ManateeRocketmqProducerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $namesrvAddr = this.getNamesrvAddr();
        result = result * 59 + ($namesrvAddr == null ? 43 : $namesrvAddr.hashCode());
        String $groupName = this.getGroupName();
        result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
        return result;
    }

    public String toString() {
        return "ManateeRocketmqProducerConfig(namesrvAddr=" + this.getNamesrvAddr() + ", groupName=" + this.getGroupName() + ")";
    }
}

