/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.manager;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBInsert;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.domain.DBUpdate;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcodedb.base.DBReadUtil;
import com.manatee.lowcodedb.base.DBWriteUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class LowcodeCompilerManager {
    private static Logger LOGGER = LoggerFactory.getLogger(LowcodeCompilerManager.class);
    @Value(value="${default-database-product-name:mysql}")
    private String defaultDatabaseProductName;
    @Resource
    private DBReadUtil dbReadUtil;
    @Resource
    private DBWriteUtil dbWriteUtil;

    public JSONObject getCompiler(Long id, String beanName) throws BizException {
        DBQuery query = new DBQuery();
        query.setTable("lowcode_compiler");
        query.setColumns("id, bean_name, compiler_version,compiler_code,compiler_data");
        query.setCamelCase(Boolean.valueOf(false));
        HashMap<String, Object> moduleConditionMap = new HashMap<String, Object>();
        if (id != null) {
            moduleConditionMap.put("id", id);
        }
        if (StringUtil.isNotBlank((String)beanName)) {
            moduleConditionMap.put("bean_name", beanName);
        }
        query.setConditionMap(moduleConditionMap);
        query.setDb("hainiu_lowcode");
        query.setSelectOne(Boolean.valueOf(true));
        query.setDatabaseProductName(this.defaultDatabaseProductName);
        JSONObject json = (JSONObject)this.dbReadUtil.find(query);
        return json;
    }

    public JSONArray findCompers(Long moduleId) throws BizException {
        DBQuery query = new DBQuery();
        query.setTable("lowcode_compiler");
        query.setColumns("id, bean_name, compiler_version, compiler_code, module_id, compiler_data, compiler_type, ext1");
        query.setCamelCase(Boolean.valueOf(false));
        HashMap<String, Long> moduleConditionMap = new HashMap<String, Long>();
        if (moduleId != null) {
            moduleConditionMap.put("module_id", moduleId);
        }
        query.setConditionMap(moduleConditionMap);
        JSON json = this.dbReadUtil.find(query);
        if (json == null) {
            return null;
        }
        if (!(json instanceof List)) {
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)json);
            return jsonArray;
        }
        return (JSONArray)json;
    }

    public JSONObject saveCompiler(Long projectId, Long moduleId, String beanName, String compilerCode, byte[] compilerData) throws BizException {
        DBInsert insert = new DBInsert();
        insert.setDb("hainiu_lowcode");
        insert.setTable("lowcode_compiler");
        insert.setInsertType("ignore");
        insert.setDatabaseProductName(this.defaultDatabaseProductName);
        HashMap<String, Object> moduleConditionMap = new HashMap<String, Object>();
        moduleConditionMap.put("bean_name", beanName);
        moduleConditionMap.put("project_id", projectId);
        moduleConditionMap.put("module_id", moduleId);
        moduleConditionMap.put("compiler_type", 1);
        moduleConditionMap.put("compiler_code", compilerCode);
        moduleConditionMap.put("compiler_data", compilerData);
        moduleConditionMap.put("compiler_state", 1);
        moduleConditionMap.put("create_user", 0);
        moduleConditionMap.put("modified_user", 0);
        Date now = new Date();
        moduleConditionMap.put("gmt_create", now);
        moduleConditionMap.put("gmt_modified", now);
        insert.setInsertColumns(moduleConditionMap);
        JSONObject json = this.dbWriteUtil.insert(insert, null, null);
        return json;
    }

    public int updateCompilerById(Long id, String compilerCode, byte[] compilerData, int compilerState) throws BizException {
        DBUpdate update = new DBUpdate();
        update.setDb("hainiu_lowcode");
        update.setTable("lowcode_compiler");
        update.setDatabaseProductName(this.defaultDatabaseProductName);
        HashMap<String, Object> moduleConditionMap = new HashMap<String, Object>();
        moduleConditionMap.put("compiler_code", compilerCode);
        moduleConditionMap.put("compiler_data", compilerData);
        moduleConditionMap.put("compiler_state", compilerState);
        moduleConditionMap.put("modified_user", 0);
        Date now = new Date();
        moduleConditionMap.put("gmt_modified", now);
        update.setUpdateColumns(moduleConditionMap);
        HashMap<String, Long> queryCondition = new HashMap<String, Long>();
        queryCondition.put("id", id);
        update.setQueryCondition(queryCondition);
        int redult = this.dbWriteUtil.update(update, null);
        return redult;
    }
}

