/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.sql;

import com.manatee.common.util.tool.core.clone.CloneSupport;
import com.manatee.common.util.tool.core.convert.Convert;
import com.manatee.common.util.tool.core.text.StrSpliter;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.common.util.tool.core.util.NumberUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcodedb.newdb.sql.LogicalOperator;
import com.manatee.lowcodedb.newdb.sql.SqlUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Condition
extends CloneSupport<Condition> {
    private static final String OPERATOR_LIKE = "LIKE";
    public static final String OPERATOR_NOT_LIKE = "NOT LIKE";
    private static final String OPERATOR_IN = "IN";
    private static final String OPERATOR_NOT_IN = "NOT IN";
    private static final String OPERATOR_IS = "IS";
    private static final String OPERATOR_IS_NOT = "IS NOT";
    private static final String OPERATOR_BETWEEN = "BETWEEN";
    private static final List<String> OPERATORS = Arrays.asList("<>", "<=", "<", ">=", ">", "=", "!=", "IN");
    private static final String VALUE_NULL = "NULL";
    public static final String OPERATOR_IS_NULL = "IS NULL";
    public static final String OPERATOR_IS_NOT_NULL = "IS NOT NULL";
    private String field;
    private String operator;
    private Object value;
    private boolean isPlaceHolder = true;
    private Object secondValue;
    private LogicalOperator linkOperator = LogicalOperator.AND;

    public static Condition parse(String field, Object expression) {
        return new Condition(field, expression);
    }

    public Condition() {
    }

    public Condition(boolean isPlaceHolder) {
        this.isPlaceHolder = isPlaceHolder;
    }

    public Condition(String field, Object value) {
        this(field, "=", value);
        this.parseValue();
    }

    public Condition(String field, String operator) {
        this.field = field;
        this.operator = operator;
    }

    public Condition(String field, String operator, Object value) {
        this.field = field;
        this.operator = operator;
        this.value = value;
    }

    public Condition(String field, String value, LikeType likeType) {
        this.field = field;
        this.operator = OPERATOR_LIKE;
        this.value = SqlUtil.buildLikeValue(value, likeType, false);
    }

    public Condition(String field, String value, NotLikeType notLikeType) {
        this.field = field;
        this.operator = OPERATOR_NOT_LIKE;
        this.value = SqlUtil.buildNotLikeValue(value, notLikeType, false);
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.setValue(value, false);
    }

    public void setValue(Object value, boolean isParse) {
        this.value = value;
        if (isParse) {
            this.parseValue();
        }
    }

    public boolean isPlaceHolder() {
        return this.isPlaceHolder;
    }

    public void setPlaceHolder(boolean isPlaceHolder) {
        this.isPlaceHolder = isPlaceHolder;
    }

    public boolean isOperatorBetween() {
        return OPERATOR_BETWEEN.equalsIgnoreCase(this.operator);
    }

    public boolean isOperatorIn() {
        return OPERATOR_IN.equalsIgnoreCase(this.operator);
    }

    public boolean isOperatorNotIn() {
        return OPERATOR_NOT_IN.equalsIgnoreCase(this.operator);
    }

    public boolean isOperatorIs() {
        return OPERATOR_IS.equalsIgnoreCase(this.operator);
    }

    public boolean isOperatorIsNot() {
        return OPERATOR_IS_NOT.equalsIgnoreCase(this.operator);
    }

    public boolean isOperatorLike() {
        return OPERATOR_LIKE.equalsIgnoreCase(this.operator);
    }

    public boolean isOperatorNotLike() {
        return OPERATOR_NOT_LIKE.equalsIgnoreCase(this.operator);
    }

    public boolean isOnlyOperator() {
        return OPERATOR_IS_NULL.equalsIgnoreCase(this.operator) || OPERATOR_IS_NOT_NULL.equalsIgnoreCase(this.operator);
    }

    public Condition checkValueNull() {
        if (null == this.value && !this.isOnlyOperator()) {
            this.value = VALUE_NULL;
            if (StringUtils.equals((CharSequence)this.operator, (CharSequence)"!=")) {
                this.operator = OPERATOR_IS_NOT;
                this.isPlaceHolder = false;
            } else {
                this.operator = OPERATOR_IS;
                this.isPlaceHolder = false;
            }
        }
        return this;
    }

    public Object getSecondValue() {
        return this.secondValue;
    }

    public void setSecondValue(Object secondValue) {
        this.secondValue = secondValue;
    }

    public LogicalOperator getLinkOperator() {
        return this.linkOperator;
    }

    public void setLinkOperator(LogicalOperator linkOperator) {
        this.linkOperator = linkOperator;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(List<Object> paramValues) {
        StringBuilder conditionStrBuilder = StrUtil.builder();
        this.checkValueNull();
        conditionStrBuilder.append(this.field).append(" ").append(this.operator);
        if (this.isOperatorBetween()) {
            this.buildValuePartForBETWEEN(conditionStrBuilder, paramValues);
        } else if (this.isOperatorIn()) {
            this.buildValuePartForIN(conditionStrBuilder, paramValues);
        } else if (this.isOperatorNotIn()) {
            this.buildValuePartForIN(conditionStrBuilder, paramValues);
        } else {
            if (this.isOnlyOperator()) {
                return conditionStrBuilder.toString();
            }
            if (this.isPlaceHolder() && !this.isOperatorIs()) {
                conditionStrBuilder.append(" ?");
                if (null != paramValues) {
                    paramValues.add(this.value);
                }
            } else {
                String valueStr = String.valueOf(this.value);
                conditionStrBuilder.append(" ").append(this.isOperatorLike() || this.isOperatorNotLike() ? StrUtil.wrap((CharSequence)valueStr, (CharSequence)"'") : valueStr);
            }
        }
        return conditionStrBuilder.toString();
    }

    private void buildValuePartForBETWEEN(StringBuilder conditionStrBuilder, List<Object> paramValues) {
        if (this.isPlaceHolder()) {
            conditionStrBuilder.append(" ?");
            if (null != paramValues) {
                paramValues.add(this.value);
            }
        } else {
            conditionStrBuilder.append(' ').append(this.value);
        }
        conditionStrBuilder.append(" ").append((Object)LogicalOperator.AND);
        if (this.isPlaceHolder()) {
            conditionStrBuilder.append(" ?");
            if (null != paramValues) {
                paramValues.add(this.secondValue);
            }
        } else {
            conditionStrBuilder.append(' ').append(this.secondValue);
        }
    }

    private void buildValuePartForIN(StringBuilder conditionStrBuilder, List<Object> paramValues) {
        conditionStrBuilder.append(" (");
        Object value = this.value;
        if (this.isPlaceHolder()) {
            List<Object> valuesForIn = value instanceof Collection ? (List<Object>)value : (value instanceof CharSequence ? StrUtil.split((CharSequence)((CharSequence)value), (char)',') : Arrays.asList((Object[])Convert.convert(Object[].class, (Object)value)));
            conditionStrBuilder.append(StrUtil.repeatAndJoin((CharSequence)"?", (int)valuesForIn.size(), (CharSequence)","));
            if (null != paramValues) {
                paramValues.addAll(valuesForIn);
            }
        } else {
            conditionStrBuilder.append(StrUtil.join((CharSequence)",", (Object[])new Object[]{value}));
        }
        conditionStrBuilder.append(')');
    }

    private void parseValue() {
        List strs;
        if (null == this.value) {
            this.operator = OPERATOR_IS;
            this.value = VALUE_NULL;
            return;
        }
        if (this.value instanceof Collection || ArrayUtil.isArray((Object)this.value)) {
            this.operator = OPERATOR_IN;
            return;
        }
        if (!(this.value instanceof String)) {
            return;
        }
        String valueStr = (String)this.value;
        if (StrUtil.isBlank((CharSequence)valueStr)) {
            return;
        }
        if (StrUtil.endWithIgnoreCase((CharSequence)(valueStr = StrUtil.trim((CharSequence)valueStr)), (CharSequence)"null")) {
            if (StrUtil.equalsIgnoreCase((CharSequence)"= null", (CharSequence)valueStr) || StrUtil.equalsIgnoreCase((CharSequence)"is null", (CharSequence)valueStr)) {
                this.operator = OPERATOR_IS;
                this.value = VALUE_NULL;
                this.isPlaceHolder = false;
                return;
            }
            if (StrUtil.equalsIgnoreCase((CharSequence)"!= null", (CharSequence)valueStr) || StrUtil.equalsIgnoreCase((CharSequence)"is not null", (CharSequence)valueStr)) {
                this.operator = OPERATOR_IS_NOT;
                this.value = VALUE_NULL;
                this.isPlaceHolder = false;
                return;
            }
        }
        if ((strs = StrUtil.split((CharSequence)valueStr, (char)' ', (int)2)).size() < 2) {
            return;
        }
        String firstPart = ((String)strs.get(0)).trim().toUpperCase();
        if (OPERATORS.contains(firstPart)) {
            this.operator = firstPart;
            String valuePart = (String)strs.get(1);
            this.value = this.isOperatorIn() ? valuePart : Condition.tryToNumber(valuePart);
            return;
        }
        if (OPERATOR_LIKE.equals(firstPart)) {
            this.operator = OPERATOR_LIKE;
            this.value = Condition.unwrapQuote((String)strs.get(1));
            return;
        }
        if (OPERATOR_NOT_LIKE.equals(firstPart)) {
            this.operator = OPERATOR_NOT_LIKE;
            this.value = Condition.unwrapQuote((String)strs.get(1));
            return;
        }
        if (OPERATOR_BETWEEN.equals(firstPart)) {
            List betweenValueStrs = StrSpliter.split((String)((String)strs.get(1)), (String)LogicalOperator.AND.toString(), (int)2, (boolean)true, (boolean)true);
            if (betweenValueStrs.size() < 2) {
                return;
            }
            this.operator = OPERATOR_BETWEEN;
            this.value = Condition.unwrapQuote((String)betweenValueStrs.get(0));
            this.secondValue = Condition.unwrapQuote((String)betweenValueStrs.get(1));
        }
    }

    private static String unwrapQuote(String value) {
        char endChar;
        if (null == value) {
            return null;
        }
        value = value.trim();
        int from = 0;
        int to = value.length();
        char startChar = value.charAt(0);
        if (startChar == (endChar = value.charAt(value.length() - 1)) && ('\'' == startChar || '\"' == startChar)) {
            from = 1;
            --to;
        }
        if (from == 0) {
            return value;
        }
        return value.substring(from, to);
    }

    private static Object tryToNumber(String value) {
        if (!NumberUtil.isNumber((CharSequence)(value = StrUtil.trim((CharSequence)value)))) {
            return value;
        }
        try {
            return NumberUtil.parseNumber((String)value);
        }
        catch (Exception ignore) {
            return value;
        }
    }

    public static enum NotLikeType {
        Does_Not_StartWith("does not startWith"),
        Does_Not_EndWith("does not endWith"),
        Does_Not_Contain("does not contain");

        private final String symbol;

        private NotLikeType(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }
    }

    public static enum LikeType {
        StartWith,
        EndWith,
        Contains;

    }
}

