/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.ds;

import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.clone.CloneRuntimeException;
import com.manatee.common.util.tool.core.io.IoUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcodedb.constant.DataBaseTypeEnum;
import com.manatee.lowcodedb.newdb.dialect.DriverUtil;
import com.manatee.lowcodedb.newdb.meta.MetaUtil;
import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DataSourceWrapper
implements DataSource,
Closeable,
Cloneable {
    private final DataSource ds;
    private final String driver;
    private String dataBaseName;

    public static DataSourceWrapper wrap(DataSource ds) {
        return new DataSourceWrapper(ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSourceWrapper(DataSource ds) {
        this.ds = ds;
        String driver = "";
        Connection connection = null;
        try {
            connection = ds.getConnection();
            String schema = MetaUtil.getSchema(connection);
            String databaseProductName = connection.getMetaData().getDatabaseProductName();
            driver = DriverUtil.identifyDriver(databaseProductName);
            if (StrUtil.isBlank((CharSequence)driver)) {
                driver = DriverUtil.identifyDriver(connection.getMetaData().getDriverName());
            }
            if (StringUtil.equals((CharSequence)databaseProductName.toLowerCase(), (CharSequence)DataBaseTypeEnum.MYSQL.getName())) {
                Statement statement = null;
                try {
                    statement = connection.createStatement();
                    statement.execute("SELECT @@hostname");
                }
                catch (SQLException e) {
                    driver = "com.starrocks.jdbc.Driver";
                }
                finally {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
            this.dataBaseName = StrUtil.isNotBlank((CharSequence)schema) ? schema : MetaUtil.getCatalog(connection);
        }
        catch (Exception exception) {
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        this.driver = driver;
    }

    public String getDriver() {
        return this.driver;
    }

    public DataSource getRaw() {
        return this.ds;
    }

    public String getDataBaseName() {
        return this.dataBaseName;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.ds.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.ds.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.ds.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.ds.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.ds.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.ds.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.ds.isWrapperFor(iface);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.ds.getConnection(username, password);
    }

    @Override
    public void close() {
        if (this.ds instanceof AutoCloseable) {
            IoUtil.close((AutoCloseable)((AutoCloseable)((Object)this.ds)));
        }
    }

    public DataSourceWrapper clone() {
        try {
            return (DataSourceWrapper)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CloneRuntimeException((Throwable)e);
        }
    }
}

