/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.manager;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.FileUtil;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.io.IoUtil;
import com.manatee.lowcode.util.GlobalConf;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.http.Method;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MinioManager {
    private static final Logger log = LoggerFactory.getLogger(MinioManager.class);
    @Value(value="${minio.access-key:}")
    public String accessKey;
    @Value(value="${minio.secret-key:}")
    public String secretKey;
    @Value(value="${minio.endpoint:}")
    public String endpoint;

    public JSONObject uploadFile(String fileName, InputStream inputStream, String bucketName, String folder, Boolean autoCover) throws BizException {
        JSONObject result = new JSONObject();
        MinioClient minioClient = this.getMinioClient();
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            boolean exists = minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
            if (!exists) {
                minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
            }
            byte[] fileBytes = IoUtil.readBytes((InputStream)inputStream);
            folder = StringUtil.isBlank((String)folder) ? "" : folder + "/";
            fileName = folder + FileUtil.getNewFileName((Boolean)autoCover, (String)fileName);
            byteArrayInputStream = new ByteArrayInputStream(fileBytes);
            minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(fileName)).stream((InputStream)byteArrayInputStream, (long)byteArrayInputStream.available(), -1L).build());
            String url = minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(fileName)).build());
            result.put("fileName", (Object)fileName);
            result.put("url", (Object)url);
            result.put("fileSize", (Object)fileBytes.length);
        }
        catch (Exception e) {
            BizException bizException = new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
            bizException.setInterrupt(Integer.valueOf(3));
            throw bizException;
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
            try {
                minioClient.close();
            }
            catch (Exception e) {
                log.error("\u5173\u95edminioClient\u5f02\u5e38", (Throwable)e);
            }
        }
        return result;
    }

    public JSONObject uploadFileBase(String base, String bucketName, String folder, String suffix, Boolean autoCover) throws BizException {
        JSONObject result = new JSONObject();
        MinioClient minioClient = this.getMinioClient();
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            boolean exists = minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
            if (!exists) {
                minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
            }
            byte[] imageByte = Base64.getDecoder().decode(base);
            folder = StringUtil.isBlank((String)folder) ? "" : folder + "/";
            String fileName = this.buildBase64Name(imageByte, suffix);
            fileName = folder + FileUtil.getNewFileName((Boolean)autoCover, (String)fileName);
            byteArrayInputStream = new ByteArrayInputStream(imageByte);
            minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(fileName)).stream((InputStream)byteArrayInputStream, (long)byteArrayInputStream.available(), -1L).build());
            String url = minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(fileName)).build());
            result.put("fileName", (Object)fileName);
            result.put("url", (Object)url);
        }
        catch (Exception e) {
            BizException bizException = new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
            bizException.setInterrupt(Integer.valueOf(3));
            throw bizException;
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
            try {
                minioClient.close();
            }
            catch (Exception e) {
                log.error("\u5173\u95edminioClient\u5f02\u5e38", (Throwable)e);
            }
        }
        return result;
    }

    public String downloadFile(String bucketName, String minioFileName, String downloadFileName) throws BizException {
        MinioClient minioClient = this.getMinioClient();
        InputStream inputStream = null;
        try {
            inputStream = minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(minioFileName)).build());
            File tempDir = new File(GlobalConf.TEMP_DIRECTORY);
            if (!tempDir.exists()) {
                tempDir.mkdir();
            }
            File file = new File(tempDir + "/" + downloadFileName);
            try {
                FileUtils.copyToFile((InputStream)inputStream, (File)file);
            }
            catch (Exception e) {
                BizException bizException = new BizException(ResultCode.SYSTEM_ERROR, "\u6587\u4ef6\u6d41\u5199\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
                throw bizException;
            }
            if (!file.exists()) {
                BizException bizException = new BizException(ResultCode.SYSTEM_ERROR, "\u6587\u4ef6\u4e0d\u5b58\u5728");
                throw bizException;
            }
            String string = file.getPath();
            return string;
        }
        catch (Exception e) {
            BizException bizException = new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
            bizException.setInterrupt(Integer.valueOf(3));
            throw bizException;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
            try {
                minioClient.close();
            }
            catch (Exception e) {
                log.error("\u5173\u95edminioClient\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public void removeFile(String bucketName, String minioFileName) throws BizException {
        MinioClient minioClient = this.getMinioClient();
        try {
            minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(minioFileName)).build());
        }
        catch (Exception e) {
            BizException bizException = new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
            bizException.setInterrupt(Integer.valueOf(3));
            throw bizException;
        }
        finally {
            try {
                minioClient.close();
            }
            catch (Exception e) {
                log.error("\u5173\u95edminioClient\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public String getUrl(String bucketName, String minioFileName) throws BizException {
        String url = "";
        MinioClient minioClient = this.getMinioClient();
        try {
            url = minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(minioFileName)).build());
        }
        catch (Exception e) {
            BizException bizException = new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
            bizException.setInterrupt(Integer.valueOf(3));
            throw bizException;
        }
        finally {
            try {
                minioClient.close();
            }
            catch (Exception e) {
                log.error("\u5173\u95edminioClient\u5f02\u5e38", (Throwable)e);
            }
        }
        return url;
    }

    private MinioClient getMinioClient() throws BizException {
        if (StringUtil.isBlank((String)this.endpoint) || StringUtil.isBlank((String)this.accessKey) || StringUtil.isBlank((String)this.secretKey)) {
            throw new BizException(ResultCode.CONF_ERROR, "Minio endpoint/accessKey/secretKey \u914d\u7f6e\u9519\u8bef\u6216\u8005\u672a\u914d\u7f6e");
        }
        MinioClient minioClient = MinioClient.builder().endpoint(this.endpoint).credentials(this.accessKey, this.secretKey).build();
        return minioClient;
    }

    private String buildBase64Name(byte[] imageByte, String suffix) {
        try {
            String base64Str = Base64.getEncoder().encodeToString(imageByte);
            String fileName = DigestUtils.md5Hex((String)base64Str);
            StringBuilder sb = new StringBuilder();
            sb.append(fileName);
            sb.append(".");
            sb.append(suffix);
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }
}

