CREATE TABLE `lowcode_quartz_job` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `project_id` bigint(20) NOT NULL COMMENT '项目ID',
  `job_name` varchar(64) NOT NULL COMMENT '任务名称',
  `job_group` varchar(64) NOT NULL COMMENT '任务组名',
  `job_module_code` varchar(128) NOT NULL COMMENT '任务流程图编码',
  `job_params` varchar(1000) DEFAULT NULL COMMENT '请求参数json',
  `execute_cycle` varchar(64) NOT NULL COMMENT '执行周期，cron表达式',
  `effective_date` datetime DEFAULT NULL COMMENT '生效日期',
  `expiring_date` datetime DEFAULT NULL COMMENT '失效日期',
  `execute_num` int(10) DEFAULT '0' COMMENT '任务执行次数，用于集群同步使用(通过ID+次数修改行，修改成功则执行)',
  `misfire_policy` varchar(4) NOT NULL DEFAULT '0' COMMENT 'Cron计划策略,0=默认,1=立即触发执行,2=触发一次执行,3=不触发立即执行',
  `concurrent` varchar(4) NOT NULL DEFAULT '1' COMMENT '是否并发执行（0允许 1禁止）',
  `status` varchar(4) NOT NULL DEFAULT '0' COMMENT '任务状态（0正常 1暂停）',
  `retry_status` varchar(4) NOT NULL DEFAULT '1' COMMENT '重试状态（0开启 1关闭）',
  `retry_num` int(9) DEFAULT '0' COMMENT '重试次数',
  `retried_num` int(9) DEFAULT '0' COMMENT '已重试次数',
  `retry_interval` int(9) DEFAULT '1' COMMENT '重试间隔',
  `retry_interval_unit` tinyint(4) DEFAULT '2' COMMENT '间隔单位，1:秒，2:分，3:时',
  `callback_status` varchar(4) NOT NULL DEFAULT '1' COMMENT '重试状态（0开启 1关闭）',
  `callback_module_code` varchar(128) DEFAULT NULL COMMENT '回调流程图编码',
  `callback_num` int(9) DEFAULT '0' COMMENT '已回调次数',
  `run_status` varchar(4) NOT NULL DEFAULT '1' COMMENT '运行状态，1-未运行，2-运行中，3-运行成功，4-运行失败，5-已暂停',
  `valid` tinyint(4) DEFAULT '0' COMMENT '删除状态-1 删除  0 正常',
  `create_user` bigint(20) DEFAULT NULL COMMENT '创建用户',
  `modified_user` bigint(20) DEFAULT NULL COMMENT '更新用户',
  `gmt_create` datetime DEFAULT NULL COMMENT '创建时间',
  `gmt_modified` datetime DEFAULT NULL COMMENT '更新时间',
  `execute_time` datetime DEFAULT NULL COMMENT '执行时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;