/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.mongo.store;

import com.manatee.common.domain.DBQuery;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IDBManager;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.mongo.MongoReadUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MongoQueryCountProcess
implements IProcess {
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    protected IInputUtil inputUtil;
    @Resource
    private IProcessConfUtil processConfUtil;
    @Resource
    private MongoReadUtil mongoReadUtil;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private IDBManager dBManager;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"table"});
        DBQuery dbQuery = this.dBManager.getDBQuery(content, "mongo");
        dbQuery.setSelectTotalCount(Boolean.valueOf(true));
        Map param = this.inputUtil.getHandleObject(content, "queryParams");
        if (param != null) {
            dbQuery.setConditionMap(param);
        }
        this.outputUtil.setDefaultReturnKey(content, "count");
        this.outputUtil.handleAndPutData(content, (Object)this.mongoReadUtil.findCount(dbQuery));
    }

    public String getName() {
        return "mongoQueryCount";
    }
}

