/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.process;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.Step;
import com.manatee.redis.domain.DtQuery;
import com.manatee.redis.source.DtSourceManager;
import com.manatee.redis.util.RedisDbUtil;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RedisKeyTtlQueryProcess
implements IProcess {
    @Resource
    private DtSourceManager dtSourceManager;
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private IProcessConfUtil processConfUtil;
    private Logger log = LoggerFactory.getLogger(RedisKeyTtlQueryProcess.class);

    public void process(ProcessContent content) throws BizException {
        Step step = content.getStep();
        JSONObject conf = step.getConf();
        this.processConfUtil.checkConf(content, new String[]{"key"});
        DtQuery query = this.getDtQuery(content, conf);
        if (StringUtil.isBlank((String)conf.getString("returnKey"))) {
            content.getStepConf().put("returnKey", (Object)(query.getKeys().get(0) + "Ttl"));
        }
        long ttl = this.dtSourceManager.getDtSource(query).queryTtl(query);
        this.outputUtil.handleAndPutData(content, (Object)ttl);
        this.log.warn("[QueryObjectProcess.process]_biz_success,code:{},msg:{}", content.getRequest("lowcodeModule"), (Object)"RedisKeyTtlQueryProcess_success");
    }

    private DtQuery getDtQuery(ProcessContent content, JSONObject conf) {
        String objectKey = this.variableUtil.calVarInConf(content, "key");
        int db = RedisDbUtil.getRedisDB(content);
        ArrayList<String> keyList = new ArrayList<String>();
        keyList.add(objectKey);
        DtQuery query = new DtQuery();
        if (conf.containsKey((Object)"isStaticRedis")) {
            query.setStaticRedis(conf.getBoolean("isStaticRedis"));
        }
        query.setDbIndex(db);
        query.setKeys(keyList);
        return query;
    }

    public String getName() {
        return "redisKeyTtlQuery";
    }
}

