/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.process;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.Step;
import com.manatee.redis.source.DtSourceManager;
import com.manatee.redis.util.RedisDbUtil;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RedisHashFieldsRemoveProcess
implements IProcess {
    private Logger log = LoggerFactory.getLogger(RedisHashFieldsRemoveProcess.class);
    @Resource
    private DtSourceManager dtSourceManager;
    @Resource
    private IProcessConfUtil processConfUtil;
    @Resource
    private IVariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        Step step = content.getStep();
        JSONObject conf = step.getConf();
        this.processConfUtil.checkConf(content, new String[]{"key", "input"});
        int db = RedisDbUtil.getRedisDB(content);
        String objectKey = this.variableUtil.calVarInConf(content, "key");
        String fieldsStr = conf.getString("input");
        String[] fields = fieldsStr.split("[,]");
        this.dtSourceManager.getDtSource().hdelValue(db, objectKey, fields);
        this.log.warn("[RemoveRedisHashFieldProcess.process]_biz_occur,msg:{}", (Object)("remove_object_key:" + objectKey + ",fields:" + fields));
    }

    public String getName() {
        return "redisHashFieldsRemove";
    }
}

