/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.dataModel.process;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.InputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.process.IProcess;
import com.manatee.process.ProcessChain;
import com.manatee.process.ProcessDataSource;
import com.manatee.process.domain.ModuleBO;
import com.manatee.process.domain.ProcessContent;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ModelBehaviorProcess
implements IProcess {
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private ProcessDataSource processDataSource;
    @Resource
    protected InputUtil inputUtil;
    @Resource
    private ProcessChain processChain;
    @Resource
    private IOutputUtil outputUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"behavior"});
        JSONObject conf = content.getStepConf();
        Long behaviorModuleId = conf.getLong("behaviorModuleId");
        Long projectId = content.getProjectId();
        ModuleBO moduleBO = this.processDataSource.getModule(projectId, behaviorModuleId);
        if (moduleBO == null || moduleBO.getSteps() == null) {
            BizException exception = new BizException(ResultCode.SYSTEM_ERROR, "module_is_null");
            if (moduleBO != null) {
                exception.putDefaultParam(moduleBO.getCode());
            } else {
                exception.putDefaultParam("ID:" + behaviorModuleId);
            }
            throw exception;
        }
        List steps = moduleBO.getSteps();
        JSONObject tempModuleJson = new JSONObject();
        tempModuleJson.put("systemVersion", (Object)moduleBO.getSystemVersion());
        tempModuleJson.put("name", (Object)moduleBO.getName());
        tempModuleJson.put("url", (Object)moduleBO.getPath());
        tempModuleJson.put("lowcodeModule", (Object)moduleBO.getCode());
        Map params = this.inputUtil.getHandleObject(content, "rqParams");
        JSONObject paramsNew = JSONObject.parseObject((String)JSONObject.toJSONString((Object)params));
        ProcessContent moduleContent = new ProcessContent();
        moduleContent.setRequest((Map)paramsNew);
        moduleContent.setTransactionCon(content.getTransactionCon());
        moduleContent.setModule(tempModuleJson);
        paramsNew.put("tempContext", content.getRequest("tempContext"));
        paramsNew.put("cells", content.getRequest("cells"));
        this.processChain.executeSteps(moduleContent, steps);
        Map moduleResponse = moduleContent.getResponse();
        Object returnDataShow = content.getStepConf().get((Object)"returnDataShow");
        if (returnDataShow == null || Boolean.valueOf(returnDataShow.toString()).booleanValue()) {
            this.outputUtil.setDefaultReturnKey(content, "outputData");
        }
        this.outputUtil.handleAndPutData(content, (Object)moduleResponse);
    }

    public String getName() {
        return "modelBehaviorProcess";
    }
}

