/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.util.ObjectUtil;
import com.manatee.lowcode.exp.manager.ManateeCodeManager;
import com.manatee.lowcode.manager.MappingValueManager;
import com.manatee.lowcode.process.js.JsService;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.util.domain.StrSplit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;

public class DataUtil {
    @Resource
    private MappingValueManager mappingValueManager;
    @Resource
    private ManateeCodeManager manateeCodeManager;
    @Resource
    public JsService jsService;

    public Object handleData(ProcessContent content, String key, Object value) throws BizException {
        if (StringUtil.isBlank((String)key)) {
            key = "dataHandle";
        }
        Object putValue = null;
        if (this.isBatchHandle(content, key)) {
            putValue = this.getBatchMapping(content, key, value);
        } else {
            Map<String, Object> mapping = this.getMapping(content, key, value);
            if (mapping != null) {
                putValue = mapping;
            }
            if (putValue == null) {
                putValue = value;
            }
            if (putValue instanceof Map) {
                this.defaultUnfold(content);
            }
        }
        if (putValue == null) {
            putValue = value;
        }
        return putValue;
    }

    public Object handleDataV2(ProcessContent content, String key, Object value, String syntaxType) throws BizException {
        if (StringUtil.isBlank((String)key)) {
            key = "dataHandle";
        }
        Object putValue = null;
        if (this.isBatchHandle(content, key)) {
            putValue = this.getBatchMappingV2(content, key, value, syntaxType);
        } else {
            Map<String, Object> mapping = this.getMappingV2(content, key, value, syntaxType);
            if (mapping != null) {
                putValue = mapping;
            }
            if (putValue == null) {
                putValue = value;
            }
            if (putValue instanceof Map) {
                this.defaultUnfold(content);
            }
        }
        if (putValue == null) {
            putValue = value;
        }
        return putValue;
    }

    public boolean isBatchHandle(ProcessContent content, String key) throws BizException {
        Object conf = content.getStepConf(key + "Batch");
        if (conf != null) {
            return true;
        }
        String handleType = content.getStepConfString("handleType");
        return "batch".equals(handleType);
    }

    public Object handleData(ProcessContent content, Object value) throws BizException {
        return this.handleData(content, null, value);
    }

    public Object handleDataV2(ProcessContent content, Object value, String syntaxType) throws BizException {
        return this.handleDataV2(content, null, value, syntaxType);
    }

    private void defaultUnfold(ProcessContent content) {
        JSONObject conf = content.getStepConf();
        if (conf.get((Object)"returnKey") == null) {
            conf.put("returnKey", (Object)"outputUnfold");
        }
    }

    protected Map<String, Object> getMapping(ProcessContent content) throws BizException {
        return this.getMapping(content, null, null);
    }

    protected Map<String, Object> getMapping(ProcessContent content, Object value) throws BizException {
        return this.getMapping(content, null, value);
    }

    protected Map<String, Object> getMapping(ProcessContent content, String confKey, Object value) throws BizException {
        JSONObject conf = content.getStepConf();
        return this.getMapping(content, conf, confKey, value);
    }

    protected Map<String, Object> getMappingV2(ProcessContent content, String confKey, Object value, String syntaxType) throws BizException {
        JSONObject conf = content.getStepConf();
        return this.getMappingV2(content, conf, confKey, value, syntaxType);
    }

    private Map<String, Object> doMapping(ProcessContent content, String confKey, Object value) throws BizException {
        JSONObject conf = content.getStepConf();
        Object mappingConf = conf.get((Object)confKey);
        if (mappingConf == null) {
            return null;
        }
        return this.doMapping(content, mappingConf, value);
    }

    protected Map<String, Object> getMapping(ProcessContent content, JSONObject conf, String confKey, Object value) throws BizException {
        JSONObject mapJson;
        Object mapConf;
        if (StringUtil.isBlank((String)confKey)) {
            confKey = "params";
        }
        if ((mapConf = conf.get((Object)confKey)) == null) {
            return null;
        }
        if (mapConf instanceof JSONObject && (mapJson = (JSONObject)mapConf).size() == 0) {
            return null;
        }
        Object mappingConf = conf.get((Object)confKey);
        return this.doMapping(content, mappingConf, value);
    }

    protected Map<String, Object> getMappingV2(ProcessContent content, JSONObject conf, String confKey, Object value, String syntaxType) throws BizException {
        JSONObject mapJson;
        Object mapConf;
        if (StringUtil.isBlank((String)confKey)) {
            confKey = "params";
        }
        if ((mapConf = conf.get((Object)confKey)) == null) {
            return null;
        }
        if (mapConf instanceof JSONObject && (mapJson = (JSONObject)mapConf).size() == 0) {
            return null;
        }
        Object mappingConf = conf.get((Object)confKey);
        return this.doMappingV2(content, mappingConf, value, syntaxType);
    }

    public Map<String, Object> doMapForMapConf(ProcessContent content, Object mappingConf) throws BizException {
        return this.doMapping(content, mappingConf, null);
    }

    private Map<String, Object> doMapping(ProcessContent content, Object mappingConf, Object value) throws BizException {
        JSONObject stepConf = content.getStepConf();
        Map mapValue = this.value2Map(value);
        content.addTempData(mapValue);
        Object re = null;
        if (mappingConf instanceof JSONObject) {
            JSONObject conf = (JSONObject)mappingConf;
            re = this.mappingValueManager.mappingValue(content, conf);
        } else {
            String conf = (String)mappingConf;
            re = this.manateeCodeManager.analysis2ManateeExp(content, conf);
        }
        re = DataUtil.mergeFields(stepConf, mapValue, (Map<String, Object>)re);
        content.removeTempData();
        return re;
    }

    private Map<String, Object> doMappingV2(ProcessContent content, Object mappingConf, Object value, String syntaxType) throws BizException {
        JSONObject stepConf = content.getStepConf();
        Map mapValue = this.value2Map(value);
        content.addTempData(mapValue);
        Object re = null;
        if (mappingConf instanceof JSONObject) {
            JSONObject conf = (JSONObject)mappingConf;
            re = this.mappingValueManager.mappingValue(content, conf);
        } else {
            String conf = (String)mappingConf;
            re = StringUtils.isBlank((CharSequence)syntaxType) || StringUtils.equals((CharSequence)syntaxType, (CharSequence)"manateeSyntax") ? this.manateeCodeManager.analysis2ManateeExp(content, conf) : this.jsService.getHandleMapConf(content, conf);
        }
        re = DataUtil.mergeFields(stepConf, mapValue, (Map<String, Object>)re);
        content.removeTempData();
        return re;
    }

    public Map value2Map(Object value) {
        HashMap<String, Object> mapValue = null;
        if (value != null) {
            if (value instanceof Map) {
                mapValue = (HashMap<String, Object>)value;
            } else {
                mapValue = new HashMap<String, Object>();
                mapValue.put("_thisResult", value);
            }
        }
        return mapValue;
    }

    public List<Map<String, Object>> getBatchMapping(ProcessContent content, String confKey, Object value) throws BizException {
        JSONObject conf = content.getStepConf();
        Object outputMapping = conf.get((Object)confKey);
        if (outputMapping == null) {
            outputMapping = conf.get((Object)(confKey + "Batch"));
            if (outputMapping != null) {
                confKey = confKey + "Batch";
            } else {
                return null;
            }
        }
        if (!(value instanceof JSONArray) && !(value instanceof List)) {
            return null;
        }
        int index = 0;
        if (conf.containsKey((Object)"startIndex")) {
            index = conf.getInteger("startIndex");
        }
        boolean hasThis = this.hasThis(outputMapping);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List list = (List)value;
        List<Map<String, Object>> paramList = this.getListMap(content, list);
        for (Map<String, Object> param : paramList) {
            HashMap<String, Object> thisParam = new HashMap<String, Object>();
            thisParam.putAll(param);
            if (thisParam.get("_index") == null) {
                content.addTemp("_index", (Object)index);
            }
            ++index;
            if (thisParam.get("index") == null) {
                content.addTemp("index", (Object)index);
            }
            if (hasThis) {
                Object thisData = ObjectUtil.cloneByStream(param);
                content.addTemp("_this", thisData);
            }
            Map<String, Object> re = this.doMapping(content, outputMapping, thisParam);
            result.add(re);
            content.removeTempData();
        }
        content.removeTemp("_this");
        content.removeTemp("index");
        content.removeTemp("_index");
        return result;
    }

    public List<Map<String, Object>> getBatchMappingV2(ProcessContent content, String confKey, Object value, String syntaxType) throws BizException {
        JSONObject conf = content.getStepConf();
        Object outputMapping = conf.get((Object)confKey);
        if (outputMapping == null) {
            outputMapping = conf.get((Object)(confKey + "Batch"));
            if (outputMapping != null) {
                confKey = confKey + "Batch";
            } else {
                return null;
            }
        }
        if (!(value instanceof JSONArray) && !(value instanceof List)) {
            return null;
        }
        int index = 0;
        if (conf.containsKey((Object)"startIndex")) {
            index = conf.getInteger("startIndex");
        }
        boolean hasThis = this.hasThis(outputMapping);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List list = (List)value;
        List<Map<String, Object>> paramList = this.getListMap(content, list);
        for (Map<String, Object> param : paramList) {
            HashMap<String, Object> thisParam = new HashMap<String, Object>();
            thisParam.putAll(param);
            if (thisParam.get("_index") == null) {
                content.addTemp("_index", (Object)index);
            }
            ++index;
            if (thisParam.get("index") == null) {
                content.addTemp("index", (Object)index);
            }
            if (hasThis) {
                Object thisData = ObjectUtil.cloneByStream(param);
                content.addTemp("_this", thisData);
            }
            Map<String, Object> re = this.doMappingV2(content, outputMapping, thisParam, syntaxType);
            result.add(re);
            content.removeTempData();
        }
        content.removeTemp("_this");
        content.removeTemp("index");
        content.removeTemp("_index");
        return result;
    }

    private boolean hasThis(Object outputMapping) {
        String outputMappingStr;
        boolean hasThis = false;
        if (outputMapping instanceof String && (outputMappingStr = (String)outputMapping).indexOf("_this") != -1) {
            hasThis = true;
        }
        return hasThis;
    }

    private List<Map<String, Object>> getListMap(ProcessContent content, List list) {
        if (this.isListMap(list)) {
            return list;
        }
        String key = DataUtil.getInputKey(content);
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>();
        for (Object object : list) {
            HashMap map = new HashMap();
            map.put(key, object);
            paramList.add(map);
        }
        return paramList;
    }

    public static String getInputKey(ProcessContent content) {
        String key = (String)content.getStepConf("inputKey");
        if (StringUtil.isBlank((String)key)) {
            key = "key";
        }
        return key;
    }

    private boolean isListMap(List list) {
        for (Object value : list) {
            if (!(value instanceof Map)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Object> mergeFields(JSONObject conf, Map<String, Object> param, Map<String, Object> aValue) {
        if (param == null || aValue == null) {
            return aValue;
        }
        param.remove("_thisResult");
        if (Boolean.TRUE.equals(conf.getBoolean("mergeFields"))) {
            HashMap<String, Object> newValue = new HashMap<String, Object>();
            newValue.putAll(param);
            newValue.putAll(aValue);
            return newValue;
        }
        return aValue;
    }

    protected Map<String, Object> paramFormatAndCheck(ProcessContent content, Map<String, Object> param) throws BizException {
        return this.paramFormatAndCheck(content, param, null);
    }

    protected Map<String, Object> paramFormatAndCheck(ProcessContent content, Map<String, Object> param, JSONObject conf) throws BizException {
        if (conf == null) {
            conf = content.getStepConf();
        }
        this.paramCheck(content, conf, param);
        Object paramTypeObj = conf.get((Object)"paramsType");
        JSONObject paramType = null;
        if (paramTypeObj instanceof JSONObject) {
            paramType = (JSONObject)paramTypeObj;
        } else {
            String paramTypeStr = paramTypeObj + "";
            if (StringUtil.isBlank((String)paramTypeStr)) {
                return param;
            }
            paramType = this.getParamTypeByExp(paramTypeStr);
        }
        if (paramType == null || paramType.size() == 0) {
            return param;
        }
        LinkedHashMap<String, Object> newParam = new LinkedHashMap<String, Object>();
        for (String key : param.keySet()) {
            Object aValue = param.get(key);
            Object value = this.format(paramType, key, aValue);
            newParam.put(key, value);
        }
        return newParam;
    }

    public JSONObject getParamTypeByExp(String paramTypeStr) {
        paramTypeStr = paramTypeStr.replace("\n", "").replace(" ", "");
        String[] paramTypeStrs = paramTypeStr.split(com.manatee.common.domain.StrSplit.FH);
        JSONObject paramType = new JSONObject(true);
        for (int i = 0; i < paramTypeStrs.length; ++i) {
            String[] params;
            String aParam = paramTypeStrs[i];
            if (StringUtil.isBlank((String)aParam) || (params = aParam.split(com.manatee.common.domain.StrSplit.DH)).length != 2) continue;
            paramType.put(params[0], (Object)params[1]);
        }
        return paramType;
    }

    private Object format(JSONObject paramType, String key, Object value) throws BizException {
        String type = paramType.getString(key);
        if (StringUtil.isBlank((String)type)) {
            return value;
        }
        try {
            if (value == null) {
                return null;
            }
            if ("long".equals(type) || "Long".equals(type) || "java.lang.Long".equals(type)) {
                return Long.valueOf(value + "");
            }
            if ("double".equals(type) || "Double".equals(type) || "java.lang.Double".equals(type)) {
                return Double.valueOf(value + "");
            }
            if ("int".equals(type) || "Integer".equals(type) || "java.lang.Integer".equals(type)) {
                return Integer.valueOf(value + "");
            }
            if ("string".equals(type) || "String".equals(type) || "java.lang.String".equals(type)) {
                return value + "";
            }
            if ("short".equals(type) || "Short".equals(type) || "java.lang.Short".equals(type)) {
                return Short.valueOf(value + "");
            }
            if ("boolean".equals(type) || "Boolean".equals(type) || "java.lang.Boolean".equals(type)) {
                return Boolean.valueOf(value + "");
            }
            if ("byte".equals(type) || "Byte".equals(type) || "java.lang.Byte".equals(type)) {
                return Byte.valueOf(value + "");
            }
            if ("float".equals(type) || "Float".equals(type) || "java.lang.Float".equals(type)) {
                return Float.valueOf(value + "");
            }
            if ("char".equals(type) || "Character".equals(type) || "java.lang.Character".equals(type)) {
                return Character.valueOf((value + "").charAt(0));
            }
        }
        catch (Throwable e2) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, type + "_is_error,value:" + value, e2);
        }
        if (type.indexOf(com.manatee.common.domain.StrSplit.P) == -1) {
            return value;
        }
        if (!(value instanceof JSON) && !(value instanceof Map)) {
            return value;
        }
        Object valueParse = JSON.parse((String)JSON.toJSONString((Object)value));
        JSON valueJSON = (JSON)valueParse;
        if ("java.util.Map".equals(type) && (value instanceof JSONObject || value instanceof Map)) {
            HashMap aMap = new HashMap();
            if (value instanceof JSONObject) {
                JSONObject jsonValue = (JSONObject)value;
                aMap.putAll(jsonValue);
                return aMap;
            }
            Map valueMap = (Map)value;
            return valueMap;
        }
        try {
            Class<?> cla = Class.forName(type);
            return JSON.toJavaObject((JSON)valueJSON, cla);
        }
        catch (ClassNotFoundException e3) {
            throw new BizException(ResultCode.CONF_ERROR, type + ",not_found");
        }
    }

    private void paramCheck(ProcessContent content, JSONObject conf, Map<String, Object> paramJson) throws BizException {
        if (conf == null) {
            conf = content.getStepConf();
        }
        if (conf.containsKey((Object)"inputCheck")) {
            String[] checkFields;
            String checkFieldStr = conf.getString("inputCheck");
            for (String checkField : checkFields = checkFieldStr.split(StrSplit.D)) {
                String value = (String)paramJson.get(checkField);
                if (!StringUtil.isBlank((String)value)) continue;
                throw new BizException(ResultCode.PARAM_IS_ERROR, checkField + "_is_null");
            }
        }
    }
}

