/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.core.convert.impl;

import com.manatee.common.util.tool.core.bean.BeanUtil;
import com.manatee.common.util.tool.core.convert.AbstractConverter;
import com.manatee.common.util.tool.core.convert.ConverterRegistry;
import com.manatee.common.util.tool.core.map.MapUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.common.util.tool.core.util.TypeUtil;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;

public class MapConverter
extends AbstractConverter<Map<?, ?>> {
    private static final long serialVersionUID = 1L;
    private final Type mapType;
    private final Type keyType;
    private final Type valueType;

    public MapConverter(Type mapType) {
        this(mapType, TypeUtil.getTypeArgument(mapType, 0), TypeUtil.getTypeArgument(mapType, 1));
    }

    public MapConverter(Type mapType, Type keyType, Type valueType) {
        this.mapType = mapType;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    protected Map<?, ?> convertInternal(Object value) {
        Map<Object, Object> map;
        if (value instanceof Map) {
            Type[] typeArguments = TypeUtil.getTypeArguments(value.getClass());
            if (null != typeArguments && 2 == typeArguments.length && Objects.equals(this.keyType, typeArguments[0]) && Objects.equals(this.valueType, typeArguments[1])) {
                return (Map)value;
            }
            map = MapUtil.createMap(TypeUtil.getClass(this.mapType));
            this.convertMapToMap((Map)value, map);
        } else if (BeanUtil.isBean(value.getClass())) {
            map = BeanUtil.beanToMap(value);
            map = this.convertInternal(map);
        } else {
            throw new UnsupportedOperationException(StrUtil.format("Unsupport toMap value type: {}", value.getClass().getName()));
        }
        return map;
    }

    private void convertMapToMap(Map<?, ?> srcMap, Map<Object, Object> targetMap) {
        ConverterRegistry convert = ConverterRegistry.getInstance();
        for (Map.Entry<?, ?> entry : srcMap.entrySet()) {
            Object key = TypeUtil.isUnknown(this.keyType) ? entry.getKey() : convert.convert(this.keyType, entry.getKey());
            Object value = TypeUtil.isUnknown(this.valueType) ? entry.getValue() : convert.convert(this.valueType, entry.getValue());
            targetMap.put(key, value);
        }
    }

    @Override
    public Class<Map<?, ?>> getTargetType() {
        return TypeUtil.getClass(this.mapType);
    }
}

