/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.exception;

import com.manatee.common.domain.ResultBase;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.domain.ResultTrace;
import com.manatee.common.util.StringUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class BizException
extends Exception
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1907637949934358992L;
    private ResultTrace resultTrace = new ResultTrace();
    private String id;
    private String stepName;
    private String stepTitle;
    private String executePath;
    private String errorModuleUrl;
    private String processCode;
    private Map<String, Object> content = new HashMap<String, Object>();

    public String getStepTitle() {
        return this.stepTitle;
    }

    public void setStepTitle(String stepTitle) {
        this.stepTitle = stepTitle;
    }

    public BizException() {
    }

    public BizException(String message) {
        super(message);
    }

    public BizException(ResultCode resultCode, Throwable cause) {
        super(cause.getMessage(), cause);
        this.resultTrace.setResultCode(resultCode);
        this.resultTrace.setSubCode(cause.getMessage());
    }

    public BizException(ResultCode resultCode, String subCode) {
        super(subCode);
        this.setResultCode(resultCode);
        this.setSubCode(subCode);
    }

    public BizException(ResultCode resultCode, String subCode, String stepName) {
        super(subCode);
        this.setResultCode(resultCode);
        this.setSubCode(subCode);
        this.stepName = stepName;
    }

    public BizException(ResultCode resultCode, String subCode, Throwable cause) {
        super(subCode, cause);
        this.setResultCode(resultCode);
        this.setSubCode(subCode);
    }

    public BizException(ResultCode resultCode) {
        super(resultCode.getCode());
        this.resultTrace.setResultCode(resultCode);
    }

    public BizException(Throwable cause) {
        super(cause.getMessage(), cause);
        if (cause instanceof BizException) {
            BizException bizException = (BizException)cause;
            this.resultTrace.setResultCode(bizException.getResultCode());
        } else {
            this.resultTrace.setResultCode(ResultCode.SYSTEM_ERROR);
            this.setSubCode(cause.getMessage());
        }
    }

    public BizException(ResultBase result) {
        super(result.getSubCode(), result.getException());
        this.resultTrace = result.getResultTrace();
    }

    public boolean equal(ResultCode resultCode) {
        String code = this.getCode();
        return code != null && code.equals(resultCode.getCode());
    }

    public void setConfKey(String subCode) {
        this.resultTrace.setConfKey(subCode);
    }

    public String getConfKey() {
        return this.resultTrace.getConfKey();
    }

    public Integer getInterrupt() {
        return this.resultTrace.getInterrupt();
    }

    public void setInterrupt(Integer interrupt) {
        this.resultTrace.setInterrupt(interrupt);
    }

    public void setTraceId(String traceId) {
        this.resultTrace.setTraceId(traceId);
    }

    public int getCodeId() {
        return this.resultTrace.getId();
    }

    public String getCode() {
        return this.resultTrace.getCode();
    }

    public void setCode(String code) {
        this.resultTrace.setCode(code);
    }

    public String getTraceId() {
        return this.resultTrace.getTraceId();
    }

    public String getSubCode() {
        return this.resultTrace.getSubCode();
    }

    public void setSubCode(String subCode) {
        this.resultTrace.setSubCode(subCode);
    }

    public ResultCode getResultCode() {
        return this.resultTrace.getResultCode();
    }

    public ResultTrace getResultTrace() {
        return this.resultTrace;
    }

    public void setResultCode(ResultCode resultCode) {
        this.resultTrace.setResultCode(resultCode);
    }

    public void setResultStatus(Integer resultStatus) {
        this.resultTrace.setResultStatus(resultStatus);
    }

    public String getStepName() {
        return this.stepName;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    public void setMsg(String msg) {
        if (StringUtil.isNotBlank(msg)) {
            this.resultTrace.setMsg(msg);
        }
    }

    public void putDefaultParam(String param) {
        if (StringUtil.isNotBlank(param)) {
            this.resultTrace.putDefaultParam(param);
        }
    }

    public String getDefaultParam() {
        return this.resultTrace.getDefaultParam();
    }

    public void putContent(String key, Object value) {
        this.content.put(key, value);
    }

    public Object getContent(String key) {
        return this.content.get(key);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProcessCode() {
        return this.processCode;
    }

    public void setProcessCode(String processCode) {
        this.processCode = processCode;
    }

    public String getExecutePath() {
        return this.executePath;
    }

    public void setExecutePath(String executePath) {
        this.executePath = executePath;
    }

    public String getErrorModuleUrl() {
        return this.errorModuleUrl;
    }

    public void setErrorModuleUrl(String errorModuleUrl) {
        this.errorModuleUrl = errorModuleUrl;
    }
}

