/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.common.util.tool.json.JSONUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.task.Comment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CamundaQueryHistoricTaskProcess
implements IProcess {
    @Resource
    private VariableUtil variableUtil;
    @Autowired
    private TaskService taskService;
    @Resource
    private HistoryService historyService;
    @Resource
    protected IOutputUtil outputUtil;

    public void process(ProcessContent content) throws BizException {
        String processInstanceId = this.variableUtil.calVarInConf(content, "processInstanceId");
        HistoricTaskInstanceQuery historicTaskInstanceQuery = this.historyService.createHistoricTaskInstanceQuery();
        if (StrUtil.isNotBlank((CharSequence)processInstanceId)) {
            historicTaskInstanceQuery.processInstanceId(processInstanceId);
        }
        List list = ((HistoricTaskInstanceQuery)historicTaskInstanceQuery.orderByHistoricActivityInstanceStartTime().desc()).list();
        String jsonString = JSONUtil.toJsonStr((Object)list);
        JSONArray objects = JSONArray.parseArray((String)jsonString);
        for (int i = 0; i < objects.size(); ++i) {
            JSONObject jsonObject = objects.getJSONObject(i);
            List taskComments = this.taskService.getTaskComments(jsonObject.getString("id"));
            if (!CollUtil.isNotEmpty((Collection)taskComments)) continue;
            Comment comment = (Comment)taskComments.get(0);
            jsonObject.put("fullMessage", (Object)comment.getFullMessage());
        }
        this.outputUtil.putData(content, (Object)objects);
    }

    public String getName() {
        return "camundaQueryHistoricTaskProcess";
    }
}

