/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.runtime;

import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.Map;
import javax.annotation.Resource;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CamundaStartFlowProcess
implements IProcess {
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    protected IInputUtil inputUtil;
    @Resource
    private VariableUtil variableUtil;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private IdentityService identityService;

    public void process(ProcessContent content) throws BizException {
        Map variables = this.inputUtil.getHandleObject(content, "dataHandle");
        String processDefinitionKey = this.variableUtil.calVarInConf(content, "prcesssKey");
        String businessKey = this.variableUtil.calVarInConf(content, "businessKey");
        String userId = this.variableUtil.calVarInConf(content, "userId");
        if (StrUtil.isNotBlank((CharSequence)userId)) {
            this.identityService.setAuthenticatedUserId(userId);
        }
        ProcessInstance processInstance = null;
        processInstance = StrUtil.isNotBlank((CharSequence)businessKey) ? this.runtimeService.startProcessInstanceByKey(processDefinitionKey, businessKey, variables) : this.runtimeService.startProcessInstanceByKey(processDefinitionKey, variables);
        this.outputUtil.setDefaultReturnKey(content, "processInstanceId");
        this.outputUtil.putData(content, (Object)processInstance.getId());
    }

    public String getName() {
        return "camundaStartFlow";
    }
}

