CREATE TABLE lowcode_logic_base (
  id BIGSERIAL NOT NULL,
  project_id BIGINT NOT NULL,
  logic_type smallint DEFAULT '1',
  logic_name varchar(32) NOT NULL,
  logic_code varchar(64) NOT NULL,
  logic_pingyin varchar(255) NOT NULL,
  description varchar(255) DEFAULT NULL,
  physical_datasource varchar(128) DEFAULT NULL,
  physical_id BIGINT DEFAULT NULL,
  physical_table varchar(128) DEFAULT NULL,
  convert_ptl_module_id BIGINT DEFAULT NULL,
  convert_ptl_state smallint DEFAULT '0',
  convert_ltp_module_id BIGINT DEFAULT NULL,
  convert_ltp_state smallint DEFAULT '0',
  create_user BIGINT DEFAULT NULL,
  gmt_create TIMESTAMP DEFAULT NULL,
  modified_user BIGINT DEFAULT NULL,
  gmt_modified TIMESTAMP DEFAULT NULL,
  valid smallint DEFAULT 0,
  logic_conf text NULL,
  logic_version varchar(32) DEFAULT '1',
  sub_logic_type smallint DEFAULT NULL,
  PRIMARY KEY (id)
);
create index idx_projectId_code on lowcode_logic_base(project_id, logic_code)