CREATE TABLE `lowcode_base_graphs` (
   `id` bigint(20) NOT NULL AUTO_INCREMENT,
   `project_id` bigint(20) NOT NULL COMMENT '项目id',
   `biz_id` bigint(20) NOT NULL COMMENT '业务id',
   `biz_type` tinyint(4) NOT NULL COMMENT '业务类型: 1.模块，2.对象',
   `source_id` bigint(20) NOT NULL COMMENT '起点id',
   `target_id` bigint(20) NOT NULL COMMENT '目标id',
   `direction` tinyint(4) NOT NULL DEFAULT '0' COMMENT '方向：0反向，1正向',
   `valid` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态\\n-1 删除  \\n0 正常',
   `gmt_create` datetime NOT NULL COMMENT '创建时间',
   `gmt_modified` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
   `create_user` bigint(20) NOT NULL COMMENT '创建用户id',
   `modified_user` bigint(20) NOT NULL COMMENT '更新用户id',
   PRIMARY KEY (`id`),
   UNIQUE KEY `uniq_module_graphs_project_biz_source_target_valid` (`project_id`,`biz_id`,`biz_type`,`source_id`,`target_id`,`valid`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4