/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.performance.base;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.manager.SpringContextManager;
import com.manatee.process.ProcessChain;
import com.manatee.process.ProcessDataSource;
import com.manatee.process.domain.ProcessContent;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ConcurrentThread
implements Runnable {
    private Logger log = LoggerFactory.getLogger(ConcurrentThread.class);
    private ProcessContent content;
    private JSONObject stepConf;
    private CountDownLatch latch;
    private String traceId;

    public ConcurrentThread(ProcessContent content, JSONObject stepConf, CountDownLatch latch, String traceId) {
        this.content = content;
        this.latch = latch;
        this.stepConf = stepConf;
        this.traceId = traceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MDC.put((String)"traceId", (String)this.traceId);
        try {
            ProcessContent processContent = this.content;
            synchronized (processContent) {
                List steps = ProcessDataSource.formatSteps((JSONObject)this.stepConf);
                ProcessChain processChain = (ProcessChain)SpringContextManager.getBean((String)"processChain");
                processChain.executeSteps(this.content, steps);
                if (this.latch != null) {
                    this.latch.countDown();
                }
            }
        }
        catch (BizException e) {
            this.log.error("[ConcurrentThread.run]_exception", (Throwable)e);
        }
    }
}

