/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.process;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BloomFilterProcess
implements IProcess {
    ConcurrentHashMap<String, BloomFilter> BLOOM_FILTER_MAP = new ConcurrentHashMap();
    @Resource
    protected IOutputUtil outputUtil;
    @Autowired
    private ProcessConfUtil processConfUtil;
    @Resource
    private VariableUtil variableUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void process(ProcessContent content) throws BizException {
        BloomFilter bloomFilter;
        this.processConfUtil.checkConf(content, new String[]{"needFilterKey"});
        String bloomFilterKey = content.getStepConfString("bloomFilterKey");
        String needFilterKey = this.variableUtil.calVarInConf(content, "needFilterKey");
        String size = content.getStepConfString("size");
        String fppStr = content.getStepConfString("fpp");
        int expectedInsertions = 10000;
        if (StrUtil.isNotBlank((CharSequence)size)) {
            expectedInsertions = Integer.parseInt(size);
        }
        double fpp = 0.001;
        if (StrUtil.isNotBlank((CharSequence)fppStr)) {
            fpp = Double.parseDouble(fppStr);
        }
        if (StrUtil.isBlank((CharSequence)bloomFilterKey)) {
            bloomFilterKey = "base";
        }
        if ((bloomFilter = this.BLOOM_FILTER_MAP.get(bloomFilterKey)) == null) {
            Class<BloomFilterProcess> clazz = BloomFilterProcess.class;
            // MONITORENTER : com.manatee.lowcode.process.BloomFilterProcess.class
            if (bloomFilter == null) {
                bloomFilter = BloomFilter.create((Funnel)Funnels.stringFunnel((Charset)Charset.defaultCharset()), (int)expectedInsertions, (double)fpp);
                this.BLOOM_FILTER_MAP.put(bloomFilterKey, bloomFilter);
            }
            // MONITOREXIT : clazz
        }
        boolean b = bloomFilter.mightContain((Object)needFilterKey);
        bloomFilter.put((Object)needFilterKey);
        this.outputUtil.putData(content, (Object)b);
    }

    public String getName() {
        return "bloomFilterProcess";
    }
}

