/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.graphs.data;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.dal.ManateeGraphDao;
import com.manatee.lowcode.dal.ManateeGraphDo;
import com.manatee.lowcode.graphs.so.ManateeGraphSo;
import com.manatee.lowcode.graphs.so.ManateeNodeSo;
import com.manatee.lowcode.graphs.vo.ManateeEdgeVo;
import com.manatee.lowcode.graphs.vo.ManateeGraphVo;
import com.manatee.lowcode.util.CacheRamUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class GraphsData {
    private static final Long UPDATE_TIME = 60L;
    @Resource
    private ManateeGraphDao manateeGraphDao;
    @Resource
    private CacheRamUtil cacheRamUtil;

    public ManateeGraphVo getNodes(Long project, Long nodeId, Integer bizType) throws BizException {
        String graphsId = "MANATEE_GRAPH_SO" + project + "_" + bizType;
        ManateeGraphSo manateeGraphSo = (ManateeGraphSo)this.cacheRamUtil.getCache(graphsId);
        if (manateeGraphSo == null || manateeGraphSo.getTimeVersion() == null) {
            List<ManateeGraphDo> manateeGraphDos = this.manateeGraphDao.findGraphByBizType(project, bizType, null);
            this.addNodeToGraph(manateeGraphDos, graphsId);
            manateeGraphSo = (ManateeGraphSo)this.cacheRamUtil.getCache(graphsId);
        } else {
            Date timeVersion = manateeGraphSo.getTimeVersion();
            List<ManateeGraphDo> manateeGraphDos = this.manateeGraphDao.findGraphByBizType(project, bizType, timeVersion);
            this.addNodeToGraph(manateeGraphDos, graphsId);
        }
        ManateeGraphVo manateeGraphVo = new ManateeGraphVo();
        if (manateeGraphSo == null) {
            return manateeGraphVo;
        }
        ManateeNodeSo targetNode = new ManateeNodeSo();
        targetNode.setId(nodeId);
        MutableGraph<ManateeNodeSo> graph = manateeGraphSo.getGraph();
        boolean contains = graph.nodes().contains(targetNode);
        if (!contains) {
            return manateeGraphVo;
        }
        Set reachNodes = Graphs.reachableNodes(graph, (Object)targetNode);
        MutableGraph integerMutableGraph = Graphs.inducedSubgraph(graph, (Iterable)reachNodes);
        Set nodes = integerMutableGraph.nodes();
        Set edges = integerMutableGraph.edges();
        Set<ManateeEdgeVo> manateeEdgeVos = this.convertEdges(edges);
        manateeGraphVo.setNodes(new ArrayList<ManateeNodeSo>(nodes));
        manateeGraphVo.setEdges(new ArrayList<ManateeEdgeVo>(manateeEdgeVos));
        return manateeGraphVo;
    }

    private void addNodeToGraph(List<ManateeGraphDo> manateeGraphDos, String graphsId) {
        if (manateeGraphDos == null || manateeGraphDos.size() <= 0) {
            return;
        }
        ManateeGraphSo manateeGraphSo = (ManateeGraphSo)this.cacheRamUtil.getCache(graphsId);
        if (manateeGraphSo == null) {
            manateeGraphSo = new ManateeGraphSo();
            this.cacheRamUtil.setCache(graphsId, (Object)manateeGraphSo, UPDATE_TIME);
        }
        MutableGraph<ManateeNodeSo> graph = manateeGraphSo.getGraph();
        for (ManateeGraphDo manateeGraphDo : manateeGraphDos) {
            ManateeNodeSo sourceNode = new ManateeNodeSo();
            ManateeNodeSo targetNode = new ManateeNodeSo();
            sourceNode.setId(manateeGraphDo.getSourceId());
            targetNode.setId(manateeGraphDo.getTargetId());
            Integer valid = manateeGraphDo.getValid();
            if (manateeGraphDo.getDirection() == 0) {
                if (valid < 0) {
                    graph.removeEdge((Object)targetNode, (Object)sourceNode);
                } else {
                    graph.putEdge((Object)targetNode, (Object)sourceNode);
                }
            } else if (valid < 0) {
                graph.removeEdge((Object)sourceNode, (Object)targetNode);
            } else {
                graph.putEdge((Object)sourceNode, (Object)targetNode);
            }
            if (manateeGraphSo.getTimeVersion() != null && manateeGraphSo.getTimeVersion().getTime() > manateeGraphDo.getGmtModified().getTime()) continue;
            manateeGraphSo.setTimeVersion(manateeGraphDo.getGmtModified());
        }
    }

    private Set<ManateeEdgeVo> convertEdges(Set<EndpointPair<ManateeNodeSo>> edges) {
        HashSet<ManateeEdgeVo> result = new HashSet<ManateeEdgeVo>();
        if (edges == null || edges.size() <= 0) {
            return result;
        }
        for (EndpointPair<ManateeNodeSo> edge : edges) {
            ManateeEdgeVo edgeVo = new ManateeEdgeVo();
            ManateeNodeSo source = (ManateeNodeSo)edge.source();
            ManateeNodeSo target = (ManateeNodeSo)edge.target();
            edgeVo.setId(source.getId() + target.getId());
            edgeVo.setSoureId(source.getId());
            edgeVo.setTargetId(target.getId());
            result.add(edgeVo);
        }
        return result;
    }
}

