/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.task;

import com.manatee.common.exception.BizException;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import javax.annotation.Resource;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.task.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CamundaDeleteFlowProcess
implements IProcess {
    @Resource
    private VariableUtil variableUtil;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;

    public void process(ProcessContent content) throws BizException {
        String taskId = this.variableUtil.calVarInConf(content, "taskId");
        String deleteReason = this.variableUtil.calVarInConf(content, "deleteReason");
        Task task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        this.runtimeService.deleteProcessInstance(task.getProcessInstanceId(), deleteReason);
        this.taskService.complete(task.getId());
    }

    public String getName() {
        return "camundaDeleteFlow";
    }
}

