/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.runtime;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.common.util.tool.json.JSONUtil;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.util.StringUtil;
import java.util.Map;
import javax.annotation.Resource;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CamundaSetVariableProcess
implements IProcess {
    private static final Logger log = LoggerFactory.getLogger(CamundaSetVariableProcess.class);
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    protected IInputUtil inputUtil;
    @Resource
    private VariableUtil variableUtil;
    @Autowired
    private RuntimeService runtimeService;
    @Resource
    private TaskService taskService;

    public void process(ProcessContent content) throws BizException {
        String processInstanceId = this.getOneVarValue(content, "processInstanceId");
        String taskId = this.getOneVarValue(content, "taskId");
        String variableType = content.getStepConf().getString("variableType");
        Map variables = this.inputUtil.getHandleObject(content, "dataHandle");
        int action = 0;
        if (StrUtil.isNotBlank((CharSequence)taskId)) {
            action += 10;
        }
        if (StrUtil.isNotBlank((CharSequence)variableType) && "local".equals(variableType)) {
            ++action;
        }
        try {
            switch (action) {
                case 0: {
                    this.runtimeService.setVariables(processInstanceId, variables);
                    break;
                }
                case 1: {
                    this.runtimeService.setVariablesLocal(processInstanceId, variables);
                    break;
                }
                case 10: {
                    this.taskService.setVariables(taskId, variables);
                    break;
                }
                case 11: {
                    this.taskService.setVariablesLocal(taskId, variables);
                }
            }
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6e\u6d41\u7a0b\u53d8\u91cf\u5f02\u5e38 processId: {},taskId: {},variableType: {},variables: {}", new Object[]{processInstanceId, taskId, variableType, JSONUtil.toJsonPrettyStr((Object)variables)});
            log.error("\u8bbe\u7f6e\u6d41\u7a0b\u53d8\u91cf\u5f02\u5e38", (Throwable)e);
            throw new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
        }
        this.outputUtil.putData(content, (Object)"");
    }

    private String getOneVarValue(ProcessContent content, String varKey) {
        String varKeyValue = this.variableUtil.calVarInConf(content, varKey);
        String varValue = null;
        if (StringUtil.isNotBlank((String)varKeyValue)) {
            Object varValueObj = content.getValue(varKeyValue);
            varValue = varValueObj != null ? varValueObj.toString() : varKeyValue;
        }
        return varValue;
    }

    public String getName() {
        return "camundaSetVariableProcess";
    }
}

