/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.runtime;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import javax.annotation.Resource;
import org.camunda.bpm.engine.RuntimeService;
import org.springframework.stereotype.Service;

@Service
public class CamundaInstanceContrProcess
implements IProcess {
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private RuntimeService runtimeService;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"processInstanceId"});
        String id = this.variableUtil.calVarInConf(content, "processInstanceId");
        String contrType = this.variableUtil.calVarInConf(content, "contrType");
        if (StrUtil.equals((CharSequence)contrType, (CharSequence)"suspend")) {
            this.runtimeService.suspendProcessInstanceById(id);
        } else if (StrUtil.equals((CharSequence)contrType, (CharSequence)"activate")) {
            this.runtimeService.activateProcessInstanceById(id);
        } else if (StrUtil.equals((CharSequence)contrType, (CharSequence)"restart")) {
            this.runtimeService.restartProcessInstances(id);
        } else {
            throw new BizException(ResultCode.CONF_ERROR, "\u672a\u77e5\u7684\u7c7b\u578b");
        }
    }

    public String getName() {
        return "camundaInstanceContrProcess";
    }
}

