/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.repository;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.io.IoUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.common.util.tool.json.JSONUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.annotation.Resource;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.springframework.stereotype.Service;

@Service
public class CamundaGetDeploymentProcess
implements IProcess {
    @Resource
    private RepositoryService repositoryService;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private IVariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        ProcessDefinition processDefinition;
        String prcesssKey;
        String processDefinitionId;
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery();
        String id = this.variableUtil.calVarInConf(content, "deploymentId");
        if (StrUtil.isNotBlank((CharSequence)id)) {
            processDefinitionQuery.deploymentId(id);
        }
        if (StrUtil.isNotBlank((CharSequence)(processDefinitionId = this.variableUtil.calVarInConf(content, "processDefinitionId")))) {
            ((ProcessDefinitionQuery)processDefinitionQuery.processDefinitionId(processDefinitionId).orderByVersionTag().desc()).listPage(0, 1);
        }
        if (StrUtil.isNotBlank((CharSequence)(prcesssKey = this.variableUtil.calVarInConf(content, "prcesssKey")))) {
            processDefinitionQuery.processDefinitionKey(prcesssKey).latestVersion();
        }
        if ((processDefinition = (ProcessDefinition)processDefinitionQuery.singleResult()) == null) {
            return;
        }
        String jsonString = JSONUtil.toJsonStr((Object)processDefinition);
        JSONObject result = JSONObject.parseObject((String)jsonString);
        InputStream bpmn = this.repositoryService.getResourceAsStream(processDefinition.getDeploymentId(), processDefinition.getResourceName());
        String bpmnSrt = IoUtil.read((InputStream)bpmn, (Charset)Charset.defaultCharset());
        InputStream svg = this.repositoryService.getResourceAsStream(processDefinition.getDeploymentId(), processDefinition.getDiagramResourceName());
        String svgSrt = IoUtil.read((InputStream)svg, (Charset)Charset.defaultCharset());
        result.put("bpmn", (Object)bpmnSrt);
        result.put("pic", (Object)svgSrt);
        this.outputUtil.putData(content, (Object)result);
    }

    public String getName() {
        return "camundaGetDeploymentProcess";
    }
}

