/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.history;

import com.alibaba.fastjson.JSONObject;
import com.manatee.camunda.process.service.ManateeTaskService;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CamundaQueryNodeStatusProcess
implements IProcess {
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private VariableUtil variableUtil;
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    private ManateeTaskService manateeTaskService;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"processInstanceId"});
        String processInstanceId = this.variableUtil.calVarInConf(content, "processInstanceId");
        List<HistoricActivityInstance> finishedList = this.manateeTaskService.historyCompleteTaskOrderByDesc(processInstanceId);
        if (CollUtil.isEmpty(finishedList)) {
            return;
        }
        HistoricActivityInstance historicActivityInstance = finishedList.get(finishedList.size() - 1);
        HashSet<String> allNode = new HashSet<String>();
        HashSet<String> pendingNode = new HashSet<String>();
        HashSet<String> completedNode = new HashSet<String>();
        HashSet<String> activityNode = new HashSet<String>();
        HashSet<String> historicNode = new HashSet<String>();
        BpmnModelInstance bpmn = this.repositoryService.getBpmnModelInstance(historicActivityInstance.getProcessDefinitionId());
        FlowNode startNode = (FlowNode)bpmn.getModelElementById(this.manateeTaskService.getActivityId(historicActivityInstance));
        ArrayList<FlowNode> allFlowNode = new ArrayList<FlowNode>();
        this.manateeTaskService.selectOutAllNode(startNode, allFlowNode);
        if (allNode != null) {
            for (FlowNode flowNode : allFlowNode) {
                allNode.add(flowNode.getId());
            }
        }
        List<HistoricActivityInstance> activityTaskList = this.manateeTaskService.activityTask(processInstanceId);
        ArrayList<FlowNode> pendingFlowNode = new ArrayList<FlowNode>();
        ArrayList<FlowNode> completedFlowNode = new ArrayList<FlowNode>();
        for (HistoricActivityInstance activityInstance : activityTaskList) {
            FlowNode activityFlowNode = (FlowNode)bpmn.getModelElementById(this.manateeTaskService.getActivityId(activityInstance));
            this.manateeTaskService.selectOutAllNode(activityFlowNode, pendingFlowNode);
            this.manateeTaskService.selectInAllNode(activityFlowNode, completedFlowNode, true);
            if (Objects.equals(activityInstance.getActivityType(), "parallelGateway") || Objects.equals(activityInstance.getActivityType(), "exclusiveGateway")) continue;
            activityNode.add(this.manateeTaskService.getActivityId(activityInstance));
        }
        for (FlowNode flowNode : pendingFlowNode) {
            pendingNode.add(flowNode.getId());
        }
        for (HistoricActivityInstance activityInstance : finishedList) {
            historicNode.add(this.manateeTaskService.getActivityId(activityInstance));
        }
        for (FlowNode flowNode : completedFlowNode) {
            if (!historicNode.contains(flowNode.getId())) continue;
            completedNode.add(flowNode.getId());
        }
        allNode.removeAll(pendingNode);
        allNode.removeAll(completedNode);
        allNode.removeAll(activityNode);
        JSONObject result = new JSONObject();
        result.put("pendingNode", pendingNode);
        result.put("completedNode", completedNode);
        result.put("noExecuteNode", allNode);
        result.put("activityNode", activityNode);
        this.outputUtil.setDefaultReturnKey(content, "outputData");
        this.outputUtil.putData(content, (Object)result);
    }

    public String getName() {
        return "camundaQueryNodeStatusProcess";
    }
}

