/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.listener;

import com.alibaba.fastjson.JSONObject;
import com.manatee.lowcode.domain.ModularityRequest;
import com.manatee.lowcode.web.manager.ModularityManager;
import com.manatee.manager.SpringContextManager;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CamundaTaskListener
implements ExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(CamundaTaskListener.class);
    private RepositoryService repositoryService = (RepositoryService)SpringContextManager.getBean(RepositoryService.class);
    private ModularityManager modularityManager = (ModularityManager)SpringContextManager.getBean(ModularityManager.class);

    public void notify(DelegateExecution execution) throws Exception {
        String currentActivityId = execution.getCurrentActivityId();
        String processDefinitionId = execution.getProcessDefinitionId();
        BpmnModelInstance bpmnModelInstance = this.repositoryService.getBpmnModelInstance(processDefinitionId);
        String bpmnXml = Bpmn.convertToString((BpmnModelInstance)bpmnModelInstance);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        SAXParserHandler handler = new SAXParserHandler(currentActivityId);
        try {
            parser.parse(new InputSource(new StringReader(bpmnXml)), (DefaultHandler)handler);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<JSONObject> moduleJsonList = handler.getModuleJsonList();
        if (moduleJsonList != null && moduleJsonList.size() > 0) {
            for (JSONObject moduleJson : moduleJsonList) {
                Long projectId = moduleJson.getLong("projectId");
                String code = moduleJson.getString("moduleCode");
                ModularityRequest modularityRequest = new ModularityRequest();
                modularityRequest.setProjectId(projectId);
                modularityRequest.setCode(code);
                JSONObject params = new JSONObject();
                params.put("id", (Object)execution.getId());
                params.put("currentActivityId", (Object)currentActivityId);
                params.put("processDefinitionId", (Object)processDefinitionId);
                params.put("processInstanceId", (Object)execution.getProcessInstanceId());
                modularityRequest.setParams((Map)params);
                String traceId = MDC.get((String)"traceId");
                modularityRequest.setTraceId(traceId);
                log.info("\u76d1\u542c\u5668\u5f00\u59cb\uff0cprojectId\uff1a{}\uff0ccode\uff1a{} params\uff1a{}, traceId:{}", new Object[]{projectId, code, params, traceId});
                JSONObject resultJson = this.modularityManager.executionModuleResultJson(modularityRequest);
                log.info("\u76d1\u542c\u5668\u7ed3\u675f\uff1a{}, traceId:{}", (Object)resultJson.toJSONString(), (Object)traceId);
            }
        }
    }

    public static class SAXParserHandler
    extends DefaultHandler {
        private String nodeName;
        private List<JSONObject> moduleJsonList = new ArrayList<JSONObject>();
        private Boolean isReturn = false;

        public SAXParserHandler(String nodeName) {
            this.nodeName = nodeName;
        }

        public List<JSONObject> getModuleJsonList() {
            return this.moduleJsonList;
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            log.info("SAX\u89e3\u6790\u5f00\u59cb");
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
            log.info("SAX\u89e3\u6790\u7ed3\u675f");
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (StringUtils.equals((CharSequence)qName, (CharSequence)"bpmn:userTask")) {
                int num = attributes.getLength();
                for (int i = 0; i < num; ++i) {
                    if (!StringUtils.equals((CharSequence)attributes.getQName(i), (CharSequence)"id") || !StringUtils.equals((CharSequence)attributes.getValue(i), (CharSequence)this.nodeName)) continue;
                    this.isReturn = true;
                }
            } else if (StringUtils.equals((CharSequence)qName, (CharSequence)"camunda:executionListener")) {
                int num = attributes.getLength();
                JSONObject moduleJson = new JSONObject();
                for (int i = 0; i < num; ++i) {
                    if (StringUtils.equals((CharSequence)attributes.getQName(i), (CharSequence)"MANATEE_PROJECT_ID")) {
                        moduleJson.put("projectId", (Object)attributes.getValue(i));
                    }
                    if (!StringUtils.equals((CharSequence)attributes.getQName(i), (CharSequence)"MANATEE_MODULE_CODE")) continue;
                    moduleJson.put("moduleCode", (Object)attributes.getValue(i));
                }
                if (moduleJson.size() > 0) {
                    this.moduleJsonList.add(moduleJson);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if (StringUtils.equals((CharSequence)qName, (CharSequence)"bpmn:userTask") && this.isReturn.booleanValue()) {
                throw new SAXException("\u627e\u5230\u6307\u5b9a\u4fe1\u606f");
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
        }
    }
}

