/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.event;

import com.alibaba.fastjson.JSONObject;
import com.manatee.config.ManateeConfig;
import com.manatee.lowcode.domain.ModularityRequest;
import com.manatee.lowcode.domain.ModularityResult;
import com.manatee.lowcode.web.manager.ModularityManager;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.spring.boot.starter.event.ExecutionEvent;
import org.camunda.bpm.spring.boot.starter.event.TaskEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class ManateeCamundaEvent {
    private static final Logger log = LoggerFactory.getLogger(ManateeCamundaEvent.class);
    @Resource
    private ModularityManager modularityManager;
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private ManateeConfig manateeConfig;

    @TransactionalEventListener
    public void onTaskEvent(TaskEvent event) {
        log.info("task id: {}, process instance id: {}, event: {}", new Object[]{event.getId(), event.getProcessInstanceId(), event.getEventName()});
        String taskModuleCode = this.manateeConfig.getEventing().getTask().getModuleCode();
        Long taskProjectId = this.manateeConfig.getEventing().getTask().getProjectId();
        if (StringUtils.isNotBlank((CharSequence)taskModuleCode) && taskProjectId != null) {
            try {
                ModularityRequest modularityRequest = new ModularityRequest();
                modularityRequest.setProjectId(taskProjectId);
                modularityRequest.setCode(taskModuleCode);
                JSONObject params = new JSONObject();
                params.put("taskId", (Object)event.getId());
                params.put("processDefinitionId", (Object)event.getCaseDefinitionId());
                params.put("processInstanceId", (Object)event.getProcessInstanceId());
                params.put("event", (Object)event.getEventName());
                params.put("taskName", (Object)event.getName());
                params.put("assignee", (Object)event.getAssignee());
                params.put("taskDefinitionKey", (Object)event.getTaskDefinitionKey());
                modularityRequest.setParams((Map)params);
                String traceId = MDC.get((String)"traceId");
                modularityRequest.setTraceId(traceId);
                log.info("task \u76d1\u542c\u5668\u5f00\u59cb\uff0cprojectId\uff1a{}\uff0ccode\uff1a{} params\uff1a{}, traceId:{}", new Object[]{taskProjectId, taskModuleCode, params, traceId});
                ModularityResult modularityResult = this.modularityManager.executionModule(modularityRequest);
                log.info("task \u76d1\u542c\u5668\u7ed3\u675f\uff1a{}, traceId:{}", (Object)JSONObject.toJSONString((Object)modularityResult), (Object)traceId);
            }
            catch (Throwable e) {
                log.error("task \u76d1\u542c\u5668\u5f02\u5e38\uff1a", e);
            }
        }
    }

    @TransactionalEventListener
    public void onExecutionEvent(ExecutionEvent event) {
        if (StringUtils.equals((CharSequence)event.getEventName(), (CharSequence)"start") && event.getActivityInstanceId() == null || StringUtils.equals((CharSequence)event.getEventName(), (CharSequence)"end") && (event.getCurrentActivityId() == null || !event.getActivityInstanceId().startsWith(event.getCurrentActivityId()))) {
            log.info("execution id: {}, process instance id: {}, event: {}", new Object[]{event.getId(), event.getProcessInstanceId(), event.getEventName()});
            String executionModuleCode = this.manateeConfig.getEventing().getExecution().getModuleCode();
            Long executionProjectId = this.manateeConfig.getEventing().getExecution().getProjectId();
            if (StringUtils.isNotBlank((CharSequence)executionModuleCode) && executionProjectId != null) {
                try {
                    ModularityRequest modularityRequest = new ModularityRequest();
                    modularityRequest.setProjectId(executionProjectId);
                    modularityRequest.setCode(executionModuleCode);
                    JSONObject params = new JSONObject();
                    params.put("id", (Object)event.getId());
                    params.put("currentActivityId", (Object)event.getCurrentActivityId());
                    params.put("processInstanceId", (Object)event.getProcessInstanceId());
                    params.put("event", (Object)event.getEventName());
                    modularityRequest.setParams((Map)params);
                    String traceId = MDC.get((String)"traceId");
                    modularityRequest.setTraceId(traceId);
                    log.info("execution \u76d1\u542c\u5668\u5f00\u59cb\uff0cprojectId\uff1a{}\uff0ccode\uff1a{} params\uff1a{}, traceId:{}", new Object[]{executionProjectId, executionModuleCode, params, traceId});
                    ModularityResult modularityResult = this.modularityManager.executionModule(modularityRequest);
                    log.info("execution \u76d1\u542c\u5668\u7ed3\u675f\uff1a{}, traceId:{}", (Object)JSONObject.toJSONString((Object)modularityResult), (Object)traceId);
                }
                catch (Throwable e) {
                    log.error("task \u76d1\u542c\u5668\u5f02\u5e38\uff1a", e);
                }
            }
        }
    }

    @EventListener
    public void onDelegateTask(DelegateTask delegateTask) {
        Object agent;
        String assignee = delegateTask.getAssignee();
        log.info("execution id: {}, process instance id: {}, event: {}", new Object[]{delegateTask.getId(), delegateTask.getProcessInstanceId(), delegateTask.getEventName()});
        if (!StringUtils.isBlank((CharSequence)assignee) && StringUtils.isNotBlank((CharSequence)delegateTask.getExecutionId()) && (agent = this.runtimeService.getVariable(delegateTask.getExecutionId(), "MANATEE_FORWARD_TASK_USER:" + assignee + ":" + delegateTask.getTaskDefinitionKey())) != null) {
            delegateTask.setAssignee(agent.toString());
            log.info("forward assignee: {}, agent: {}, taskDefKey: {}", new Object[]{assignee, agent.toString(), delegateTask.getTaskDefinitionKey()});
        }
    }
}

