/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.fun.time;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TimeIntervalFun
extends AbstractFunction {
    protected static Logger LOGGER = LoggerFactory.getLogger(TimeIntervalFun.class);

    public String getName() {
        return "timeInterval";
    }

    public Object doFunction(FunctionContent content) throws BizException {
        this.checkParamSize(content);
        content.setInterruptLevel(Integer.valueOf(3));
        if (!this.checkParamExist(content).booleanValue()) {
            LOGGER.debug(content.getParameters().toString());
            throw new BizException(ResultCode.CONF_ERROR, "\u8bf7\u68c0\u67e5\u65f6\u95f4\u5bf9\u8c61\u503c\u662f\u5426\u5b58\u5728");
        }
        Object obj1 = content.getParameter(0);
        Object obj2 = content.getParameter(1);
        Object obj3 = content.getParameter(2);
        Object obj4 = content.getParameter(3);
        if (obj4 == null) {
            obj4 = "millisecond";
        }
        long time = this.checkParamsAndReturnDiffValue(obj1, obj2, obj3);
        return this.getTimeInterval(time, obj4);
    }

    private long checkParamsAndReturnDiffValue(Object obj1, Object obj2, Object obj3) throws BizException {
        long date2;
        long date1;
        Calendar calendar = Calendar.getInstance();
        calendar.getTime();
        LOGGER.debug("TimeIntervalFun, obj1:\u3010{}\u3011; obj2: \u3010{}\u3011; obj3: \u3010{}\u3011", new Object[]{obj1, obj2, obj3});
        if ("ms".equals(obj3)) {
            if (obj1 instanceof Double) {
                obj1 = ((Double)obj1).longValue();
            }
            if (obj2 instanceof Double) {
                obj2 = ((Double)obj2).longValue();
            }
            int obj1Length = obj1.toString().length();
            int obj2Length = obj2.toString().length();
            if (obj1Length > 13 || obj2Length > 13) {
                LOGGER.error("\u65f6\u95f4\u6233\u683c\u5f0f\u4e0d\u5339\u914d, obj1: \u3010{}\u3011; obj2: \u3010{}\u3011", obj1, obj2);
                throw new BizException(ResultCode.CONF_ERROR, "\u8bf7\u4f20\u9012\u6beb\u79d2\u5355\u4f4d\u53c2\u6570");
            }
            date1 = Long.parseLong(obj1.toString());
            date2 = Long.parseLong(obj2.toString());
        } else if ("s".equals(obj3)) {
            if (obj1 instanceof Double) {
                obj1 = ((Double)obj1).longValue();
            }
            if (obj2 instanceof Double) {
                obj2 = ((Double)obj2).longValue();
            }
            int obj1Length = obj1.toString().length();
            int obj2Length = obj2.toString().length();
            if (obj1Length > 10 || obj2Length > 10) {
                LOGGER.error("\u65f6\u95f4\u6233\u683c\u5f0f\u4e0d\u5339\u914d, obj1: \u3010{}\u3011; obj2: \u3010{}\u3011", obj1, obj2);
                throw new BizException(ResultCode.CONF_ERROR, "\u8bf7\u4f20\u9012\u79d2\u5355\u4f4d\u53c2\u6570");
            }
            date1 = Long.parseLong(obj1 + "000");
            date2 = Long.parseLong(obj2 + "000");
        } else {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(obj3.toString());
                date1 = obj1 instanceof Date ? sdf.parse(sdf.format(obj1)).getTime() : sdf.parse(obj1.toString()).getTime();
                date2 = obj2 instanceof Date ? sdf.parse(sdf.format(obj2)).getTime() : sdf.parse(obj2.toString()).getTime();
            }
            catch (StringIndexOutOfBoundsException | ParseException e) {
                LOGGER.error("time format error , date1: \u3010{}\u3011; date2: \u3010{}\u3011", new Object[]{obj1, obj2, e});
                throw new BizException(ResultCode.CONF_ERROR, (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("SimpleDateFormat initialization error , SimpleDateFormatStr: \u3010{}\u3011", obj3, (Object)e);
                throw new BizException(ResultCode.CONF_ERROR, (Throwable)e);
            }
        }
        return date2 - date1;
    }

    private Long getTimeInterval(long time, Object obj4) throws BizException {
        String type = obj4.toString().toLowerCase();
        LOGGER.debug("TimeIntervalFun.getTimeInterval() , time: \u3010{}\u3011; type: \u3010{}\u3011", (Object)time, (Object)type);
        long result = time < 0L ? this.getMinTimeSubtractMaxTime(time, type).longValue() : this.getMaxTimeSubtractMinTime(time, type).longValue();
        return result;
    }

    private Long getMaxTimeSubtractMinTime(Long time, String type) throws BizException {
        long result;
        switch (type) {
            case "year": 
            case "\u5e74": {
                result = (long)Math.floor((double)time.longValue() / 1000.0 / 3.1536E7);
                break;
            }
            case "month": 
            case "\u6708": {
                result = (long)Math.floor((double)time.longValue() / 1000.0 / 2592000.0);
                break;
            }
            case "week": 
            case "\u5468": {
                result = (long)Math.floor((double)time.longValue() / 6.048E8);
                break;
            }
            case "day": 
            case "\u65e5": 
            case "\u5929": {
                result = (long)Math.floor((double)time.longValue() / 8.64E7);
                break;
            }
            case "hour": 
            case "\u65f6": {
                result = (long)Math.floor((double)time.longValue() / 3600000.0);
                break;
            }
            case "minute": 
            case "\u5206": {
                result = (long)Math.floor((double)time.longValue() / 60000.0);
                break;
            }
            case "second": 
            case "s": 
            case "\u79d2": {
                result = (long)Math.floor((double)time.longValue() / 1000.0);
                break;
            }
            case "millisecond": 
            case "ms": 
            case "\u6beb\u79d2": {
                result = time;
                break;
            }
            default: {
                LOGGER.error("TimeIntervalFun.getMaxTimeSubtractMinTime() ,\u8bf7\u68c0\u67e5\u65f6\u95f4\u95f4\u9694\u7c7b\u578btype:\u3010{}\u3011 (year/month/week/day/\u2026\u2026)", (Object)type);
                throw new BizException(ResultCode.CONF_ERROR, "\u8bf7\u68c0\u67e5\u65f6\u95f4\u95f4\u9694\u7c7b\u578b : year/month/week/day/\u2026\u2026");
            }
        }
        return result;
    }

    private Long getMinTimeSubtractMaxTime(Long time, String type) throws BizException {
        long result;
        switch (type) {
            case "year": 
            case "\u5e74": {
                result = (long)Math.floor((double)time.longValue() / 1000.0 / 3.1536E7) + (long)(time / 1000L % 31536000L != 0L ? 1 : 0);
                break;
            }
            case "month": 
            case "\u6708": {
                result = (long)Math.floor((double)time.longValue() / 1000.0 / 2592000.0) + (long)(time / 1000L % 2592000L != 0L ? 1 : 0);
                break;
            }
            case "week": 
            case "\u5468": {
                result = (long)Math.floor((double)time.longValue() / 6.048E8) + (long)(time / 1000L % 604800L != 0L ? 1 : 0);
                break;
            }
            case "day": 
            case "\u65e5": 
            case "\u5929": {
                result = (long)Math.floor((double)time.longValue() / 8.64E7) + (long)(time / 1000L % 86400L != 0L ? 1 : 0);
                break;
            }
            case "hour": 
            case "\u65f6": {
                result = (long)Math.floor((double)time.longValue() / 3600000.0) + (long)(time / 1000L % 3600L != 0L ? 1 : 0);
                break;
            }
            case "minute": 
            case "\u5206": {
                result = (long)Math.floor((double)time.longValue() / 60000.0) + (long)(time / 1000L % 60L != 0L ? 1 : 0);
                break;
            }
            case "second": 
            case "s": 
            case "\u79d2": {
                result = (long)Math.floor((double)time.longValue() / 1000.0) + (long)(time % 1000L != 0L ? 1 : 0);
                break;
            }
            case "millisecond": 
            case "ms": 
            case "\u6beb\u79d2": {
                result = time;
                break;
            }
            default: {
                LOGGER.error("TimeIntervalFun.getMaxTimeSubtractMinTime() ,\u8bf7\u68c0\u67e5\u65f6\u95f4\u95f4\u9694\u7c7b\u578btype:\u3010{}\u3011 (year/month/week/day/\u2026\u2026)", (Object)type);
                throw new BizException(ResultCode.CONF_ERROR, "\u8bf7\u68c0\u67e5\u65f6\u95f4\u95f4\u9694\u7c7b\u578b : year/month/week/day/\u2026\u2026");
            }
        }
        return result;
    }

    public Integer getMinParamSize() {
        return 3;
    }

    public Integer getMaxParamSize() {
        return 4;
    }
}

