/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.DataUtil;
import com.manatee.lowcode.util.InterruptUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.domain.ProcessContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OutputUtil
extends DataUtil
implements IOutputUtil {
    @Resource
    private VariableUtil variableUtil;
    @Resource
    private InterruptUtil interruptUtil;

    public void handleAndPutData(ProcessContent content, Object value) throws BizException {
        Object putValue = this.handleData(content, value);
        this.excludeSomeKeys(content, putValue);
        this.putData(content, putValue);
    }

    public void handleAndPutDataV2(ProcessContent content, Object value, String syntaxType) throws BizException {
        Object putValue = this.handleDataV2(content, value, syntaxType);
        this.excludeSomeKeys(content, putValue);
        this.putData(content, putValue);
    }

    private void excludeSomeKeys(ProcessContent content, Object value) {
        block5: {
            String excludeKeys;
            block4: {
                String[] excludeKeyArr;
                excludeKeys = this.variableUtil.calVarInConf(content, "excludeKeys");
                if (value == null || StringUtil.isBlank((String)excludeKeys)) {
                    return;
                }
                if (!(value instanceof Map)) break block4;
                Map re = (Map)value;
                for (String key : excludeKeyArr = excludeKeys.split(",")) {
                    re.remove(key.trim());
                }
                break block5;
            }
            if (!(value instanceof List)) break block5;
            List listRe = (List)value;
            for (Object one : listRe) {
                String[] excludeKeyArr;
                if (!(one instanceof Map)) continue;
                Map re = (Map)one;
                for (String key : excludeKeyArr = excludeKeys.split(",")) {
                    re.remove(key.trim());
                }
            }
        }
    }

    public void putData(ProcessContent content, Object putValue) {
        String key = this.getDefaultPutKey(content);
        String valueTo = OutputUtil.getDefaultValueTo(content);
        this.putData(content, key, putValue, valueTo);
    }

    public void putData(ProcessContent content, String key, Object putValue) {
        this.putData(content, key, putValue, "request");
    }

    public void putData(ProcessContent content, String key, Object putValue, String valueTo) {
        Map aMap;
        if (putValue instanceof Map && (aMap = (Map)putValue).size() == 1 && aMap.get("_thisResult") != null) {
            putValue = aMap.get("_thisResult");
        }
        if (putValue instanceof Map && "outputUnfold".equals(key)) {
            this.unfoldPutData(content, (Map)putValue);
        } else {
            this.putRequestOrResponse(content, putValue);
            if ("request".equals(valueTo)) {
                OutputUtil.putObjTempKey(content, key, putValue);
                content.putRequestSubValue(key, putValue);
            } else {
                OutputUtil.putObjTempKey(content, key, putValue);
                content.putRequestSubValue(key, putValue);
                content.putResponseSubValue(key, putValue);
            }
            this.interruptUtil.removeDependOnInterrupt(content, key);
        }
    }

    public void putDatAndRturun(ProcessContent content, String key, Object putValue) {
        this.putData(content, key, putValue, "response");
    }

    public void setDefaultReturnKey(ProcessContent content, String defaultReturnKey) {
        String returnKey = this.variableUtil.calVarInConf(content, "returnKey");
        if (StringUtil.isBlank((String)returnKey)) {
            content.getStepConf().put("returnKey", (Object)defaultReturnKey);
        }
    }

    private void putRequestOrResponse(ProcessContent content, Object putValue) {
        if (putValue instanceof JSONObject) {
            JSONObject value = (JSONObject)putValue;
            JSONObject request = value.getJSONObject("request");
            JSONObject response = value.getJSONObject("response");
            if (request != null) {
                for (String aKey : request.keySet()) {
                    content.putRequestSubValue(aKey, request.get((Object)aKey));
                }
                value.remove((Object)"request");
            }
            if (response != null) {
                for (String aKey : response.keySet()) {
                    content.putResponse(aKey, response.get((Object)aKey));
                }
                value.remove((Object)"response");
            }
        }
    }

    public static String getDefaultValueTo(ProcessContent content) {
        String valueTo = (String)content.getStepConf("valueTo");
        if (StringUtil.isBlank((String)valueTo)) {
            valueTo = "response";
        }
        return valueTo;
    }

    public void unfoldPutData(ProcessContent content, Map value) {
        JSONObject conf = content.getStepConf();
        String valueTo = conf.getString("valueTo");
        if ("request".equals(valueTo)) {
            content.putRequest(value);
        } else {
            content.putRequest(value);
            content.putResponse(value);
        }
    }

    private List<Map<String, Object>> value2MapList(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof JSONArray) {
            return this.array2MapList((JSONArray)value);
        }
        return (List)value;
    }

    private List<Map<String, Object>> array2MapList(JSONArray value) {
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>();
        JSONArray array = value;
        for (int i = 0; i < array.size(); ++i) {
            JSONObject obj = array.getJSONObject(i);
            paramList.add((Map<String, Object>)obj);
        }
        return paramList;
    }

    public String getDefaultPutKey(ProcessContent content) {
        String key = this.variableUtil.calVarInConf(content, "returnKey");
        if (StringUtil.isBlank((String)key)) {
            key = "outputData";
        }
        return key;
    }

    private static String getObjTempKey(ProcessContent content) {
        String key = (String)content.getTempContent("listTempContext");
        if (StringUtil.isBlank((String)key)) {
            key = (String)content.getTempContent("objectTempContext");
        }
        return key;
    }

    private static void putObjTempKey(ProcessContent content, String key, Object value) {
        if (value instanceof List) {
            content.putTempContent("listTempContext", (Object)key);
        }
        if (value instanceof JSONObject) {
            content.putTempContent("objectTempContext", (Object)key);
        }
    }
}

