/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.StrSplit;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.util.ObjectUtil;
import com.manatee.lowcode.exp.manager.ManateeCodeManager;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.process.js.JsService;
import com.manatee.lowcode.util.DataUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.domain.ProcessContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class InputUtil
extends DataUtil
implements IInputUtil {
    @Resource
    private VariableUtil variableUtil;
    @Resource
    public ManateeCodeManager manateeCodeManager;
    @Resource
    public JsService jsService;

    public Map<String, Object> getHandleMapConf(ProcessContent content, Object mappingConf) throws BizException {
        return this.doMapForMapConf(content, mappingConf);
    }

    public List<Map> getHandleListObject(ProcessContent content, String key, String dataKey) throws BizException {
        Object dataConfObj = content.getStepConf(key);
        return this.getHandleListObject(content, dataKey, dataConfObj);
    }

    public List<Map> getHandleListObjectV2(ProcessContent content, String key, String dataKey, String syntaxType) throws BizException {
        Object dataConfObj = content.getStepConf(key);
        return this.getHandleListObjectV2(content, dataKey, dataConfObj, syntaxType);
    }

    public List<Map> getHandleListObject(ProcessContent content, String dataKey, Object dataConfObj) throws BizException {
        if (dataConfObj == null) {
            return null;
        }
        if (dataConfObj instanceof List) {
            List dataConfList = (List)dataConfObj;
            if (CollUtil.isEmpty((Collection)dataConfList)) {
                return null;
            }
            JSONArray dataConfNewObj = JSONArray.parseArray((String)JSONArray.toJSONString((Object)dataConfList));
            List dataConfListNew = (List)dataConfNewObj;
            for (Map map : dataConfListNew) {
                Iterator<Map.Entry<String, Object>> iterator;
                Boolean isLeft = (Boolean)map.get("isLeft");
                Boolean isRight = (Boolean)map.get("isRight");
                if (isLeft == null) {
                    isLeft = false;
                }
                if (isRight == null) {
                    isRight = false;
                }
                if (isLeft.booleanValue() || isRight.booleanValue()) continue;
                Object getkey = map.get(dataKey);
                String conf = dataKey + "=" + getkey;
                Map<String, Object> result = this.manateeCodeManager.analysis2ManateeExp(content, conf);
                if (CollUtil.isEmpty(result) || !(iterator = result.entrySet().iterator()).hasNext()) continue;
                Map.Entry<String, Object> stringObjectEntry = iterator.next();
                map.put(dataKey, stringObjectEntry.getValue());
            }
            return dataConfListNew;
        }
        return null;
    }

    public List<Map> getHandleListObjectV2(ProcessContent content, String dataKey, Object dataConfObj, String syntaxType) throws BizException {
        if (dataConfObj == null) {
            return null;
        }
        if (dataConfObj instanceof List) {
            List dataConfList = (List)dataConfObj;
            if (CollUtil.isEmpty((Collection)dataConfList)) {
                return null;
            }
            JSONArray dataConfNewObj = JSONArray.parseArray((String)JSONArray.toJSONString((Object)dataConfList));
            List dataConfListNew = (List)dataConfNewObj;
            for (Map map : dataConfListNew) {
                Iterator<Map.Entry<String, Object>> iterator;
                Object getkey;
                Boolean isLeft = (Boolean)map.get("isLeft");
                Boolean isRight = (Boolean)map.get("isRight");
                if (isLeft == null) {
                    isLeft = false;
                }
                if (isRight == null) {
                    isRight = false;
                }
                if (isLeft.booleanValue() || isRight.booleanValue() || StringUtils.isBlank((CharSequence)((getkey = map.get(dataKey)) + ""))) continue;
                String conf = dataKey + "=" + getkey;
                Map<String, Object> result = StringUtils.isBlank((CharSequence)syntaxType) || StringUtils.equals((CharSequence)syntaxType, (CharSequence)"manateeSyntax") ? this.manateeCodeManager.analysis2ManateeExp(content, conf) : this.jsService.getHandleMapConf(content, conf);
                if (CollUtil.isEmpty(result) || !(iterator = result.entrySet().iterator()).hasNext()) continue;
                Map.Entry<String, Object> stringObjectEntry = iterator.next();
                map.put(dataKey, stringObjectEntry.getValue());
            }
            return dataConfListNew;
        }
        return null;
    }

    public Object getHandleListObject(ProcessContent content, String key, String dataKey, String bathParamsKey) throws BizException {
        Object dataConfObj = content.getStepConf(key);
        return this.getHandleListObject(content, dataConfObj, dataKey, bathParamsKey);
    }

    public Object getHandleListObject(ProcessContent content, Object dataConfObj, String dataKey, String bathParamsKey) throws BizException {
        if (!(dataConfObj instanceof List)) {
            return null;
        }
        List dataConfList = (List)dataConfObj;
        if (CollUtil.isEmpty((Collection)dataConfList)) {
            return null;
        }
        ArrayList<List<Map>> result = new ArrayList<List<Map>>();
        if (bathParamsKey == null) {
            return result;
        }
        List data = (List)this.getData(content, (String)this.getData(content, bathParamsKey));
        for (Object datum : data) {
            Map mapValue = this.value2Map(datum);
            content.addTempData(mapValue);
            Object clone = ObjectUtil.cloneByStream((Object)dataConfObj);
            List<Map> handleListObject = this.getHandleListObject(content, dataKey, clone);
            result.add(handleListObject);
            content.removeTempData();
        }
        return result;
    }

    public Object getHandleListObjectV2(ProcessContent content, Object dataConfObj, String dataKey, String bathParamsKey, String syntaxType) throws BizException {
        if (!(dataConfObj instanceof List)) {
            return null;
        }
        List dataConfList = (List)dataConfObj;
        if (CollUtil.isEmpty((Collection)dataConfList)) {
            return null;
        }
        ArrayList<List<Map>> result = new ArrayList<List<Map>>();
        if (bathParamsKey == null) {
            return result;
        }
        List data = (List)this.getData(content, (String)this.getData(content, bathParamsKey));
        for (Object datum : data) {
            Map mapValue = this.value2Map(datum);
            content.addTempData(mapValue);
            Object clone = ObjectUtil.cloneByStream((Object)dataConfObj);
            List<Map> handleListObject = this.getHandleListObjectV2(content, dataKey, clone, syntaxType);
            result.add(handleListObject);
            content.removeTempData();
        }
        return result;
    }

    public Object getData(ProcessContent content) {
        return this.getData(content, null);
    }

    public Map getHandleObject(ProcessContent content) throws BizException {
        return this.getHandleObject(content, "params");
    }

    public Object[] getHandleObjects(ProcessContent content) throws BizException {
        Map param = this.getHandleObject(content);
        Object[] params = new Object[param.size()];
        int i = 0;
        for (String key : param.keySet()) {
            Object aValue = param.get(key);
            params[i] = aValue;
            ++i;
        }
        return params;
    }

    public Map getHandleObject(ProcessContent content, String key) throws BizException {
        Object data;
        Map<String, Object> param = this.getMapping(content, key, null);
        if ((param = this.paramFormatAndCheck(content, param)) != null) {
            return param;
        }
        Map<String, Object> dataMap = new LinkedHashMap();
        if (StringUtil.isNotBlank((String)key)) {
            key = key + "Key";
        }
        if ((data = this.getData(content, key)) == null) {
            return dataMap;
        }
        if (data instanceof Map) {
            dataMap = (Map)data;
        } else {
            String varKey = this.getVarKey(content, key);
            dataMap.put(varKey, data);
        }
        return dataMap;
    }

    public Map getHandleObjectV2(ProcessContent content, String key, String syntaxType) throws BizException {
        Object data;
        Map<String, Object> param = this.getMappingV2(content, key, null, syntaxType);
        if ((param = this.paramFormatAndCheck(content, param)) != null) {
            return param;
        }
        Map<String, Object> dataMap = new LinkedHashMap();
        if (StringUtil.isNotBlank((String)key)) {
            key = key + "Key";
        }
        if ((data = this.getData(content, key)) == null) {
            return dataMap;
        }
        if (data instanceof Map) {
            dataMap = (Map)data;
        } else {
            String varKey = this.getVarKey(content, key);
            dataMap.put(varKey, data);
        }
        return dataMap;
    }

    public Object getHandleData(ProcessContent content, String key) throws BizException {
        Object data = this.getData(content, null);
        return this.handleData(content, key, data);
    }

    public Object getHandleDataV2(ProcessContent content, String key, String syntaxType) throws BizException {
        Object data = this.getData(content, null);
        return this.handleDataV2(content, key, data, syntaxType);
    }

    public Map<String, Object> getMappingData(ProcessContent content) throws BizException {
        Object data = this.getData(content);
        Map<String, Object> map = this.getMapping(content, data);
        if (map != null) {
            return map;
        }
        Map dataMap = null;
        if (data != null && data instanceof Map) {
            dataMap = (Map)data;
            return dataMap;
        }
        return null;
    }

    public Object getData(ProcessContent content, String key) {
        if (StringUtil.isBlank((String)key)) {
            key = this.getVarKey(content, "paramsKey");
        }
        if (this.singleKey(key)) {
            return content.getValue(key);
        }
        HashedMap value = new HashedMap();
        String[] keys = key.split(StrSplit.D);
        for (int i = 0; i < keys.length; ++i) {
            String aKey = keys[i].trim();
            Object aValue = content.getValue(aKey);
            if (aValue == null) continue;
            if (aValue instanceof Map) {
                value.putAll((Map)aValue);
                continue;
            }
            value.put(aKey, aValue);
        }
        return value;
    }

    private boolean singleKey(String key) {
        if (StringUtil.isBlank((String)key)) {
            return true;
        }
        return key.indexOf(StrSplit.D) == -1;
    }

    private static Object getDefaultData(ProcessContent content, JSONObject conf, String key) {
        if (StringUtil.isBlank((String)key)) {
            return null;
        }
        String valueFrom = conf.getString("valueFrom");
        if ("request".equals(valueFrom)) {
            return content.getRequestSubValue(key);
        }
        if ("response".equals(valueFrom)) {
            return content.getResponseSubValue(key);
        }
        Object value = content.getRequestSubValue(key);
        if (value == null) {
            value = content.getResponseSubValue(key);
        }
        return value;
    }

    public static String getDefaultValueFrom(ProcessContent content) {
        JSONObject conf = content.getStepConf();
        String valueFrom = conf.getString("valueFrom");
        if (StringUtil.isBlank((String)valueFrom)) {
            valueFrom = "request";
        }
        return valueFrom;
    }

    public List<Map<String, Object>> getList(ProcessContent content) {
        return this.getList(content, null);
    }

    public List<Map<String, Object>> getList(ProcessContent content, String key) {
        JSONObject conf = content.getStepConf();
        if (StringUtil.isBlank((String)key)) {
            key = this.getVarKey(content, "paramsKey");
        }
        if (StringUtil.isBlank((String)key)) {
            String listTempKey = InputUtil.getObjTempKey(content);
            if (StringUtil.isNotBlank((String)listTempKey)) {
                Object value = InputUtil.getDefaultData(content, conf, listTempKey);
                return this.value2MapList(value);
            }
            key = this.getVarKey(content, "paramsKey");
            if (StringUtil.isBlank((String)key)) {
                key = "listData";
            }
        }
        Object value = content.getValue(key);
        return this.value2MapList(value);
    }

    private List<Map<String, Object>> value2MapList(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof JSONArray) {
            return this.array2MapList((JSONArray)value);
        }
        return (List)value;
    }

    private List<Map<String, Object>> array2MapList(JSONArray value) {
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>();
        JSONArray array = value;
        for (int i = 0; i < array.size(); ++i) {
            Object obj = array.get(i);
            paramList.add((Map<String, Object>)obj);
        }
        return paramList;
    }

    public String getVarKey(ProcessContent content, String confKey) {
        return this.variableUtil.calVarInConf(content, confKey);
    }

    private static String getObjTempKey(ProcessContent content) {
        String key = (String)content.getTempContent("listTempContext");
        if (StringUtil.isBlank((String)key)) {
            key = (String)content.getTempContent("objectTempContext");
        }
        return key;
    }
}

