/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.fun.impl.cal;

import com.manatee.common.util.NumberUtils;
import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class DivideFun
extends AbstractFunction {
    public String getName() {
        return "divide";
    }

    public Object doFunction(FunctionContent content) {
        this.checkParamSize(content);
        if (!this.checkParamExist(content).booleanValue()) {
            return null;
        }
        List parameters = content.getParameters();
        String numStr1 = parameters.get(0).toString();
        String numStr2 = parameters.get(1).toString();
        if (!NumberUtils.isNumeric((String)numStr1) || !NumberUtils.isNumber((String)numStr2)) {
            throw new RuntimeException(String.format("\u51fd\u6570\uff1a%s\uff0c\u53c2\u6570\u5fc5\u987b\u662f\u6570\u5b57", this.getName()));
        }
        int scale = 2;
        if (parameters.size() > 2) {
            scale = Integer.valueOf(parameters.get(2).toString());
        }
        int round = 4;
        if (parameters.size() > 3) {
            round = Integer.valueOf(parameters.get(3) + "");
        }
        BigDecimal bitValue = new BigDecimal(numStr1).divide(new BigDecimal(numStr2), scale, round);
        return bitValue.doubleValue();
    }

    public Integer getMinParamSize() {
        return 2;
    }

    public Integer getMaxParamSize() {
        return 4;
    }
}

