/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.java.springCompiler;

import com.manatee.lowcode.java.springCompiler.ManateeClassLoader;
import com.manatee.lowcode.java.springCompiler.ManateeSpringBootInfoJavaClassObject;
import com.sun.tools.javac.file.JavacFileManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.springframework.boot.loader.jar.JarFile;

public class ManateeJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    final Map<String, byte[]> classBytes = new HashMap<String, byte[]>();
    final Map<String, List<JavaFileObject>> classObjectPackageMap = new HashMap<String, List<JavaFileObject>>();
    private JavacFileManager javaFileManager;
    public static final Map<String, List<JavaFileObject>> CLASS_OBJECT_PACKAGE_MAP = new HashMap<String, List<JavaFileObject>>();
    private static final Object lock = new Object();
    private static boolean isInit = false;

    public void init() {
        try {
            String jarBaseFile = ManateeClassLoader.getPath();
            JarFile jarFile = new JarFile(new File(jarBaseFile));
            ArrayList<JarEntry> entries = new ArrayList<JarEntry>();
            Enumeration e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry jarEntry = (JarEntry)e.nextElement();
                if (!jarEntry.getName().endsWith(".jar")) continue;
                entries.add(jarEntry);
            }
            JarFile libTempJarFile = null;
            List<Object> onePackgeJavaFiles = null;
            String packgeName = null;
            for (JarEntry entry : entries) {
                libTempJarFile = jarFile.getNestedJarFile(jarFile.getEntry(entry.getName()));
                if (libTempJarFile.getName().contains("tools.jar")) continue;
                Enumeration tempEntriesEnum = libTempJarFile.entries();
                while (tempEntriesEnum.hasMoreElements()) {
                    JarEntry jarEntry = (JarEntry)tempEntriesEnum.nextElement();
                    String classPath = jarEntry.getName().replace("/", ".");
                    if (!classPath.endsWith(".class") || jarEntry.getName().lastIndexOf("/") == -1) continue;
                    packgeName = classPath.substring(0, jarEntry.getName().lastIndexOf("/"));
                    onePackgeJavaFiles = CLASS_OBJECT_PACKAGE_MAP.containsKey(packgeName) ? CLASS_OBJECT_PACKAGE_MAP.get(packgeName) : new ArrayList();
                    onePackgeJavaFiles.add((Object)new ManateeSpringBootInfoJavaClassObject(jarEntry.getName().replace("/", ".").replace(".class", ""), new URL(libTempJarFile.getUrl(), jarEntry.getName()), this.javaFileManager));
                    CLASS_OBJECT_PACKAGE_MAP.put(packgeName, onePackgeJavaFiles);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        isInit = true;
    }

    ManateeJavaFileManager(JavaFileManager fileManager) {
        super(fileManager);
        this.javaFileManager = (JavacFileManager)fileManager;
    }

    public Map<String, byte[]> getClassBytes() {
        return new HashMap<String, byte[]>(this.classBytes);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.classBytes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JavaFileObject> getLibJarsOptions(String packgeName) {
        Object object = lock;
        synchronized (object) {
            if (!isInit) {
                this.init();
            }
        }
        return CLASS_OBJECT_PACKAGE_MAP.get(packgeName);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        List<JavaFileObject> result;
        if ("CLASS_PATH".equals(location.getName()) && ManateeClassLoader.isJar() && (result = this.getLibJarsOptions(packageName)) != null) {
            return result;
        }
        Iterable<JavaFileObject> it = super.list(location, packageName, kinds, recurse);
        if (kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            List<JavaFileObject> javaFileObjectList = this.classObjectPackageMap.get(packageName);
            if (javaFileObjectList != null) {
                if (it != null) {
                    for (JavaFileObject javaFileObject : it) {
                        javaFileObjectList.add(javaFileObject);
                    }
                }
                return javaFileObjectList;
            }
            return it;
        }
        return it;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof MemoryInputJavaClassObject) {
            return ((MemoryInputJavaClassObject)file).inferBinaryName();
        }
        return super.inferBinaryName(location, file);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (kind == JavaFileObject.Kind.CLASS) {
            return new MemoryOutputJavaClassObject(className);
        }
        return super.getJavaFileForOutput(location, className, kind, sibling);
    }

    JavaFileObject makeStringSource(String className, final String code) {
        String classPath = className.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension;
        return new SimpleJavaFileObject(URI.create("string:///" + classPath), JavaFileObject.Kind.SOURCE){

            @Override
            public CharBuffer getCharContent(boolean ignoreEncodingErrors) {
                return CharBuffer.wrap(code);
            }
        };
    }

    void makeBinaryClass(String className, byte[] bs) {
        List<JavaFileObject> javaFileObjectList;
        MemoryInputJavaClassObject javaFileObject = new MemoryInputJavaClassObject(className, bs);
        String packageName = "";
        int pos = className.lastIndexOf(46);
        if (pos > 0) {
            packageName = className.substring(0, pos);
        }
        if ((javaFileObjectList = this.classObjectPackageMap.get(packageName)) == null) {
            javaFileObjectList = new LinkedList<JavaFileObject>();
            javaFileObjectList.add(javaFileObject);
            this.classObjectPackageMap.put(packageName, javaFileObjectList);
        } else {
            javaFileObjectList.add(javaFileObject);
        }
    }

    class MemoryOutputJavaClassObject
    extends SimpleJavaFileObject {
        final String className;

        MemoryOutputJavaClassObject(String className) {
            super(URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.CLASS.extension), JavaFileObject.Kind.CLASS);
            this.className = className;
        }

        @Override
        public OutputStream openOutputStream() {
            return new FilterOutputStream(new ByteArrayOutputStream()){

                @Override
                public void close() throws IOException {
                    this.out.close();
                    ByteArrayOutputStream bos = (ByteArrayOutputStream)this.out;
                    byte[] bs = bos.toByteArray();
                    ManateeJavaFileManager.this.classBytes.put(MemoryOutputJavaClassObject.this.className, bs);
                    ManateeJavaFileManager.this.makeBinaryClass(MemoryOutputJavaClassObject.this.className, bs);
                }
            };
        }
    }

    class MemoryInputJavaClassObject
    extends SimpleJavaFileObject {
        final String className;
        final byte[] bs;

        MemoryInputJavaClassObject(String className, byte[] bs) {
            super(URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.CLASS.extension), JavaFileObject.Kind.CLASS);
            this.className = className;
            this.bs = bs;
        }

        @Override
        public InputStream openInputStream() {
            return new ByteArrayInputStream(this.bs);
        }

        public String inferBinaryName() {
            return this.className;
        }
    }
}

