/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.java.process;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.CryptoUtils;
import com.manatee.lowcode.java.manager.IJavaCode;
import com.manatee.lowcode.java.manager.JavaProcessManager;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.execute.DebugUtil;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class JavaProcess
implements IProcess {
    private static Logger LOGGER = LoggerFactory.getLogger(JavaProcess.class);
    @Resource
    private JavaProcessManager javaProcessManager;
    @Resource
    private ProcessConfUtil processConfUtil;

    public void process(ProcessContent processContent) throws BizException {
        this.processConfUtil.checkConf(processContent, new String[]{"javaCode"});
        String id = processContent.getStep().getId().replaceAll("-", "");
        String importStr = processContent.getStepConf().getString("import");
        String javaCodeStr = processContent.getStepConf().getString("javaCode");
        String resourceStr = processContent.getStepConf().getString("resource");
        String valueStr = processContent.getStepConf().getString("value");
        importStr = StringUtils.isEmpty((CharSequence)importStr) ? "" : importStr;
        javaCodeStr = StringUtils.isEmpty((CharSequence)javaCodeStr) ? "" : javaCodeStr;
        resourceStr = StringUtils.isEmpty((CharSequence)resourceStr) ? "" : resourceStr;
        valueStr = StringUtils.isEmpty((CharSequence)valueStr) ? "" : valueStr;
        String beanName = DebugUtil.isDebug((ProcessContent)processContent) ? "debug_" + id : "run_" + id;
        String formatCode = JavaProcessManager.formatCode(importStr, beanName, javaCodeStr, resourceStr, valueStr);
        String version = CryptoUtils.encodeMD5((String)formatCode);
        IJavaCode javaCode = (IJavaCode)this.javaProcessManager.getBean(beanName);
        if (javaCode != null && this.javaProcessManager.checkVersion(version, javaCode).booleanValue()) {
            try {
                LOGGER.debug("java process execute, lowcodeProjectId:\u3010{}\u3011, lowcodeCode:\u3010{}\u3011, beanName:\u3010{}\u3011", new Object[]{processContent.getProjectId(), processContent.getCode(), beanName});
                javaCode.execute(processContent);
            }
            catch (Exception e) {
                BizException bizException = new BizException((Throwable)e);
                throw bizException;
            }
        } else {
            this.runMethod(javaCode, processContent, importStr, javaCodeStr, resourceStr, valueStr, beanName, formatCode, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMethod(IJavaCode javaCode, ProcessContent processContent, String importStr, String javaCodeStr, String resourceStr, String valueStr, String beanName, String formatCode, String version) throws BizException {
        String string = beanName;
        synchronized (string) {
            javaCode = (IJavaCode)this.javaProcessManager.getBean(beanName);
            if (javaCode != null && version.equals(javaCode.getManateeJavaCodeVersion())) {
                LOGGER.debug("JavaProcess execute, beanName:\u3010{}\u3011", (Object)beanName);
                try {
                    javaCode.execute(processContent);
                }
                catch (Exception e) {
                    if (e.getMessage() == null) {
                        throw new BizException(ResultCode.CONF_ERROR, e.getCause().getMessage());
                    }
                    throw new BizException(ResultCode.CONF_ERROR, e.getMessage());
                }
                return;
            }
            if (javaCode != null) {
                LOGGER.debug("JavaProcess removeBeanDefinition, beanName:\u3010{}\u3011", (Object)beanName);
                this.javaProcessManager.removeBeanDefinition(beanName);
            }
            Class clazz = this.javaProcessManager.createIJavaCode(importStr, javaCodeStr, resourceStr, valueStr, beanName, formatCode, null);
            LOGGER.debug("JavaProcess registerSingleton, beanName:\u3010{}\u3011", (Object)beanName);
            javaCode = this.javaProcessManager.registerSingleton(clazz, beanName, version);
            try {
                javaCode.execute(processContent);
            }
            catch (Exception e) {
                if (e.getMessage() == null) {
                    throw new BizException(ResultCode.CONF_ERROR, e.getCause().getMessage());
                }
                throw new BizException(ResultCode.CONF_ERROR, e.getMessage());
            }
        }
    }

    public String getName() {
        return "javaProcess";
    }
}

