/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.java.manager;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.CryptoUtils;
import com.manatee.lowcode.constant.CompilerTypeEnum;
import com.manatee.lowcode.constant.JavaCompilerSo;
import com.manatee.lowcode.java.manager.IJavaCode;
import com.manatee.lowcode.java.springCompiler.ManateeClassLoader;
import com.manatee.process.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.stereotype.Service;

@Service
public class JavaProcessManager
implements BeanFactoryAware {
    private static Logger LOGGER = LoggerFactory.getLogger(JavaProcessManager.class);
    public static final Pattern FUN_PATTERN = Pattern.compile("_fun\\.");
    private static DefaultListableBeanFactory listableBeanFactory;
    public static String CODE_TEMPLATE;
    public static String PATH;

    @Deprecated
    public Class createIJavaCode(String importStr, String javaCodeStr, String resourceStr, String valueStr, String className, String formatCode, byte[] compilerData) throws BizException {
        HashMap<String, Object> errorInfo = new HashMap<String, Object>();
        try {
            String formatPath = String.format(PATH, className);
            ManateeClassLoader loader = ManateeClassLoader.getInstrance();
            loader.registerJava(formatPath, formatCode, errorInfo, compilerData);
            Class<?> clazz = loader.findClass(formatPath);
            return clazz;
        }
        catch (Exception e) {
            LOGGER.error("createIJavaCode error", (Throwable)e);
            String message = this.getMessage(errorInfo, importStr, javaCodeStr, resourceStr, valueStr);
            throw new BizException(ResultCode.CONF_ERROR, message);
        }
    }

    public Class createIJavaCode(JavaCompilerSo javaCompilerSo) throws BizException {
        try {
            String formatPath = String.format(PATH, javaCompilerSo.getBeanName());
            javaCompilerSo.setPath(formatPath);
            ManateeClassLoader loader = ManateeClassLoader.getInstrance();
            loader.registerJava(javaCompilerSo);
            Class<?> clazz = loader.findClass(formatPath);
            return clazz;
        }
        catch (Exception e) {
            LOGGER.error("createIJavaCode error", (Throwable)e);
            String message = this.getMessage(javaCompilerSo.getErrorInfo(), javaCompilerSo.getImportStr(), javaCompilerSo.getJavaCodeStr(), javaCompilerSo.getResourceStr(), javaCompilerSo.getValueStr());
            throw new BizException(ResultCode.CONF_ERROR, message);
        }
    }

    public JSONObject createIJavaCodeForDebug(String importStr, String javaCodeStr, String resourceStr, String valueStr, String className, String formatCode) throws BizException {
        JSONObject jsonObject;
        block3: {
            jsonObject = new JSONObject();
            try {
                jsonObject.put("success", (Object)true);
                jsonObject.put("briefInfo", (Object)"\u7f16\u8bd1\u901a\u8fc7");
                this.createIJavaCode(importStr, javaCodeStr, resourceStr, valueStr, className, formatCode, null);
            }
            catch (Exception e) {
                LOGGER.warn("createIJavaCodeForDebug error", (Throwable)e);
                jsonObject.put("success", (Object)false);
                String message = e.getMessage();
                if (StringUtil.isNotBlank((String)message)) {
                    String[] split = message.split("\uff1a");
                    jsonObject.put("briefInfo", (Object)split[0]);
                    jsonObject.put("descInfo", (Object)message);
                }
                Throwable cause = e.getCause();
                if (cause == null) break block3;
                String causeMessage = cause.getMessage();
                jsonObject.put("briefInfo", (Object)causeMessage);
                jsonObject.put("descInfo", (Object)causeMessage);
            }
        }
        return jsonObject;
    }

    public byte[] compile(ManateeClassLoader loader, String className, String javaStr) throws BizException {
        try {
            Map<String, byte[]> compile = loader.compile(className, javaStr, null);
            return compile.get("com.manatee.lowcode.java.manager.impl." + className);
        }
        catch (Exception e) {
            LOGGER.error("compile error, className:\u3010{}\u3011", (Object)className, (Object)e);
            throw new BizException(ResultCode.PARAM_IS_ERROR, (Throwable)e);
        }
    }

    public Class load(ManateeClassLoader loader, String className, byte[] buf) throws BizException {
        try {
            Class<?> clazz = loader.findClass(className, buf);
            return clazz;
        }
        catch (Exception e) {
            LOGGER.error("load error, className:\u3010{}\u3011", (Object)className, (Object)e);
            throw new BizException(ResultCode.PARAM_IS_ERROR, (Throwable)e);
        }
    }

    private String getMessage(Map<String, Object> errorInfo, String importStr, String codeStr, String resourceStr, String valueStr) {
        int length;
        String[] split;
        Integer lineNumber = Integer.parseInt(errorInfo.get("LineNumber").toString());
        String errorMessage = (String)errorInfo.get("Message");
        if (lineNumber <= 8) {
            return "java \u4ee3\u7801\u7f16\u8bd1\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7f16\u8bd1\u73af\u5883\u662f\u5426\u6b63\u5e38\u4ee5\u53ca\u7248\u672c\u662f\u5426\u5339\u914d";
        }
        StringBuilder msg = new StringBuilder();
        lineNumber = lineNumber - 9;
        if (StringUtil.isNotBlank((String)importStr)) {
            split = importStr.split("\\n");
            length = split.length;
            if (lineNumber <= length) {
                msg.append("\u7f16\u8bd1\u5931\u8d25\u4e8e[import]\u4e2d\u7b2c[").append(lineNumber).append("]\u884c\uff1a[").append(split[lineNumber - 1]).append("]\u3002[").append(errorMessage).append("]");
                return msg.toString();
            }
            lineNumber = lineNumber - length;
        } else {
            lineNumber = lineNumber - 1;
        }
        if (StringUtil.isNotBlank((String)codeStr)) {
            split = codeStr.split("\\n");
            lineNumber = lineNumber - 6;
            length = split.length;
            if (lineNumber <= length) {
                msg.append("\u7f16\u8bd1\u5931\u8d25\u4e8e[java\u4ee3\u7801]\u4e2d\u7b2c[").append(lineNumber).append("]\u884c\uff1a[").append(split[lineNumber - 1]).append("]\u3002[").append(errorMessage).append("]");
                return msg.toString();
            }
            lineNumber = lineNumber - length - 5;
        }
        if (StringUtil.isNotBlank((String)resourceStr)) {
            split = resourceStr.split("\\n");
            length = split.length;
            if (lineNumber <= length) {
                msg.append("\u7f16\u8bd1\u5931\u8d25\u4e8e[resource]\u4e2d\u7b2c[").append(lineNumber).append("]\u884c\uff1a[").append(split[lineNumber - 1]).append("]\u3002[").append(errorMessage).append("]");
                return msg.toString();
            }
            lineNumber = lineNumber - length;
        } else {
            lineNumber = lineNumber - 1;
        }
        if (StringUtil.isNotBlank((String)valueStr)) {
            split = valueStr.split("\\n");
            length = split.length;
            if (lineNumber <= length) {
                msg.append("\u7f16\u8bd1\u5931\u8d25\u4e8e[value]\u4e2d\u7b2c[").append(lineNumber).append("]\u884c\uff1a[").append(split[lineNumber - 1]).append("]\u3002[").append(errorMessage).append("]");
                return msg.toString();
            }
        }
        return "java \u4ee3\u7801\u7f16\u8bd1\u5931\u8d25";
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        listableBeanFactory = (DefaultListableBeanFactory)beanFactory;
    }

    public <T> T registerSingleton(Class<T> clazz, String beanName) {
        Object bean = listableBeanFactory.createBean(clazz);
        listableBeanFactory.registerSingleton(beanName, bean);
        return (T)bean;
    }

    public IJavaCode registerSingleton(Class<IJavaCode> clazz, String beanName, String version) {
        IJavaCode bean = (IJavaCode)listableBeanFactory.createBean(clazz);
        bean.setManateeJavaCodeVersion(version);
        listableBeanFactory.registerSingleton(beanName, (Object)bean);
        return bean;
    }

    public <T> T registerBeanDefinition(Class<T> clazz, String beanName) {
        Object bean = listableBeanFactory.createBean(clazz);
        listableBeanFactory.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(clazz).getBeanDefinition());
        return (T)bean;
    }

    public void removeBeanDefinition(String beanName) {
        try {
            listableBeanFactory.destroySingleton(beanName);
        }
        catch (Exception e) {
            LOGGER.error("removeBeanDefinition error ", (Throwable)e);
            return;
        }
    }

    public void removeBean(String beanName) {
        try {
            listableBeanFactory.removeBeanDefinition(beanName);
            listableBeanFactory.destroySingleton(beanName);
        }
        catch (Exception e) {
            LOGGER.error("removeBeanDefinition error ", (Throwable)e);
            return;
        }
    }

    public static String formatCode(String importStr, String beanName, String javaCodeStr, String resourceStr, String valueStr) {
        String formatCode = String.format(CODE_TEMPLATE, importStr, beanName, javaCodeStr, resourceStr, valueStr, beanName);
        Matcher matcher = FUN_PATTERN.matcher(formatCode);
        while (matcher.find()) {
            int funIndex = formatCode.indexOf("_fun.") + 5;
            int funNameIndex = formatCode.indexOf("(", funIndex);
            String ykh = formatCode.substring(funNameIndex + 1, funNameIndex + 2);
            String funName = formatCode.substring(funIndex, funNameIndex);
            if (")".equals(ykh)) {
                formatCode = formatCode.replaceFirst("_fun." + funName + "\\(", "doFun(\"" + funName + "\"");
                continue;
            }
            formatCode = formatCode.replaceFirst("_fun." + funName + "\\(", "doFun(\"" + funName + "\",");
        }
        return formatCode;
    }

    public <T> T getBean(String beanName) {
        try {
            return (T)listableBeanFactory.getBean(beanName);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    public boolean checkVersionAndLoad(Map<String, Object> lowcodeCompiler, String inStepCodeVsersion) throws BizException {
        if (lowcodeCompiler == null || lowcodeCompiler.get("compiler_data") == null) {
            return false;
        }
        String compilerCode = (String)lowcodeCompiler.get("compiler_code");
        String newVersion = CryptoUtils.encodeMD5((String)compilerCode);
        if (!inStepCodeVsersion.equals(newVersion)) {
            return false;
        }
        String beanName = (String)lowcodeCompiler.get("bean_name");
        IJavaCode javaBean = (IJavaCode)this.getBean(beanName);
        if (javaBean == null) {
            this.load(lowcodeCompiler);
            return true;
        }
        if (this.checkVersion(javaBean, lowcodeCompiler).booleanValue()) {
            return true;
        }
        this.removeBeanDefinition(beanName);
        this.load(lowcodeCompiler);
        return true;
    }

    public Object load(Map<String, Object> lowcodeCompiler) throws BizException {
        String beanName = (String)lowcodeCompiler.get("bean_name");
        String compilerCode = (String)lowcodeCompiler.get("compiler_code");
        Integer compilerType = (Integer)lowcodeCompiler.get("compiler_type");
        if (StringUtil.isBlank((String)beanName) || StringUtil.isBlank((String)compilerCode)) {
            String id = (String)lowcodeCompiler.get("id");
            throw new BizException(ResultCode.CONF_ERROR, "compiler_id:" + id + ", beanName or compilerCode is null");
        }
        byte[] compilerData = (byte[])lowcodeCompiler.get("compiler_data");
        ManateeClassLoader loader = ManateeClassLoader.getInstrance();
        String classFullPth = String.format(PATH, beanName);
        if (CompilerTypeEnum.SPRING_COMPILER.getCode() == compilerType.intValue() || CompilerTypeEnum.JAVA_CLASS_COMPILER.getCode() == compilerType.intValue()) {
            classFullPth = (String)lowcodeCompiler.get("ext1");
        }
        if (compilerData == null || compilerData.length <= 0) {
            HashMap<String, Object> errorInfo = new HashMap<String, Object>();
            Map<String, byte[]> newClassMap = loader.compile(classFullPth, compilerCode, errorInfo, true);
            compilerData = newClassMap.get(classFullPth);
            lowcodeCompiler.put("compiler_data", compilerData);
        }
        LOGGER.debug("java compiler load beanName:\u3010{}\u3011", (Object)beanName);
        Class<IJavaCode> clazz = loader.findClass(classFullPth, compilerData);
        if (CompilerTypeEnum.SPRING_COMPILER.getCode() == compilerType.intValue() || CompilerTypeEnum.JAVA_CLASS_COMPILER.getCode() == compilerType.intValue()) {
            return this.registerBeanDefinition(clazz, beanName);
        }
        String version = CryptoUtils.encodeMD5((String)compilerCode);
        IJavaCode javaBean = this.registerSingleton(clazz, beanName, version);
        return javaBean;
    }

    private Boolean checkVersion(IJavaCode javaCode, Map<String, Object> map) {
        if (javaCode == null) {
            return false;
        }
        String compilerCode = (String)map.get("compiler_code");
        String newVersion = CryptoUtils.encodeMD5((String)compilerCode);
        String oldVersion = javaCode.getManateeJavaCodeVersion();
        if (!oldVersion.equals(newVersion)) {
            return false;
        }
        return true;
    }

    public Boolean checkVersion(IJavaCode javaCode, String compilerCode) {
        String newVersion = CryptoUtils.encodeMD5((String)compilerCode);
        return this.checkVersion(newVersion, javaCode);
    }

    public Boolean checkVersion(String newVersion, IJavaCode javaCode) {
        if (javaCode == null || newVersion == null) {
            return false;
        }
        String oldVersion = javaCode.getManateeJavaCodeVersion();
        if (!newVersion.equals(oldVersion)) {
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("com.manatee.lowcode.java.manager.impl.StrUtils", 1);
        System.out.println(map.get("com.manatee.lowcode.java.manager.impl.StrUtils"));
    }

    static {
        CODE_TEMPLATE = "package com.manatee.lowcode.java.manager.impl;\nimport com.manatee.common.exception.BizException;\nimport com.manatee.lowcode.java.manager.IJavaCode;\nimport com.manatee.process.domain.ProcessContent;\nimport org.springframework.stereotype.Service;\nimport javax.annotation.Resource;\nimport org.springframework.beans.factory.annotation.Autowired;\nimport org.springframework.beans.factory.annotation.Value;\nimport com.manatee.lowcode.java.manager.JavaCodeBase;\n%s\n@Service\npublic class %s extends JavaCodeBase implements IJavaCode {\n    @Override\n    public void execute(ProcessContent content) throws Exception {\n        try {\n           putContent(content);\n           %s\n        } catch (Exception e){           throw e;        } finally {           clearContent();         }    }\n%s\n%s\n    @Override\n    public String getName() {\n        return \"%s\";\n    }\n}";
        PATH = "com.manatee.lowcode.java.manager.impl.%s";
    }
}

