/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.dameng.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcodedb.base.DBReadUtil;
import com.manatee.lowcodedb.config.ManateeDataSource;
import com.manatee.lowcodedb.newdb.meta.MetaUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

public class DamengProcessUtil {
    @Resource
    private ManateeDataSource manateeDataSource;
    @Resource
    private DBReadUtil dbReadUtil;

    public JSON cascadeQuery(DBQuery dbQuery, JSON data) throws BizException, SQLException {
        JSONArray cascadeArray;
        String schema;
        Connection connection = null;
        try {
            connection = this.manateeDataSource.getConnection("default");
            schema = MetaUtil.getSchema((Connection)connection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (schema.equals(dbQuery.getDb())) {
            dbQuery.setDb("default");
        }
        if ((cascadeArray = dbQuery.getCascade()) == null || cascadeArray.size() == 0) {
            return data;
        }
        if (data == null) {
            return data;
        }
        if (data instanceof List || data instanceof JSONArray) {
            JSONArray dataArray = (JSONArray)data;
            if (dataArray.size() == 0) {
                return data;
            }
            Boolean camelCase = dbQuery.getCamelCase();
            String upperOrLowerCase = dbQuery.getUpperOrLowerCase();
            for (Object cascadeConfObj : cascadeArray) {
                JSONObject cascadeConf = (JSONObject)cascadeConfObj;
                String cascadeKey = cascadeConf.getString("cascadeKey");
                cascadeKey = this.getCascadeKey(camelCase, upperOrLowerCase, cascadeKey);
                String beCascadeedKey = cascadeConf.getString("beCascadeedKey");
                ArrayList cascade = this.dbReadUtil.findCascade(dbQuery, data, cascadeConf);
                if (cascade == null) {
                    cascade = new ArrayList();
                }
                beCascadeedKey = this.getCascadeKey(camelCase, upperOrLowerCase, beCascadeedKey);
                HashMap groupByMap = new HashMap();
                for (Map resuletMap : cascade) {
                    Object o = resuletMap.get(beCascadeedKey);
                    ArrayList<Map> list = (ArrayList<Map>)groupByMap.get(o);
                    if (list == null) {
                        list = new ArrayList<Map>();
                    }
                    list.add(resuletMap);
                    groupByMap.put(o, list);
                }
                String cascadeVal = cascadeConf.getString("cascadeVal");
                for (Object o : dataArray) {
                    Map dataItem = (Map)o;
                    Object cascadeKeyObj = dataItem.get(cascadeKey);
                    Object cascadeGroup = groupByMap.get(cascadeKeyObj);
                    if (StringUtil.isBlank((String)cascadeVal)) {
                        String table = cascadeConf.getString("table") + "_list";
                        cascadeVal = this.dbReadUtil.camelCase(table.toLowerCase());
                    }
                    if (cascadeGroup == null) {
                        cascadeGroup = new ArrayList();
                    }
                    dataItem.put(cascadeVal, cascadeGroup);
                }
            }
        } else {
            JSONObject result = (JSONObject)data;
            for (Object cascadeConfObj : cascadeArray) {
                JSONObject cascadeConf = (JSONObject)cascadeConfObj;
                List cascade = this.dbReadUtil.findCascade(dbQuery, data, cascadeConf);
                String cascadeVal = cascadeConf.getString("cascadeVal");
                if (StringUtil.isBlank((String)cascadeVal)) {
                    String table = cascadeConf.getString("table") + "_list";
                    cascadeVal = this.dbReadUtil.camelCase(table.toLowerCase());
                }
                result.put(cascadeVal, (Object)cascade);
            }
        }
        return data;
    }

    private String getCascadeKey(Boolean camelCase, String upperOrLowerCase, String fieldName) {
        if (StringUtil.isNotBlank((String)upperOrLowerCase) && "upperCase".equals(upperOrLowerCase)) {
            fieldName = fieldName.toUpperCase();
        }
        if (StringUtil.isNotBlank((String)upperOrLowerCase) && "lowerCase".equals(upperOrLowerCase)) {
            fieldName = fieldName.toLowerCase();
        }
        if (camelCase.booleanValue() && fieldName.indexOf("_") != -1) {
            fieldName = this.dbReadUtil.camelCase(fieldName.toLowerCase());
            return fieldName;
        }
        return fieldName;
    }
}

