/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.process;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.manager.COSFileUploadManager;
import com.manatee.lowcode.process.store.fileupload.FileUploadProcess;
import com.manatee.lowcode.process.store.handle.ManateeFileHandle;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.ProcessFileInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class COSFileUploadProcess
implements IProcess {
    private static Logger LOGGER = LoggerFactory.getLogger(FileUploadProcess.class);
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private COSFileUploadManager cosFileUploadManager;
    @Resource
    private ManateeFileHandle manateeFileHandle;

    public void process(ProcessContent content) throws BizException {
        String bucketName = this.variableUtil.calVarInConf(content, "bucketName");
        String folder = this.variableUtil.calVarInConf(content, "folder");
        String base64Key = this.variableUtil.calVarInConf(content, "base64");
        Object base64Value = content.getValue(base64Key);
        String fileSource = content.getStepConf().getString("fileSource");
        Boolean needDel = content.getStepConf().getBoolean("needDel");
        Boolean autoCover = content.getStepConf().getBoolean("autoCover");
        ArrayList fileInfos = new ArrayList();
        if (StringUtil.isBlank((String)fileSource)) {
            fileSource = "request";
        }
        this.manateeFileHandle.getContentFiles(content, fileSource, needDel, autoCover, fileInfos);
        String url = "";
        if (fileInfos != null && fileInfos.size() > 0) {
            for (ProcessFileInfo fileInfo : fileInfos) {
                try {
                    String fileName = fileInfo.getFileName();
                    InputStream fileInfoInputStream = fileInfo.getInputStream();
                    String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
                    url = this.cosFileUploadManager.uploadFile(fileInfoInputStream, bucketName, folder, suffix);
                    File file = fileInfo.getFile();
                    if (!fileInfo.getNeedDel().booleanValue() || file == null || !file.exists()) continue;
                    file.delete();
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    if (fileInfo.getInputStream() == null) continue;
                    try {
                        fileInfo.getInputStream().close();
                    }
                    catch (IOException e) {
                        LOGGER.error("fileUpload error", (Throwable)e);
                    }
                }
            }
        } else if (base64Value != null && StringUtil.isNotBlank((String)base64Value.toString())) {
            String[] base64Array = base64Value.toString().split(";");
            String base = base64Array[1].split(",")[1];
            String suffix = base64Array[0].split("/")[1];
            url = this.cosFileUploadManager.uploadFileBase(base, bucketName, folder, suffix);
        } else {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "file/base64 \u672a\u586b");
        }
        this.outputUtil.setDefaultReturnKey(content, "url");
        this.outputUtil.putData(content, (Object)url);
    }

    public String getName() {
        return "cosFileUpload";
    }
}

