/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.kafka.config;

import com.manatee.common.util.StringUtil;
import com.manatee.config.ManateeConfig;
import com.manatee.kafka.process.KfakaConsumerRunnable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ManateeKfakaConfig {
    public static Map<String, KfakaConsumerRunnable> kafkaConsumerRunnablePool = new ConcurrentHashMap<String, KfakaConsumerRunnable>();
    @Resource
    private ManateeConfig manateeConfig;

    public Map<String, Object> consumerConfigs() {
        HashMap<String, Object> propsMap = new HashMap<String, Object>();
        String bootstrapServers = this.manateeConfig.getKafka().getBootstrapServers();
        String groupId = this.manateeConfig.getKafka().getConsumer().getGroupId();
        String autoOffsetReset = this.manateeConfig.getKafka().getConsumer().getAutoOffsetReset();
        propsMap.put("bootstrap.servers", bootstrapServers);
        propsMap.put("enable.auto.commit", false);
        propsMap.put("auto.commit.interval.ms", 1000);
        propsMap.put("session.timeout.ms", 100000);
        propsMap.put("request.timeout.ms", 110000);
        propsMap.put("key.deserializer", StringDeserializer.class);
        propsMap.put("value.deserializer", StringDeserializer.class);
        propsMap.put("group.id", groupId);
        propsMap.put("auto.offset.reset", autoOffsetReset);
        propsMap.put("max.poll.records", 1000);
        propsMap.put("fetch.max.wait.ms", 5000);
        return propsMap;
    }

    @Bean
    public AdminClient getAdminClient() {
        AdminClient adminClient;
        Properties properties = new Properties();
        String bootstrapServers = this.manateeConfig.getKafka().getBootstrapServers();
        if (StringUtil.isNotBlank((String)bootstrapServers)) {
            properties.put("bootstrap.servers", bootstrapServers);
            properties.put("key.deserializer", StringDeserializer.class);
            properties.put("value.deserializer", StringDeserializer.class);
            adminClient = AdminClient.create((Properties)properties);
        } else {
            adminClient = null;
        }
        return adminClient;
    }
}

